/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "../syncml.h"
#include "../syncml_internals.h"
#include "../sml_error_internals.h"

#include <libsyncml/data_sync_api/defines.h>
#include <libsyncml/data_sync_api/standard.h>
#include <libsyncml/data_sync_api/callbacks.h>

#include "data_sync.h"

/**
 * This code is put into a separate source code file
 * because potentially all internal tricks and hacks
 * are used to abort the OMA DS session most carefully
 * ... at minimum in the future ...
 */

#include "../sml_session_internals.h"
#include "../sml_manager_internals.h"

SmlBool smlDataSyncAbort(
			SmlDataSyncObject *dsObject, 
			SmlError **error)
{
	smlTrace(TRACE_ENTRY, "%s", __func__);

	/* determine the state of the session */
	if (!dsObject->session->sending && !dsObject->session->waiting)
	{
		/* send abort command */
		smlTrace(TRACE_INTERNAL, "%s: A careful abort is possible.", __func__);
		/* FIXME: Send a default abort command. */
		/* FIXME: Is it necessary or recommended to abort every datastore. */
		goto WORKAROUND;
	} else {
		/* stop transport */
WORKAROUND:
		smlTrace(TRACE_INTERNAL, "%s: A hard abort is required.", __func__);

		if (SML_DATA_SYNC_STATE_CONNECTED <= dsObject->internalState &&
		    dsObject->internalState < SML_DATA_SYNC_STATE_DISCONNECT_IN_PROGRESS)
		{
			dsObject->internalState = SML_DATA_SYNC_STATE_DISCONNECT_IN_PROGRESS;

			SmlLink *link_ = smlManagerSessionGetLink(
						dsObject->manager,
						dsObject->session,
						error);
			if (!link_ && *error)
				goto error;

			if (!smlTransportDisconnect(dsObject->tsp, link_, error))
				goto error;
		}
	}

	smlTrace(TRACE_EXIT, "%s", __func__);
	return TRUE;
error:
	smlTrace(TRACE_EXIT_ERROR, "%s - %s", __func__, smlErrorPrint(error));
	return FALSE;
}

