/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup XmlPrivate Internal details of XML/WBXML API
 * @ingroup Xml
 * @brief XML/WBXML API private part
 * 
 */
/**
 * @defgroup XmlParserPrivate XML Parser Internals
 * @ingroup XmlPrivate
 * @brief XML parser details only known inside the internal XML/WBXML API.
 * 
 */
/*@{*/
 
#ifndef _SML_XML_PARSE_INTERNALS_H_
#define _SML_XML_PARSE_INTERNALS_H_

#include <libxml/xmlreader.h>
#include <libxml/xmlwriter.h>

#define XML_NODE_START 1
#define XML_NODE_TEXT 3
#define XML_NODE_CLOSE 15
#define XML_NODE_CDATA 4

struct SmlXmlParser {
	/** The version of the last parsed document */
	SmlProtocolVersion version;
	xmlTextReader *reader;
	char *data;
	unsigned int size;
	SmlTransport *tsp;
	SmlMimeType type;
	SmlBool got_command;
	SmlBool gotMoreData;
};

SmlBool smlParserStep(SmlParser *parser);
SmlBool smlParserExpectNode(SmlParser *parser, int type, SmlBool empty, const char *name, SmlError **error);
SmlBool smlParserGetID(SmlParser *parser, unsigned int *id, const char *name, SmlError **error);
SmlBool smlParserGetString(SmlParser *parser, char **string, const char *name, SmlError **error);
SmlBool smlParserGetData(SmlParser *parser, char **string, unsigned int *size, const char *name, SmlError **error);

#endif //_SML_XML_PARSE_INTERNALS_H_
/*@}*/
