/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlQueuePrivate SyncML Queue Internals
 * @ingroup PrivateLowLevelAPI
 * @brief The private part
 * 
 */
/*@{*/

#ifndef _SML_QUEUE_INTERNALS_H_
#define _SML_QUEUE_INTERNALS_H_

typedef void (*SmlQueueHandler)(void *message, void *userdata);

/*! @brief Represents a Queue which can be used to receive messages
 */
typedef struct SmlQueue {
	/** The items of the queue **/
	GList *head;
	GList *tail;
	
	GList *prio;
	/** The message handler for this queue **/
	SmlQueueHandler handler;
	/** The user_data associated with this queue **/
	void *userdata;
	/** The source associated with this queue */
	GSource *source;
	/** The context in which this queue is dispatched */
	GMainContext *context;
	GSourceFuncs *functions;
	GMutex *mutex;
} SmlQueue;

SmlQueue *smlQueueNew(SmlError **error);
void smlQueueFree(SmlQueue *queue);
void smlQueueFlush(SmlQueue *queue);
void smlQueueSetHandler(SmlQueue *queue, SmlQueueHandler handler, void *userdata);
void smlQueueSend(SmlQueue *queue, void *data);
void smlQueueAttach(SmlQueue *queue, GMainContext *context);
void smlQueueDetach(SmlQueue *queue);
void smlQueueDispatch(SmlQueue *queue);
void *smlQueueTryPop(SmlQueue *queue);
SmlBool smlQueueCheck(SmlQueue *queue);
void smlQueuePushHead(SmlQueue *queue, void *data);
SmlBool smlQueueIsAttached(SmlQueue *queue);
void smlQueueLock(SmlQueue *queue);
void smlQueueUnlock(SmlQueue *queue);
void *smlQueuePeek(SmlQueue *queue);
GList *smlQueuePeekNext(SmlQueue *queue, GList *prev);
void *smlQueueTryPopPrio(SmlQueue *queue);
void smlQueuePushHeadPrio(SmlQueue *queue, void *data);
void smlQueueSendPrio(SmlQueue *queue, void *data);
SmlBool smlQueueCheckPrio(SmlQueue *queue);
void smlQueueDispatchPrio(SmlQueue *queue);
void *smlQueuePeekPrio(SmlQueue *queue);
void smlQueuePrint(SmlQueue *queue);
unsigned int smlQueueLength(SmlQueue *queue);
unsigned int smlQueueLengthPrio(SmlQueue *queue);

#endif //_SML_QUEUE_INTERNALS_H_

/*@}*/
