#!/bin/sh
#
# lang2h.sh - convert a RFC 3066 language table to a C header
#
# Copyright (C) 2005 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

cat <<EOF
/*
 * translate-rfc3066-private.h - RFC 3066 tag to name mappings
 *
 * Generated automatically by lang2h.sh.
 * Do not edit this file directly.
 */

#ifndef _TRANSLATE_RFC3066_PRIVATE_H
#define _TRANSLATE_RFC3066_PRIVATE_H

static void
translate_rfc3066_init (GHashTable *table)
{
  g_return_if_fail(table != NULL);
EOF

insert_tag () {
    echo "  g_hash_table_insert(table, \"$1\", _(\"$2\"));"
}

IFS="|"
while read tag english_name french_name; do
    echo "  g_hash_table_insert(table, \"$tag\", _(\"$english_name\"));"
done

cat <<EOF
}

#endif /* _TRANSLATE_RFC3066_PRIVATE_H */
EOF
