
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ListColourTechniqueAttributes.h
    \\brief Definition of ListColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "ListColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ListColourTechniqueAttributes::ListColourTechniqueAttributes():
	colours_(ParameterManager::getStringArray("contour_shade_colour_list")),
	reverse_(ParameterManager::getBool("contour_shade_colour_reverse_list"))
	,
	list_policy_(MagTranslator<string, ColourListPolicy>().magics("contour_shade_colour_list_policy"))
	
{
}


ListColourTechniqueAttributes::~ListColourTechniqueAttributes()
{

}


void ListColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	setAttribute(prefix, "contour_shade_colour_list", colours_, params);
	setAttribute(prefix, "contour_shade_colour_reverse_list", reverse_, params);
	
	setAttribute(prefix, "contour_shade_colour_list_policy", list_policy_, params);
	
}

void ListColourTechniqueAttributes::copy(const ListColourTechniqueAttributes& other)
{
	colours_ = other.colours_;
	reverse_ = other.reverse_;
	list_policy_ = other.list_policy_;
	
}


bool ListColourTechniqueAttributes::accept(const string& node)
{

	if ( magCompare(node, "list")  )
		return true;
	
	return false;
}

void ListColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "list")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void ListColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " colours = " <<  colours_;
	out << " reverse = " <<  reverse_;
	out << " list_policy = " <<  list_policy_;
	
	out << "]" << "\n";
}

void ListColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"list\"";
	out << ", \"contour_shade_colour_list\":";
	niceprint(out,colours_);
	out << ", \"contour_shade_colour_reverse_list\":";
	niceprint(out,reverse_);
	out << ", \"contour_shade_colour_list_policy\":";
	niceprint(out, list_policy_);
	
}

static MagicsParameter<stringarray> contour_shade_colour_list("contour_shade_colour_list", stringarray());
static MagicsParameter<string> contour_shade_colour_reverse_list("contour_shade_colour_reverse_list", "off");
static MagicsParameter<string> contour_shade_colour_list_policy("contour_shade_colour_list_policy", "lastone");
