/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-sylpheed-message.h"

#include "mn-sylpheed-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-sylpheed-message.gob"

#include <stdlib.h>
#include <glib/gi18n.h>
#include "mn-util.h"
#include "mn-sylpheed-mailbox-backend-private.h"
#include "mn-message-private.h"

#line 34 "mn-sylpheed-message.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MESSAGE(x)
#define SELF_CONST(x) MN_SYLPHEED_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MESSAGE(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MESSAGE
#define SELF_CLASS(x) MN_SYLPHEED_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMessage Self;
typedef MNSylpheedMessageClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-sylpheed-message.gob"
static void mn_sylpheed_message_init (MNSylpheedMessage * o);
#line 51 "mn-sylpheed-message.c"
#line 0 "src/mn-sylpheed-message.gob"
static void mn_sylpheed_message_class_init (MNSylpheedMessageClass * c);
#line 54 "mn-sylpheed-message.c"
#line 34 "src/mn-sylpheed-message.gob"
static void ___1_mn_sylpheed_message_builtin_mark_as_read (MNMessage * message, MNMessageActionRequest * request);
#line 57 "mn-sylpheed-message.c"
#line 40 "src/mn-sylpheed-message.gob"
static GError * mn_sylpheed_message_builtin_mark_as_read_cb (MNMessage * message, gpointer data);
#line 60 "mn-sylpheed-message.c"

/* pointer to the class of our parent */
static MNVFSMessageClass *parent_class = NULL;

/* Short form macros */
#define self_builtin_mark_as_read_cb mn_sylpheed_message_builtin_mark_as_read_cb
GType
mn_sylpheed_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_message_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MESSAGE, "MNSylpheedMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMessage *)g_object_new(mn_sylpheed_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMessage *)g_object_new_valist (mn_sylpheed_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_sylpheed_message_init (MNSylpheedMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Message::init"
}
#undef __GOB_FUNCTION__
static void 
mn_sylpheed_message_class_init (MNSylpheedMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Message::class_init"
	MNMessageClass *mn_message_class = (MNMessageClass *)c;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MESSAGE);

#line 34 "src/mn-sylpheed-message.gob"
	mn_message_class->builtin_mark_as_read = ___1_mn_sylpheed_message_builtin_mark_as_read;
#line 125 "mn-sylpheed-message.c"
}
#undef __GOB_FUNCTION__



#line 34 "src/mn-sylpheed-message.gob"
static void 
___1_mn_sylpheed_message_builtin_mark_as_read (MNMessage * message G_GNUC_UNUSED, MNMessageActionRequest * request)
#line 134 "mn-sylpheed-message.c"
#define PARENT_HANDLER(___message,___request) \
	{ if(MN_MESSAGE_CLASS(parent_class)->builtin_mark_as_read) \
		(* MN_MESSAGE_CLASS(parent_class)->builtin_mark_as_read)(___message,___request); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Message::builtin_mark_as_read"
{
#line 36 "src/mn-sylpheed-message.gob"
	
    mn_message_perform_action_in_thread(request, self_builtin_mark_as_read_cb, NULL);
  }}
#line 145 "mn-sylpheed-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 40 "src/mn-sylpheed-message.gob"
static GError * 
mn_sylpheed_message_builtin_mark_as_read_cb (MNMessage * message, gpointer data)
{
#line 153 "mn-sylpheed-message.c"
#define __GOB_FUNCTION__ "MN:Sylpheed:Message::builtin_mark_as_read_cb"
{
#line 42 "src/mn-sylpheed-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(message);
    char *filename;
    guint32 num;
    guint32 flags;
    GError *tmp_err = NULL;
    GHashTable *marks;
    GError *err = NULL;

    filename = gnome_vfs_uri_extract_short_name(vmessage->vfs_uri);
    g_assert(mn_str_isnumeric(filename));
    num = atoi(filename);
    g_free(filename);

    /*
     * We hold the mailbox lock to prevent this:
     *
     *	  thread A: read mark file
     *	  thread B: read mark file
     *    thread A: write new mark file
     *    thread B: write new mark file, A's modifications are overwritten
     */
    mn_vfs_mailbox_lock(MN_VFS_MAILBOX(message->mailbox));

    marks = mn_sylpheed_mailbox_backend_read_marks(MN_VFS_MAILBOX(message->mailbox)->vfs_uri, &tmp_err);
    if (! marks)
      {
	g_set_error(&err, 0, 0, _("Unable to read %s: %s."), SYLPHEED_MARK_FILE, tmp_err->message);
	g_error_free(tmp_err);
	goto end;
      }

    flags = GPOINTER_TO_UINT(g_hash_table_lookup(marks, GUINT_TO_POINTER(num)));
    flags &= ~(SYLPHEED_MSG_NEW | SYLPHEED_MSG_UNREAD);
    g_hash_table_insert(marks, GUINT_TO_POINTER(num), GUINT_TO_POINTER(flags));

    mn_sylpheed_mailbox_backend_write_marks(MN_VFS_MAILBOX(message->mailbox)->vfs_uri, marks, &err);
    g_hash_table_destroy(marks);

  end:
    mn_vfs_mailbox_unlock(MN_VFS_MAILBOX(message->mailbox));

    return err;
  }}
#line 201 "mn-sylpheed-message.c"
#undef __GOB_FUNCTION__
