/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Task.h
// Baudouin Raoult - ECMWF Aug 99

#ifndef Task_H
#define Task_H

// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 

#include "inc_stl.h"
using std::string;

class Queue;
class TaskObserver;
class Request;

#ifndef Counted_H
#include "Counted.h"
#endif


class Task : public virtual Counted {
public:

// -- Exceptions
	// None

// -- Contructors

	Task();

// -- Destructor

	virtual ~Task(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual void start() = 0;
	virtual void stop();

	void add(TaskObserver*);
	void remove(TaskObserver*);

	virtual void addContext (const Request&) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

	bool stopped_;

// -- Methods
	
	void success(const Request&);
	void failure();

	virtual void print(ostream&) const = 0; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Task(const Task&);
	Task& operator=(const Task&);

// -- Members

	set<TaskObserver*> observers_;

// -- Methods
	// None


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	friend ostream& operator<<(ostream& s,const Task& p)
		{ p.print(s); return s; }


	friend class Queue;
};

typedef Handle<Task> TaskH;

#endif
