/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Language_H
#define Language_H

#include "Path.h"
#include "Request.h"

class IconClass;
class Parameter;

class LanguageScanner {
public:
	virtual void next(const Parameter&) = 0;
};


class Language 
{
public:

	Language(const IconClass*);
	Language(const IconClass*, const Request&);
	~Language(); // Change to virtual if base class

	const char* getInfo() const;
	const char* getKind() const;

	Request expand(const Request&);
	Request expand(const Request&,long,bool=true);
	void scan(LanguageScanner&);
	vector<string> interfaces(const char*);
	Request interfaceRequest(const char*); 
	
	static Language& find(const IconClass*);

private:
	// No copy allowed
	Language(const Language&);
	Language& operator=(const Language&);

	void init();

	bool               inited_;
	request*           lang_;
	rule*              rule_;
	long               flags_;
	const IconClass*   class_;
	vector<Parameter*> params_;

};

inline void destroy(Language**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Language);
//#endif

#endif
