/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Resources_H
#include "Resources.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

void Resources::sync()
{
}

void Resources::set(const Request& r,IconObject* o)
{
	if(o == 0) o = Folder::top();        
	Request dot(o->dotPath());
	if(dot)
		dot.merge(r);
	else
		dot = r;
	dot.save(o->dotPath());              
}

void Resources::set(const string& name,const vector<string>& v,IconObject* o)
{
	Request r("USER_INTERFACE");
	r.set(name,v);
	set(r,o);
}

void Resources::get(const string& name,vector<string>& v,IconObject* o)
{
	v.clear();
	if(o == 0) o = Folder::top();        
	Request dot(o->dotPath());
	v = dot.get(name);
}

void Resources::set(const string& name,const list<string>& v,IconObject* o)
{
	vector<string> w; w.reserve(v.size());
	copy(v.begin(),v.end(),back_inserter(w));
	set(name,w,o);
}

void Resources::get(const string& name,list<string>& v,IconObject* o)
{
	vector<string> w;
	get(name,w,o);
	copy(w.begin(),w.end(),back_inserter(v));
}
