/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlaceMarkMimeData_H
#define MvQPlaceMarkMimeData_H

#include <QMimeData>
#include <QStringList>

class MvQPlaceMarkNode;
class QAbstractItemModel;

class MvQPlaceMarkMimeData : public QMimeData
{
	Q_OBJECT
public:
	MvQPlaceMarkMimeData(const QAbstractItemModel* model) : model_(model) {};

	bool hasFormat ( const QString & mimeType ) const;
	QStringList	formats () const;

	void addPlaceMark(MvQPlaceMarkNode* pm){ pm_ << pm;}
	const QList<MvQPlaceMarkNode*>& placeMark() const {return pm_;}	
	const QAbstractItemModel* model() const {return model_;}

protected:
	QVariant retrieveData ( const QString & mimeType, QVariant::Type type ) const;

	const QAbstractItemModel* model_;
	QList<MvQPlaceMarkNode*> pm_;
};

#endif