/*
 * Copyright (c) 2022 MiLaboratories Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.milaboratory.util;

import com.milaboratory.util.ParseUtil;
import com.milaboratory.util.ParserException;
import org.junit.Test;

import static org.junit.Assert.assertArrayEquals;

public class ParseUtilTest {
    @Test
    public void test1() throws Exception {
        String target = "asdjkjsdfsd,fs,(df,{,,})fsdf";
        assertArrayEquals(new String[]{"asdjkjsdfsd", "fs", "(df,{,,})fsdf"}, ParseUtil.splitWithBrackets(target, ',', "()"));
    }

    @Test(expected = ParserException.class)
    public void test2() throws Exception {
        String target = "asdjkjsdfsd,fs,(df,{,,)}fsdf";
        ParseUtil.splitWithBrackets(target, ',', "(){}");
    }

    @Test
    public void test3() throws Exception {
        String target = "asdjkjsdfsd,fs,(df,,,)f,{,s},df";
        assertArrayEquals(new String[]{"asdjkjsdfsd", "fs", "(df,,,)f", "{,s}", "df"}, ParseUtil.splitWithBrackets(target, ',', "(){}"));
    }
}