/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.util.ArrayList;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;

public class LongValueMax
implements ValueAggregator {
    long maxVal = Long.MIN_VALUE;

    public LongValueMax() {
        this.reset();
    }

    @Override
    public void addNextValue(Object val) {
        long newVal = Long.parseLong(val.toString());
        if (this.maxVal < newVal) {
            this.maxVal = newVal;
        }
    }

    public void addNextValue(long newVal) {
        if (this.maxVal < newVal) {
            this.maxVal = newVal;
        }
    }

    public long getVal() {
        return this.maxVal;
    }

    @Override
    public String getReport() {
        return "" + this.maxVal;
    }

    @Override
    public void reset() {
        this.maxVal = Long.MIN_VALUE;
    }

    @Override
    public ArrayList<String> getCombinerOutput() {
        ArrayList<String> retv = new ArrayList<String>(1);
        retv.add("" + this.maxVal);
        return retv;
    }
}

