open Viz_types

type style
(* a style defines some attributes for nodes based on certs values *)

type prefs = {
    font          : string ;
    autocolor     : autocolor ;
    lr_layout     : bool ;
    monotone_path : string ;
    dot_path      : string ;
    ignored_certs : string list ;
    style         : style ;
  }

val load : unit -> prefs
val save : prefs -> unit

type shape_props = [ 
    `FILL_COLOR of string
  | `OUTLINE_COLOR of string
  | `WIDTH_PIXELS of int]
type text_props = [
    `FILL_COLOR of string
  | `FONT of string
  | `WEIGHT of int]

val match_style : 
  prefs -> 
  Agraph.t -> 
  Monotone.t ->
  string -> 
  shape_props list * text_props list -> 
  [> shape_props | `FILL_COLOR_RGBA of int32] list * [> text_props] list
