/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private Configuration config;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private boolean xIncludeAware;
    private boolean validating;
    private int stripSpace = 3;

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public void setValidating(boolean state) {
        this.validating = state;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public Document newDocument() {
        throw new UnsupportedOperationException("The only way to build a document using this DocumentBuilder is with the parse() method");
    }

    public Document parse(InputSource in) throws SAXException {
        try {
            XMLReader reader;
            TinyBuilder builder = new TinyBuilder();
            if (this.config == null) {
                this.config = new Configuration();
            }
            PipelineConfiguration pipe = this.config.makePipelineConfiguration();
            builder.setPipelineConfiguration(pipe);
            SAXSource source = new SAXSource(in);
            if (this.entityResolver != null) {
                reader = source.getXMLReader();
                if (reader == null) {
                    reader = this.config.getSourceParser();
                }
                reader.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                reader = source.getXMLReader();
                if (reader == null) {
                    reader = this.config.getSourceParser();
                }
                reader.setErrorHandler(this.errorHandler);
            }
            source.setSystemId(in.getSystemId());
            ParseOptions options = new ParseOptions();
            if (this.xIncludeAware) {
                options.setXIncludeAware(true);
            }
            if (this.validating) {
                options.setDTDValidationMode(1);
            }
            if (this.stripSpace != 3) {
                options.setStripSpace(this.stripSpace);
            }
            new Sender(pipe).send(source, builder, options);
            TinyDocumentImpl doc = (TinyDocumentImpl)builder.getCurrentRoot();
            ((Builder)builder).reset();
            return (Document)((Object)DocumentOverNodeInfo.wrap(doc));
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public Document parse(File f) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String uri = f.toURI().toString();
        InputSource in = new InputSource(uri);
        return this.parse(in);
    }

    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public DOMImplementation getDOMImplementation() {
        return this.newDocument().getImplementation();
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setStripSpace(int stripAction) {
        this.stripSpace = stripAction;
    }

    public int getStripSpace() {
        return this.stripSpace;
    }
}

