if (typeof T === 'undefined') require('../setup');

T('cos', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).cos().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0', 20, 4, '1');
  t('-0', 20, 4, '1');
  t('Infinity', 40, 4, 'NaN');
  t('-Infinity', 40, 4, 'NaN');

  t('0.00006', 10, 2, '0.9999999983');              // 0.9999999982000000005399999999352000000041657142...
  t('0.000000065', 18, 4, '0.999999999999997888');  // 0.99999999999999788750000000000074377...

  t('14044.44444444444', 10, 4, '0.04549771706');
  t('-14044.44444444444', 10, 4, '0.04549771706');
  t('5', 8, 5, '0.28366219');
  t('6723', 3, 3, '0.999');
  t('2.04964', 8, 2, '-0.46075321');
  t('476', 6, 1, '0.0486937');
  t('5298612.00024', 2, 3, '-0.26');
  t('12.5703596425462281326763791506392117455', 8, 4, '0.99999204');
  t('2797', 8, 1, '0.55491269');
  t('0.3834777777', 3, 4, '0.927');
  t('16355.3334', 9, 4, '0.979658167');
  t('0.997737586545708065463833973312637902054356957830033', 5, 5, '0.5422');
  t('7803700', 4, 2, '-0.9032');
  t('841822094288189413002174891207354317', 5, 2, '-0.86017');
  t('67942', 8, 3, '-0.33958641');
  t('899999929799999999999919999999999999999999999999999999999999999999999999.99999', 7, 5, '-0.8773558');
  t('0.00058849862302952064864312588263928354414752285369272291803582192021298679', 10, 6, '0.9999998268');
  t('20000000923980793370370313003363533778888888888.7777777777777777', 9, 4, '-0.801329944');
  t('49.73807738608', 3, 1, '0.864');
  t('88000', 5, 3, '-0.66135');
  t('75465048517642702658117738264729233565816440737178306250850477902340698', 7, 2, '0.4233356');
  t('0.704', 10, 2, '0.7622592047');
  t('0.94828132184399998008581', 6, 5, '0.58308');
  t('0.8', 8, 3, '0.6967067');
  t('0.002', 6, 2, '0.999999');
  t('61688.77777079779777777777777797777777777777777', 1, 4, '0.9');
  t('8111', 7, 2, '0.8296971');
  t('22.1513', 10, 6, '-0.9872031473');
  t('800000000', 8, 2, '-0.98618707');
  t('7332769805669601096865534', 4, 0, '0.8803');
  t('2116627523999999999999999999', 2, 5, '0.58');
  t('16967658790', 8, 4, '0.70645039');
  t('2539668340778777961946252621835163455556224034680348035809827426444170650792306', 8, 2, '-0.49939729');
  t('36', 7, 1, '-0.1279636');
  t('61999992993999.999999999999999999949999999999999994999929999999999992999999999999999999999', 2, 6, '0.99');
  t('0.218944155186302719769455371933055277727070161042429', 10, 4, '0.9761273219');
  t('20', 2, 3, '0.4');
  t('173215504685358227465651988', 10, 4, '-0.671213895');
  t('5769000000000.2222222222222222', 10, 3, '0.4282801932');
  t('0.5', 3, 1, '0.877');
  t('5000000000053', 5, 6, '0.85063');
  t('281084', 5, 6, '0.83761');
  t('80.6', 9, 2, '0.470085225');
  t('447162', 7, 4, '0.9642869');
  t('6856.6636666666626606066666', 6, 6, '-0.137265');
  t('7.37514', 7, 4, '0.4607514');
  t('1.29', 3, 4, '0.277');
  t('9', 10, 5, '-0.9111302619');
  t('5067', 4, 0, '-0.9254');
  t('482222222222.62217863079410578', 3, 1, '-0.997');
  t('4.2202926299999999999959999999999999999999999999999999990999999999999999999999', 10, 6, '-0.4724745315');
  t('24714170816959', 8, 1, '-0.99806747');
  t('31365220956895733422', 5, 3, '0.99149');
  t('377469441384376095492196870000863.83493122', 1, 0, '0.8');
  t('0.1175', 1, 1, '0.9');
  t('223953406565183766798339942076619761', 5, 4, '0.77106');
  t('9.4', 7, 0, '-0.9996931');
  t('67777777777777733221519976680533200000000000', 7, 4, '0.883886');
  t('3', 7, 0, '-0.9899925');
  t('99127.77777', 8, 3, '-0.44933878');
  t('95555555550.5555555515555555555555555555550055555555555560555555559', 3, 0, '0.0823');
  t('1.3830713', 3, 5, '0.187');
  t('59', 9, 5, '-0.771080223');
  t('1.1', 7, 1, '0.4535961');
  t('1090000000000000000000000000000000000050000000.00004', 4, 1, '0.9972');
  t('8', 1, 6, '-0.1');
  t('43019456219304869332859776', 8, 1, '-0.99906433');
  t('0.0000003104573823727508545651739730202238202717472186710001424', 7, 4, '1');
  t('81888888888.5555555555555555511111111111111111114304', 8, 6, '0.86581506');
  t('848765718488021014558633685913717744363956181398886593', 5, 0, '-0.97123');
  t('0.4338', 69, 3, '0.907375081713258312704647471639381401468307894324094984616218937905432');
  t('6647167168310148646127', 41, 1, '-0.67876552621688089570465682794229097436017');
  t('14', 44, 5, '0.13673721820783359424892887667173824055164518');
  t('0.815', 74, 3, '0.68586839345673735262969403373783813324713582642679411838288343756307680681');
  t('52666376666220.66', 8, 2, '-0.46217165');
  t('0.1', 58, 6, '0.9950041652780257660955619878038702948385762254150840359594');
  t('5.481638560270924097', 46, 5, '0.6955963080641265200604938991229596548878269881');
  t('616019185645542611168895104511361.514', 73, 0, '-0.9897418432019178091874564214082330932214823767149588163455308944210649199');
  t('58872.6729', 27, 5, '0.71551991401684231627099417');
  t('0.00000000986995340365791470449236832278868084019660524206930178008', 33, 1, '0.999999999999999951292009904810772');
  t('200000000000000000000', 24, 1, '0.167301557725715824849981');
  t('8712357290413741268816184846819797318515482698552148280140735653', 57, 0, '-0.279047254515165435013067136950333012052507338721363544685');
  t('0.0177165009539797142337288907', 37, 1, '0.9998430669018118198896427823538202954');
  t('255555555555555775027123062979747796598651156132669853568621902', 14, 2, '-0.99883756464211');
  t('3741565840746605.71876151239588', 15, 0, '-0.930123581114026');
  t('3050000000000000000000200000000000000000000.0000000000000000000000008', 41, 3, '-0.33127228153577434134804953378906485886176');
  t('0.33482', 27, 4, '0.944469472783453774254728912');
  t('0.1979574070039662', 30, 0, '0.980470333633282159348863278164');
  t('960492.3601219999999', 74, 6, '0.78272168046024997208016985369610426247753755795663609587331768113997535495');
  t('0.1145342', 57, 0, '0.993448125551484394628225244895937689399175688856818869855');
  t('99999999999999999999999.99', 70, 0, '-0.7059760628345569635155393670172360201795320597371430862306924466086157');
  t('0.10859933721171128209598967066', 80, 4, '0.99410888528803407646108267824473898405842663808987770888683180574685964084716924');
  t('2813920.875088303362819', 33, 2, '-0.866254989781355498995879756871368');
  t('35999999999999999999999999999999999999999.999999999999999999999999919', 38, 3, '-0.9562598584240982386154988349219959087');
});
