C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_b95.F 
C> The nwxcm_c_b95 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_b95 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   f &=& {{0.1097020523068037\,{\it t_{10}}\,{\it t_6}\,\left(2.0
C>    \,\tau_\beta-{{0.25\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}+1.0\right)^2}}
C>    +{{0.1097020523068037\,{\it t_5}\,{\it t_1}\,\left(2.0
C>    \,\tau_\alpha-{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}+1.0\right)^2}}+{{1.0
C>    \,\left({\it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}
C>    \,{\it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}
C>    +1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)}
C>    \over{{\it param}\left(1\right)\,\left({\it t_{23}}\,
C>    \sigma_{\beta\beta}+{\it t_{22}}\,\sigma_{\alpha\alpha}\right)
C>    +1.0}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.1097020523068037\,\left(-6.903522198342671 \times 10^{
C>    -18}\,\log \left({{16.08197949869254}\over{5.98255043577108
C>    \,{\it t_{28}}+2.225569421150687\,{\it t_{27}}
C>    +0.8004286349993635\,{\it t_{26}}+0.1897004325747558\,{
C>    \it t_{25}}}}+1.0\right)\,\left(0.1325688999052018\,{\it t_{27}}
C>    +1.0\right)-0.0310907\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{28}}+3.844746237447211\,{
C>    \it t_{27}}+1.644733775567609\,{\it t_{26}}+0.2405871291288192
C>    \,{\it t_{25}}}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{27}}+1.0\right)\right)\,{\it t_{25}}\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\left({{{
C>    \it t_{24}}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0\right)^2}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 104, 1040 (1996)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.4708298 "> 
C> 10.1063/1.4708298 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b95(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 2*gammaaa*t1*t2+1.0d+0
            t4 = 1/t3
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = -2*rhoa*t18
            t20 = param(2)
            t21 = gammaaa*t2*t20+1.0d+0
            t22 = 1/t21**2
            t23 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t24 = 1.414213562373095d+0
            t25 = 7.937005259840998d-1
            t26 = 5.329846514438382d+0*t9+2.2255694211506874d+0*t25*t8+8
     1         .004286349993635d-1*t7/t24+1.1950378408754898d-1*t5
            t27 = 1.6081979498692536d+1/t26+1.0d+0
            t28 = log(t27)
            t29 = 1.3256889990520176d-1*t25*t8+1.0d+0
            t30 = 1/rhoa**1.6666666666666669d+0
            t31 = 1/t6**3
            t32 = 1/rhoa**1.3333333333333333d+0
            t33 = 1/rhoa**1.1666666666666667d+0
            t34 = 1.1102230246251565d-16*t17*(-9.970917392951799d-1*t33-
     1         7.418564737168958d-1*t32-4.002143174996817d-1*t31-1.26466
     2         9550498372d-1*t30)/(t14**2*t15)+1.0d+0*t13*(-1.8533958105
     3         157808d+0*t33-1.2815820791490704d+0*t32-8.223668877838045
     4         d-1*t31-1.6039141941921276d-1*t30)/(t10**2*t11)+3.0506411
     5         443514264d-19*t16*t32+1.3210398931339265d-3*t12*t32
            t35 = 3.968502629920499d-1
            t36 = 1/t3**2
            t37 = t19-1.243628d-1*rhoa*t28*t29
            t38 = 1/t21**3
            fnc(iq) = (1.0d+0*t4*(t19-1.243628d-1*rhoa*(1.05220005583892
     1         12d-1*t8+1.0d+0)*log(1.6081979498692536d+1/(5.32984651443
     2         8383d+0*t9+1.766435620181429d+0*t8+5.659885156639418d-1*t
     3         7+1.19503784087549d-1*t5)+1.0d+0))+2.1940410461360746d-1*
     4         t18*t22*t23*t5)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0970205230680373d-1*t22*t23*t34*t5+1.0d+
     1         0*(2*rhoa*(1.0d+0*t29*(-7.418564737168958d-1*t32*t35-4.44
     2         15387620319857d-1*t33-4.002143174996817d-1*t31/t24**3-3.9
     3         834594695849657d-2*t30)/(t26**2*t27)+2.747773264188437d-3
     4         *t28*t32*t35)-rhoa*t34-6.21814d-2*t28*t29+6.9035221983426
     5         71d-18*t16*t17+3.1090699999999993d-2*t12*t13)*t4+5.850776
     6         123029532d-1*gammaaa*t18*t20*t23*t38/rhoa**4.333333333333
     7         333d+0+2.6666666666666666d+0*gammaaa*t1*t36*t37/rhoa**3.6
     8         666666666666664d+0-7.313470153786915d-2*t18*t22*t23*t30+2
     9         .742551307670093d-2*gammaaa*t18*t2*t22)*wght+Amat(iq,D1_R
     :         A)
            Cmat(iq,D1_GAA) = (-2.1940410461360746d-1*t18*t20*t23*t38/rh
     1         oa**3.3333333333333337d+0-1.0d+0*t1*t2*t36*t37-2.74255130
     2         7670093d-2*t18*t22*t30)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t22*t5*wght+Mmat(
     1         iq,D1_TA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = t1*(gammabb*t3+gammaaa*t2)+1.0d+0
            t5 = 1/t4
            t6 = 1/rhoa**6.666666666666666d-1
            t7 = rhoa**5.0d-1
            t8 = 1/t7
            t9 = 1/rhoa**3.333333333333333d-1
            t10 = 1/rhoa**1.6666666666666666d-1
            t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.405
     1         8712912881916d-1*t6+1.1120374863094686d+1*t10
            t12 = 3.216395899738507d+1/t11+1.0d+0
            t13 = log(t12)
            t14 = 1.274696188700087d-1*t9+1.0d+0
            t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.897
     1         0043257475583d-1*t6+5.982550435771079d+0*t10
            t16 = 1.6081979498692536d+1/t15+1.0d+0
            t17 = log(t16)
            t18 = 1.3256889990520176d-1*t9+1.0d+0
            t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2*t
     1         13*t14
            t20 = 1/rhob**6.666666666666666d-1
            t21 = rhob**5.0d-1
            t22 = 1/t21
            t23 = 1/rhob**3.333333333333333d-1
            t24 = 1/rhob**1.6666666666666666d-1
            t25 = 1.1120374863094686d+1*t24+3.8447462374472113d+0*t23+1.
     1         644733775567609d+0*t22+2.4058712912881916d-1*t20
            t26 = 3.216395899738507d+1/t25+1.0d+0
            t27 = log(t26)
            t28 = 1.274696188700087d-1*t23+1.0d+0
            t29 = 5.982550435771079d+0*t24+2.2255694211506874d+0*t23+8.0
     1         04286349993635d-1*t22+1.8970043257475583d-1*t20
            t30 = 1.6081979498692536d+1/t29+1.0d+0
            t31 = log(t30)
            t32 = 1.3256889990520176d-1*t23+1.0d+0
            t33 = -6.903522198342671d-18*t31*t32-3.1090699999999993d-2*t
     1         27*t28
            t34 = rhob+rhoa
            t35 = 1/t34**3.333333333333333d-1
            t36 = 1.3256889990520176d-1*t35+1.0d+0
            t37 = rhoa-rhob
            t38 = t37**4
            t39 = 1/t34**4
            t40 = 1/t34
            t41 = 1.0d+0-t37*t40
            t42 = t37*t40+1.0d+0
            t43 = t42**1.3333333333333333d+0+t41**1.3333333333333333d+0-
     1         2.0d+0
            t44 = -1.923661050931536d+0*t38*t39*t43
            t45 = t44+1.0d+0
            t46 = 1/t34**6.666666666666666d-1
            t47 = t34**5.0d-1
            t48 = 1/t47
            t49 = 1/t34**1.6666666666666666d-1
            t50 = 5.982550435771079d+0*t49+8.004286349993635d-1*t48+1.89
     1         70043257475583d-1*t46+2.2255694211506874d+0*t35
            t51 = 1.6081979498692536d+1/t50+1.0d+0
            t52 = log(t51)
            t53 = -6.21814d-2*t36*t45*t52
            t54 = 6.901399211255825d-2*t35+1.0d+0
            t55 = t44+1.923661050931536d+0*t43
            t56 = 8.157414703487641d+0*t49+4.3009724712766434d-1*t48+1.9
     1         115125951273373d-1*t46+2.247591863577616d+0*t35
            t57 = 2.9608813203268075d+1/t56+1.0d+0
            t58 = log(t57)
            t59 = 1.9751631321680768d-2*t54*t55*t58
            t60 = 1.274696188700087d-1*t35+1.0d+0
            t61 = 1.1120374863094686d+1*t49+1.644733775567609d+0*t48+2.4
     1         058712912881916d-1*t46+3.8447462374472113d+0*t35
            t62 = 3.216395899738507d+1/t61+1.0d+0
            t63 = log(t62)
            t64 = -5.980796863619711d-2*t38*t39*t43*t60*t63
            t65 = t34*(t64+t59+t53)-rhob*t33-rhoa*t19
            t66 = param(2)
            t67 = gammaaa*t2*t66+1.0d+0
            t68 = 1/t67**2
            t69 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t70 = gammabb*t3*t66+1.0d+0
            t71 = 1/t70**2
            t72 = 2.0d+0*taub-2.5d-1*gammabb/rhob
            t73 = 1/rhoa**1.6666666666666669d+0
            t74 = 1/t7**3
            t75 = 1/rhoa**1.3333333333333333d+0
            t76 = 1/rhoa**1.1666666666666667d+0
            t77 = 1.1102230246251565d-16*t18*(-9.970917392951799d-1*t76-
     1         7.418564737168958d-1*t75-4.002143174996817d-1*t74-1.26466
     2         9550498372d-1*t73)/(t15**2*t16)+1.0d+0*t14*(-1.8533958105
     3         157808d+0*t76-1.2815820791490704d+0*t75-8.223668877838045
     4         d-1*t74-1.6039141941921276d-1*t73)/(t11**2*t12)+3.0506411
     5         443514264d-19*t17*t75+1.3210398931339265d-3*t13*t75
            t78 = 1/t34**1.6666666666666669d+0
            t79 = 1/t47**3
            t80 = 1/t34**1.3333333333333333d+0
            t81 = 1/t34**1.1666666666666667d+0
            t82 = 1.0d+0*t36*t45*(-9.970917392951799d-1*t81-7.4185647371
     1         68958d-1*t80-4.002143174996817d-1*t79-1.264669550498372d-
     2         1*t78)/(t50**2*t51)
            t83 = -5.848223622634647d-1*t54*t55*(-1.3595691172479402d+0*
     1         t81-7.491972878592053d-1*t80-2.1504862356383217d-1*t79-1.
     2         2743417300848914d-1*t78)/(t56**2*t57)
            t84 = 1.923661050931536d+0*t38*t39*t43*t60*(-1.8533958105157
     1         808d+0*t81-1.2815820791490704d+0*t80-8.223668877838045d-1
     2         *t79-1.6039141941921276d-1*t78)/(t61**2*t62)
            t85 = 1/t34**2
            t86 = t37*t85
            t87 = -t40
            t88 = t41**3.333333333333333d-1
            t89 = -t37*t85
            t90 = t42**3.333333333333333d-1
            t91 = 1.3333333333333333d+0*(t89+t40)*t90+1.3333333333333333
     1         d+0*(t87+t86)*t88
            t92 = -1.923661050931536d+0*t38*t39*t91
            t93 = 1/t34**5
            t94 = 7.694644203726144d+0*t38*t43*t93
            t95 = t37**3
            t96 = -7.694644203726144d+0*t39*t43*t95
            t97 = 2.747773264188437d-3*t45*t52*t80
            t98 = -4.5437964274821163d-4*t55*t58*t80
            t99 = 2.541232989148493d-3*t38*t43*t63/t34**5.33333333333333
     1         3d+0
            t100 = 2.3923187454478842d-1*t38*t43*t60*t63*t93
            t101 = 1/t4**2
            t102 = 1/t67**3
            t103 = 1/rhob**1.6666666666666669d+0
            t104 = 1/t21**3
            t105 = 1/rhob**1.3333333333333333d+0
            t106 = 1/rhob**1.1666666666666667d+0
            t107 = 1.1102230246251565d-16*(-9.970917392951799d-1*t106-7.
     1         418564737168958d-1*t105-4.002143174996817d-1*t104-1.26466
     2         9550498372d-1*t103)*t32/(t29**2*t30)+3.0506411443514264d-
     3         19*t105*t31+1.0d+0*(-1.8533958105157808d+0*t106-1.2815820
     4         791490704d+0*t105-8.223668877838045d-1*t104-1.60391419419
     5         21276d-1*t103)*t28/(t25**2*t26)+1.3210398931339265d-3*t10
     6         5*t27
            t108 = 1.3333333333333333d+0*(t89+t87)*t90+1.333333333333333
     1         3d+0*(t86+t40)*t88
            t109 = -1.923661050931536d+0*t108*t38*t39
            t110 = 7.694644203726144d+0*t39*t43*t95
            t111 = 1/t70**3
            fnc(iq) = (1.0970205230680373d-1*t20*t33*t71*t72+1.097020523
     1         0680373d-1*t19*t6*t68*t69+1.0d+0*t5*t65)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t5*(t34*(t99+t98+t97+1.975163132168
     1         0768d-2*t54*t58*(t96+t94+t92+1.923661050931536d+0*t91)-6.
     2         21814d-2*t36*t52*(t96+t94+t92)-2.3923187454478842d-1*t39*
     3         t43*t60*t63*t95-5.980796863619711d-2*t38*t39*t60*t63*t91+
     4         t84+t83+t82+t100)-rhoa*t77+t64+t59+t53+6.903522198342671d
     5         -18*t17*t18+3.1090699999999993d-2*t13*t14)+1.097020523068
     6         0373d-1*t6*t68*t69*t77-7.313470153786915d-2*t19*t68*t69*t
     7         73+5.850776123029532d-1*gammaaa*t102*t19*t66*t69/rhoa**4.
     8         333333333333333d+0+2.742551307670093d-2*gammaaa*t19*t2*t6
     9         8+2.6666666666666666d+0*gammaaa*t1*t101*t65/rhoa**3.66666
     :         66666666664d+0)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (1.0d+0*t5*(t34*(t99+t98+t97+2.392318745447
     1         8842d-1*t39*t43*t60*t63*t95+1.9751631321680768d-2*t54*t58
     2         *(t94+t110+t109+1.923661050931536d+0*t108)-6.21814d-2*t36
     3         *t52*(t94+t110+t109)+t84+t83+t82-5.980796863619711d-2*t10
     4         8*t38*t39*t60*t63+t100)+t64+t59+t53+6.903522198342671d-18
     5         *t31*t32+3.1090699999999993d-2*t27*t28-rhob*t107)-7.31347
     6         0153786915d-2*t103*t33*t71*t72+1.0970205230680373d-1*t107
     7         *t20*t71*t72+5.850776123029532d-1*gammabb*t111*t33*t66*t7
     8         2/rhob**4.333333333333333d+0+2.742551307670093d-2*gammabb
     9         *t3*t33*t71+2.6666666666666666d+0*gammabb*t1*t101*t65/rho
     :         b**3.6666666666666664d+0)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = (-2.742551307670093d-2*t19*t68*t73-2.19404
     1         10461360746d-1*t102*t19*t66*t69/rhoa**3.3333333333333337d
     2         +0-1.0d+0*t1*t101*t2*t65)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-2.1940410461360746d-1*t111*t33*t66*t72/r
     1         hob**3.3333333333333337d+0-2.742551307670093d-2*t103*t33*
     2         t71-1.0d+0*t1*t101*t3*t65)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t19*t6*t68*wght+Mmat(
     1         iq,D1_TA)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t20*t33*t71*wght+Mmat
     1         (iq,D1_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = gammaaa*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t20 = 1/t3**3
            t21 = 1/rhoa**1.6666666666666669d+0
            t22 = 1/t6**3
            t23 = 1/rhoa**1.3333333333333333d+0
            t24 = 1/rhoa**1.1666666666666667d+0
            fnc(iq) = 1.0970205230680373d-1*t18*t19*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0970205230680373d-1*t19*(1.11022302462515
     1         65d-16*t17*(-9.970917392951799d-1*t24-7.418564737168958d-
     2         1*t23-4.002143174996817d-1*t22-1.264669550498372d-1*t21)/
     3         (t14**2*t15)+1.0d+0*t13*(-1.8533958105157808d+0*t24-1.281
     4         5820791490704d+0*t23-8.223668877838045d-1*t22-1.603914194
     5         1921276d-1*t21)/(t10**2*t11)+3.0506411443514264d-19*t16*t
     6         23+1.3210398931339265d-3*t12*t23)*t4*t5*wght-7.3134701537
     7         86915d-2*t18*t19*t21*t4*wght+2.742551307670093d-2*gammaaa
     8         *t18*t2*t4*wght+5.850776123029532d-1*gammaaa*t1*t18*t19*t
     9         20*wght/rhoa**4.333333333333333d+0+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = -2.742551307670093d-2*t18*t21*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t19*t20*wght/rhoa**3.33333333333
     2         33337d+0+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhob**2.6666666666666666d+0
            t3 = gammabb*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhob**6.666666666666666d-1
            t6 = rhob**5.0d-1
            t7 = 1/t6
            t8 = 1/rhob**3.333333333333333d-1
            t9 = 1/rhob**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 2.0d+0*taub-2.5d-1*gammabb/rhob
            t20 = 1/t3**3
            t21 = 1/rhob**1.6666666666666669d+0
            t22 = 1/t6**3
            t23 = 1/rhob**1.3333333333333333d+0
            t24 = 1/rhob**1.1666666666666667d+0
            fnc(iq) = 1.0970205230680373d-1*t18*t19*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0970205230680373d-1*t19*(1.11022302462515
     1         65d-16*t17*(-9.970917392951799d-1*t24-7.418564737168958d-
     2         1*t23-4.002143174996817d-1*t22-1.264669550498372d-1*t21)/
     3         (t14**2*t15)+1.0d+0*t13*(-1.8533958105157808d+0*t24-1.281
     4         5820791490704d+0*t23-8.223668877838045d-1*t22-1.603914194
     5         1921276d-1*t21)/(t10**2*t11)+3.0506411443514264d-19*t16*t
     6         23+1.3210398931339265d-3*t12*t23)*t4*t5*wght-7.3134701537
     7         86915d-2*t18*t19*t21*t4*wght+2.742551307670093d-2*gammabb
     8         *t18*t2*t4*wght+5.850776123029532d-1*gammabb*t1*t18*t19*t
     9         20*wght/rhob**4.333333333333333d+0+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = -2.742551307670093d-2*t18*t21*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t19*t20*wght/rhob**3.33333333333
     2         33337d+0+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_b95 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   f &=& {{0.1097020523068037\,{\it t_{10}}\,{\it t_6}\,\left(2.0
C>    \,\tau_\beta-{{0.25\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}+1.0\right)^2}}
C>    +{{0.1097020523068037\,{\it t_5}\,{\it t_1}\,\left(2.0
C>    \,\tau_\alpha-{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}+1.0\right)^2}}+{{1.0
C>    \,\left({\it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}
C>    \,{\it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}
C>    +1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)}
C>    \over{{\it param}\left(1\right)\,\left({\it t_{23}}\,
C>    \sigma_{\beta\beta}+{\it t_{22}}\,\sigma_{\alpha\alpha}\right)
C>    +1.0}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.1097020523068037\,\left(-6.903522198342671 \times 10^{
C>    -18}\,\log \left({{16.08197949869254}\over{5.98255043577108
C>    \,{\it t_{28}}+2.225569421150687\,{\it t_{27}}
C>    +0.8004286349993635\,{\it t_{26}}+0.1897004325747558\,{
C>    \it t_{25}}}}+1.0\right)\,\left(0.1325688999052018\,{\it t_{27}}
C>    +1.0\right)-0.0310907\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{28}}+3.844746237447211\,{
C>    \it t_{27}}+1.644733775567609\,{\it t_{26}}+0.2405871291288192
C>    \,{\it t_{25}}}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{27}}+1.0\right)\right)\,{\it t_{25}}\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\left({{{
C>    \it t_{24}}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0\right)^2}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 104, 1040 (1996)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.4708298 "> 
C> 10.1063/1.4708298 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b95_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 2*gammaaa*t1*t2+1.0d+0
            t4 = 1/t3
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = -2*rhoa*t18
            t20 = param(2)
            t21 = gammaaa*t2*t20+1.0d+0
            t22 = 1/t21**2
            t23 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t24 = 6.299605249474366d-1
            t25 = 1.414213562373095d+0
            t26 = 1/t25
            t27 = 7.937005259840998d-1
            t28 = 8.908987181403393d-1
            t29 = 5.982550435771079d+0*t28*t9+2.2255694211506874d+0*t27*
     1         t8+8.004286349993635d-1*t26*t7+1.8970043257475583d-1*t24*
     2         t5
            t30 = 1.6081979498692536d+1/t29+1.0d+0
            t31 = log(t30)
            t32 = 1.3256889990520176d-1*t27*t8+1.0d+0
            t33 = 1/t15
            t34 = 1/rhoa**1.6666666666666669d+0
            t35 = 1/t6**3
            t36 = 1/rhoa**1.3333333333333333d+0
            t37 = 1/rhoa**1.1666666666666667d+0
            t38 = -9.970917392951799d-1*t37-7.418564737168958d-1*t36-4.0
     1         02143174996817d-1*t35-1.264669550498372d-1*t34
            t39 = 1/t14**2
            t40 = 1/t11
            t41 = -1.8533958105157808d+0*t37-1.2815820791490704d+0*t36-8
     1         .223668877838045d-1*t35-1.6039141941921276d-1*t34
            t42 = 1/t10**2
            t43 = 1.0d+0*t13*t40*t41*t42+1.1102230246251565d-16*t17*t33*
     1         t38*t39+3.0506411443514264d-19*t16*t36+1.3210398931339265
     2         d-3*t12*t36
            t44 = 1/t30
            t45 = 3.968502629920499d-1
            t46 = -7.418564737168958d-1*t36*t45-4.4415387620319857d-1*t3
     1         7-4.002143174996817d-1*t35/t25**3-3.9834594695849657d-2*t
     2         34
            t47 = 1/t29**2
            t48 = 2*rhoa*(1.0d+0*t32*t44*t46*t47+2.747773264188437d-3*t3
     1         1*t36*t45)-rhoa*t43-6.21814d-2*t31*t32+6.903522198342671d
     2         -18*t16*t17+3.1090699999999993d-2*t12*t13
            t49 = 1/t3**2
            t50 = 1/rhoa**3.6666666666666664d+0
            t51 = t19-1.243628d-1*rhoa*t31*t32
            t52 = 1/t21**3
            t53 = 1/rhoa**4.333333333333333d+0
            t54 = 1/rhoa**3.3333333333333337d+0
            t55 = gammaaa**2
            t56 = 1/rhoa**6.333333333333333d+0
            t57 = 5.333333333333333d+0*gammaaa*t1*t48*t49*t50
            t58 = 2.0d+0*t32*t44*t46*t47
            t59 = 5.495546528376875d-3*t31*t36*t45
            t60 = t38**2
            t61 = 1/t6**5
            t62 = 1/rhoa**2.3333333333333334d+0
            t63 = 1/rhoa**2.1666666666666665d+0
            t64 = t41**2
            t65 = -2.0d+0*t13*t40*t64/t10**3+3.216395899738507d+1*t13*t6
     1         4/(t10**4*t11**2)+1.0d+0*t13*t40*t42*(2.1622951122684114d
     2         +0*t63+1.7087761055320938d+0*t62+1.2335503316757068d+0*t6
     3         1+2.673190323653546d-1*t2)+1.1102230246251565d-16*t17*t33
     4         *t39*(1.1632736958443765d+0*t63+9.89141964955861d-1*t62+6
     5         .003214762495226d-1*t61+2.1077825841639536d-1*t2)-4.06752
     6         15258019015d-19*t16*t62-1.7613865241785684d-3*t12*t62-2.2
     7         20446049250313d-16*t17*t33*t60/t14**3+1.7854583920998188d
     8         -15*t17*t60/(t14**4*t15**2)-8.497974591333913d-2*t36*t40*
     9         t41*t42-9.812069668265515d-18*t33*t36*t38*t39
            t66 = t46**2
            t67 = 1.6081979498692536d+1*t32*t66/(t29**4*t30**2)
            t68 = -2.0d+0*t32*t44*t66/t29**3
            t69 = 1.9842513149602492d-1
            t70 = 1.0d+0*t32*t44*t47*(9.89141964955861d-1*t62*t69+2.5908
     1         976111853255d-1*t63+6.003214762495226d-1*t61/t25**5+3.319
     2         549557987472d-2*t2)
            t71 = -3.663697685584583d-3*t31*t62*t69
            t72 = log(2.9608813203268075d+1/(8.157414703487641d+0*t28*t9
     1         +2.247591863577616d+0*t27*t8+4.3009724712766434d-1*t26*t7
     2         +1.9115125951273373d-1*t24*t5)+1.0d+0)
            t73 = 6.901399211255825d-2*t27*t8+1.0d+0
            t74 = 1/rhoa**2
            t75 = -8.837926660346784d-2*t36*t44*t45*t46*t47
            t76 = t1**2
            t77 = 1/t3**3
            t78 = 1.4222222222222222d+1*t51*t55*t76*t77/rhoa**7.33333333
     1         3333333d+0
            t79 = t20**2
            t80 = 1/t21**4
            t81 = 1/rhoa**5.333333333333333d+0
            t82 = -1.0d+0*t1*t2*t48*t49
            t83 = -5.333333333333333d+0*gammaaa*t51*t56*t76*t77
            fnc(iq) = (1.0d+0*t4*(t19-1.243628d-1*rhoa*(1.05220005583892
     1         12d-1*t8+1.0d+0)*log(1.6081979498692536d+1/(5.32984651443
     2         8383d+0*t9+1.766435620181429d+0*t8+5.659885156639418d-1*t
     3         7+1.19503784087549d-1*t5)+1.0d+0))+2.1940410461360746d-1*
     4         t18*t22*t23*t5)*wght+fnc(iq)
            Amat(iq,D1_RA) = (5.850776123029532d-1*gammaaa*t18*t20*t23*t
     1         52*t53+2.6666666666666666d+0*gammaaa*t1*t49*t50*t51+1.097
     2         0205230680373d-1*t22*t23*t43*t5+1.0d+0*t4*t48-7.313470153
     3         786915d-2*t18*t22*t23*t34+2.742551307670093d-2*gammaaa*t1
     4         8*t2*t22)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-2.1940410461360746d-1*t18*t20*t23*t52*t5
     1         4-1.0d+0*t1*t2*t49*t51-2.742551307670093d-2*t18*t22*t34)*
     2         wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t22*t5*wght+Mmat(
     1         iq,D1_TA)
            Amat2(iq,D2_RA_RA) = (-2.925388061514766d+0*gammaaa*t18*t20*
     1         t23*t52*t81+4.680620898423625d+0*t18*t23*t55*t79*t80/rhoa
     2         **8+t78+1.0d+0*t4*(2*rhoa*(t75+8.443431970194815d-3*t72*t
     3         73*t74+t71+t70+t68+t67)-rhoa*t65+t59+t58-2.0d+0*t13*t40*t
     4         41*t42-2.220446049250313d-16*t17*t33*t38*t39-6.1012822887
     5         02853d-19*t16*t36-2.642079786267853d-3*t12*t36)+1.0970205
     6         230680373d-1*t22*t23*t5*t65+t57+2.925388061514766d-1*t18*
     7         t20*t52*t55*t56+1.1701552246059063d+0*gammaaa*t20*t23*t43
     8         *t52*t53-9.777777777777776d+0*gammaaa*t1*t49*t51/rhoa**4.
     9         666666666666667d+0-9.141837692233644d-2*gammaaa*t18*t22*t
     :         50+t2*t22*(5.485102615340186d-2*gammaaa*t43+1.21891169229
     ;         78192d-1*t18*t23)-1.462694030757383d-1*t22*t23*t34*t43)*w
     <         ght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t78+1.0d+0*t4*(2*rhoa*(t75-8.443431970
     1         194815d-3*t72*t73*t74+t71+t70+t68+t67)+t59+t58)+t57)*wght
     2         +Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (t83+t82-2.0112042922914017d-1*gammaaa
     1         *t18*t20*t52*t81-1.7552328369088593d+0*gammaaa*t18*t23*t7
     2         9*t80/rhoa**7-2.1940410461360746d-1*t20*t23*t43*t52*t54+7
     3         .313470153786915d-1*t18*t20*t23*t52*t53+2.666666666666666
     4         6d+0*t1*t49*t50*t51-2.742551307670093d-2*t22*t34*t43+4.57
     5         0918846116822d-2*t18*t2*t22)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t83+t82)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (2.0d+0*t51*t76*t77*t81+6.58212313840
     1         8223d-1*t18*t23*t79*t80/rhoa**6+1.0970205230680373d-1*t18
     2         *t20*t52*t53)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 2.0d+0*t51*t76*t77*t81*wght+Cmat2(iq,
     1         D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = (1.1701552246059063d+0*gammaaa*t18*t20*
     1         t52*t53+2.1940410461360746d-1*t22*t43*t5-1.46269403075738
     2         3d-1*t18*t22*t34)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t18*t20*t52*t54*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = t1*(gammabb*t3+gammaaa*t2)+1.0d+0
            t5 = 1/t4
            t6 = 1/rhoa**6.666666666666666d-1
            t7 = rhoa**5.0d-1
            t8 = 1/t7
            t9 = 1/rhoa**3.333333333333333d-1
            t10 = 1/rhoa**1.6666666666666666d-1
            t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.405
     1         8712912881916d-1*t6+1.1120374863094686d+1*t10
            t12 = 3.216395899738507d+1/t11+1.0d+0
            t13 = log(t12)
            t14 = 1.274696188700087d-1*t9+1.0d+0
            t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.897
     1         0043257475583d-1*t6+5.982550435771079d+0*t10
            t16 = 1.6081979498692536d+1/t15+1.0d+0
            t17 = log(t16)
            t18 = 1.3256889990520176d-1*t9+1.0d+0
            t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2*t
     1         13*t14
            t20 = 1/rhob**6.666666666666666d-1
            t21 = rhob**5.0d-1
            t22 = 1/t21
            t23 = 1/rhob**3.333333333333333d-1
            t24 = 1/rhob**1.6666666666666666d-1
            t25 = 1.1120374863094686d+1*t24+3.8447462374472113d+0*t23+1.
     1         644733775567609d+0*t22+2.4058712912881916d-1*t20
            t26 = 3.216395899738507d+1/t25+1.0d+0
            t27 = log(t26)
            t28 = 1.274696188700087d-1*t23+1.0d+0
            t29 = 5.982550435771079d+0*t24+2.2255694211506874d+0*t23+8.0
     1         04286349993635d-1*t22+1.8970043257475583d-1*t20
            t30 = 1.6081979498692536d+1/t29+1.0d+0
            t31 = log(t30)
            t32 = 1.3256889990520176d-1*t23+1.0d+0
            t33 = -6.903522198342671d-18*t31*t32-3.1090699999999993d-2*t
     1         27*t28
            t34 = rhob+rhoa
            t35 = 1/t34**3.333333333333333d-1
            t36 = 1.3256889990520176d-1*t35+1.0d+0
            t37 = rhoa-rhob
            t38 = t37**4
            t39 = 1/t34**4
            t40 = 1/t34
            t41 = 1.0d+0-t37*t40
            t42 = t37*t40+1.0d+0
            t43 = t42**1.3333333333333333d+0+t41**1.3333333333333333d+0-
     1         2.0d+0
            t44 = -1.923661050931536d+0*t38*t39*t43
            t45 = t44+1.0d+0
            t46 = 1/t34**6.666666666666666d-1
            t47 = t34**5.0d-1
            t48 = 1/t47
            t49 = 1/t34**1.6666666666666666d-1
            t50 = 5.982550435771079d+0*t49+8.004286349993635d-1*t48+1.89
     1         70043257475583d-1*t46+2.2255694211506874d+0*t35
            t51 = 1.6081979498692536d+1/t50+1.0d+0
            t52 = log(t51)
            t53 = -6.21814d-2*t36*t45*t52
            t54 = 6.901399211255825d-2*t35+1.0d+0
            t55 = t44+1.923661050931536d+0*t43
            t56 = 8.157414703487641d+0*t49+4.3009724712766434d-1*t48+1.9
     1         115125951273373d-1*t46+2.247591863577616d+0*t35
            t57 = 2.9608813203268075d+1/t56+1.0d+0
            t58 = log(t57)
            t59 = 1.9751631321680768d-2*t54*t55*t58
            t60 = 1.274696188700087d-1*t35+1.0d+0
            t61 = 1.1120374863094686d+1*t49+1.644733775567609d+0*t48+2.4
     1         058712912881916d-1*t46+3.8447462374472113d+0*t35
            t62 = 3.216395899738507d+1/t61+1.0d+0
            t63 = log(t62)
            t64 = -5.980796863619711d-2*t38*t39*t43*t60*t63
            t65 = t34*(t64+t59+t53)-rhob*t33-rhoa*t19
            t66 = param(2)
            t67 = gammaaa*t2*t66+1.0d+0
            t68 = 1/t67**2
            t69 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t70 = gammabb*t3*t66+1.0d+0
            t71 = 1/t70**2
            t72 = 2.0d+0*taub-2.5d-1*gammabb/rhob
            t73 = 1/t16
            t74 = 1/rhoa**1.6666666666666669d+0
            t75 = 1/t7**3
            t76 = 1/rhoa**1.3333333333333333d+0
            t77 = 1/rhoa**1.1666666666666667d+0
            t78 = -9.970917392951799d-1*t77-7.418564737168958d-1*t76-4.0
     1         02143174996817d-1*t75-1.264669550498372d-1*t74
            t79 = 1/t15**2
            t80 = 1/t12
            t81 = -1.8533958105157808d+0*t77-1.2815820791490704d+0*t76-8
     1         .223668877838045d-1*t75-1.6039141941921276d-1*t74
            t82 = 1/t11**2
            t83 = 1.0d+0*t14*t80*t81*t82+1.1102230246251565d-16*t18*t73*
     1         t78*t79+3.0506411443514264d-19*t17*t76+1.3210398931339265
     2         d-3*t13*t76
            t84 = 1/t34**1.6666666666666669d+0
            t85 = 1/t47**3
            t86 = 1/t34**1.3333333333333333d+0
            t87 = 1/t34**1.1666666666666667d+0
            t88 = -9.970917392951799d-1*t87-7.418564737168958d-1*t86-4.0
     1         02143174996817d-1*t85-1.264669550498372d-1*t84
            t89 = 1/t50**2
            t90 = 1/t51
            t91 = 1.0d+0*t36*t45*t88*t89*t90
            t92 = -1.3595691172479402d+0*t87-7.491972878592053d-1*t86-2.
     1         1504862356383217d-1*t85-1.2743417300848914d-1*t84
            t93 = 1/t56**2
            t94 = 1/t57
            t95 = -5.848223622634647d-1*t54*t55*t92*t93*t94
            t96 = -1.8533958105157808d+0*t87-1.2815820791490704d+0*t86-8
     1         .223668877838045d-1*t85-1.6039141941921276d-1*t84
            t97 = 1/t61**2
            t98 = 1/t62
            t99 = 1.923661050931536d+0*t38*t39*t43*t60*t96*t97*t98
            t100 = 1/t34**2
            t101 = t100*t37
            t102 = -t40
            t103 = t102+t101
            t104 = t41**3.333333333333333d-1
            t105 = -t100*t37
            t106 = t40+t105
            t107 = t42**3.333333333333333d-1
            t108 = 1.3333333333333333d+0*t106*t107+1.3333333333333333d+0
     1         *t103*t104
            t109 = -1.923661050931536d+0*t108*t38*t39
            t110 = 1/t34**5
            t111 = 7.694644203726144d+0*t110*t38*t43
            t112 = t37**3
            t113 = -7.694644203726144d+0*t112*t39*t43
            t114 = t113+t111+t109
            t115 = -6.21814d-2*t114*t36*t52
            t116 = 2.747773264188437d-3*t45*t52*t86
            t117 = t113+t111+t109+1.923661050931536d+0*t108
            t118 = 1.9751631321680768d-2*t117*t54*t58
            t119 = -4.5437964274821163d-4*t55*t58*t86
            t120 = -5.980796863619711d-2*t108*t38*t39*t60*t63
            t121 = 1/t34**5.333333333333333d+0
            t122 = 2.541232989148493d-3*t121*t38*t43*t63
            t123 = 2.3923187454478842d-1*t110*t38*t43*t60*t63
            t124 = t34*(t99+t95+t91-2.3923187454478842d-1*t112*t39*t43*t
     1         60*t63+t123+t122+t120+t119+t118+t116+t115)-rhoa*t83+t64+t
     2         59+t53+6.903522198342671d-18*t17*t18+3.1090699999999993d-
     3         2*t13*t14
            t125 = 1/rhoa**3.6666666666666664d+0
            t126 = 1/t4**2
            t127 = 1/t67**3
            t128 = 1/rhoa**4.333333333333333d+0
            t129 = 1/t30
            t130 = 1/rhob**1.6666666666666669d+0
            t131 = 1/t21**3
            t132 = 1/rhob**1.3333333333333333d+0
            t133 = 1/rhob**1.1666666666666667d+0
            t134 = -9.970917392951799d-1*t133-7.418564737168958d-1*t132-
     1         4.002143174996817d-1*t131-1.264669550498372d-1*t130
            t135 = 1/t29**2
            t136 = 1/t26
            t137 = -1.8533958105157808d+0*t133-1.2815820791490704d+0*t13
     1         2-8.223668877838045d-1*t131-1.6039141941921276d-1*t130
            t138 = 1/t25**2
            t139 = 1.1102230246251565d-16*t129*t134*t135*t32+3.050641144
     1         3514264d-19*t132*t31+1.0d+0*t136*t137*t138*t28+1.32103989
     2         31339265d-3*t132*t27
            t140 = t40+t101
            t141 = t105+t102
            t142 = 1.3333333333333333d+0*t107*t141+1.3333333333333333d+0
     1         *t104*t140
            t143 = -1.923661050931536d+0*t142*t38*t39
            t144 = 7.694644203726144d+0*t112*t39*t43
            t145 = t144+t143+t111
            t146 = -6.21814d-2*t145*t36*t52
            t147 = t144+t143+1.923661050931536d+0*t142+t111
            t148 = 1.9751631321680768d-2*t147*t54*t58
            t149 = -5.980796863619711d-2*t142*t38*t39*t60*t63
            t150 = t34*(t99+t95+t91+2.3923187454478842d-1*t112*t39*t43*t
     1         60*t63+t149+t148+t146+t123+t122+t119+t116)+t64+t59+t53+6.
     2         903522198342671d-18*t31*t32+3.1090699999999993d-2*t27*t28
     3         -rhob*t139
            t151 = 1/rhob**3.6666666666666664d+0
            t152 = 1/t70**3
            t153 = 1/rhob**4.333333333333333d+0
            t154 = 1/rhoa**3.3333333333333337d+0
            t155 = 1/rhob**3.3333333333333337d+0
            t156 = gammaaa**2
            t157 = 1/rhoa**6.333333333333333d+0
            t158 = t78**2
            t159 = 1/t7**5
            t160 = 1/rhoa**2.3333333333333334d+0
            t161 = 1/rhoa**2.1666666666666665d+0
            t162 = t81**2
            t163 = -8.497974591333913d-2*t76*t80*t81*t82+1.0d+0*t14*(2.6
     1         73190323653546d-1*t2+2.1622951122684114d+0*t161+1.7087761
     2         055320938d+0*t160+1.2335503316757068d+0*t159)*t80*t82-2.0
     3         d+0*t14*t162*t80/t11**3-9.812069668265515d-18*t73*t76*t78
     4         *t79+1.1102230246251565d-16*t18*(2.1077825841639536d-1*t2
     5         +1.1632736958443765d+0*t161+9.89141964955861d-1*t160+6.00
     6         3214762495226d-1*t159)*t73*t79-2.220446049250313d-16*t158
     7         *t18*t73/t15**3+1.7854583920998188d-15*t158*t18/(t15**4*t
     8         16**2)-4.0675215258019015d-19*t160*t17+3.216395899738507d
     9         +1*t14*t162/(t11**4*t12**2)-1.7613865241785684d-3*t13*t16
     :         0
            t164 = 2.0d+0*t36*t45*t88*t89*t90
            t165 = -1.1696447245269295d+0*t54*t55*t92*t93*t94
            t166 = 3.847322101863072d+0*t38*t39*t43*t60*t96*t97*t98
            t167 = 5.495546528376875d-3*t45*t52*t86
            t168 = -9.087592854964233d-4*t55*t58*t86
            t169 = 5.082465978296986d-3*t121*t38*t43*t63
            t170 = 4.7846374908957684d-1*t110*t38*t43*t60*t63
            t171 = t88**2
            t172 = 1.6081979498692536d+1*t171*t36*t45/(t50**4*t51**2)
            t173 = -2.0d+0*t171*t36*t45*t90/t50**3
            t174 = -8.837926660346784d-2*t45*t86*t88*t89*t90
            t175 = 1/t34**2.6666666666666666d+0
            t176 = 1/t47**5
            t177 = 1/t34**2.3333333333333334d+0
            t178 = 1/t34**2.1666666666666665d+0
            t179 = 1.0d+0*(1.1632736958443765d+0*t178+9.89141964955861d-
     1         1*t177+6.003214762495226d-1*t176+2.1077825841639536d-1*t1
     2         75)*t36*t45*t89*t90
            t180 = t92**2
            t181 = -1.73158960813529d+1*t180*t54*t55/(t56**4*t57**2)
            t182 = 1.1696447245269295d+0*t180*t54*t55*t94/t56**3
            t183 = 2.690728393099896d-2*t55*t86*t92*t93*t94
            t184 = -5.848223622634647d-1*(1.5861639701225969d+0*t178+9.9
     1         8929717145607d-1*t177+3.2257293534574827d-1*t176+2.123902
     2         8834748191d-1*t175)*t54*t55*t93*t94
            t185 = t96**2
            t186 = 6.187255516702861d+1*t185*t38*t39*t43*t60/(t61**4*t62
     1         **2)
            t187 = -3.847322101863072d+0*t185*t38*t39*t43*t60*t98/t61**3
            t188 = -1.6347222733154887d-1*t121*t38*t43*t96*t97*t98
            t189 = 1.923661050931536d+0*(2.1622951122684114d+0*t178+1.70
     1         87761055320938d+0*t177+1.2335503316757068d+0*t176+2.67319
     2         0323653546d-1*t175)*t38*t39*t43*t60*t97*t98
            t190 = -1.538928840745229d+1*t110*t38*t43*t60*t96*t97*t98
            t191 = 1/t41**6.666666666666666d-1
            t192 = 1/t34**3
            t193 = -2*t192*t37
            t194 = 2*t100
            t195 = 1/t42**6.666666666666666d-1
            t196 = 2*t192*t37
            t197 = -2*t100
            t198 = 1.3333333333333333d+0*t107*(t197+t196)+4.444444444444
     1         444d-1*t106**2*t195+1.3333333333333333d+0*t104*(t194+t193
     2         )+4.444444444444444d-1*t103**2*t191
            t199 = -1.923661050931536d+0*t198*t38*t39
            t200 = 1.5389288407452287d+1*t108*t110*t38
            t201 = -1.5389288407452287d+1*t108*t112*t39
            t202 = 1/t34**6
            t203 = -3.8473221018630716d+1*t202*t38*t43
            t204 = 6.155715362980915d+1*t110*t112*t43
            t205 = t37**2
            t206 = -2.3083932611178434d+1*t205*t39*t43
            t207 = -3.663697685584583d-3*t177*t45*t52
            t208 = 6.058395236642822d-4*t177*t55*t58
            t209 = -2.3718174565385935d-2*t38*t43*t63/t34**6.33333333333
     1         3333d+0
            t210 = -1.1961593727239421d+0*t202*t38*t43*t60*t63
            t211 = -7.176956236343652d-1*t205*t39*t43*t60*t63
            t212 = t1**2
            t213 = 1/t4**3
            t214 = t66**2
            t215 = 1/t67**4
            t216 = 1/rhoa**5.333333333333333d+0
            t217 = 2.6666666666666666d+0*t107*t192*t37-2.666666666666666
     1         6d+0*t104*t192*t37+4.444444444444444d-1*t106*t141*t195+4.
     2         444444444444444d-1*t103*t140*t191
            t218 = -1.923661050931536d+0*t217*t38*t39
            t219 = 7.694644203726144d+0*t110*t142*t38
            t220 = -7.694644203726144d+0*t112*t142*t39
            t221 = 7.694644203726144d+0*t108*t110*t38
            t222 = 7.694644203726144d+0*t108*t112*t39
            t223 = 2.3083932611178434d+1*t205*t39*t43
            t224 = gammabb**2
            t225 = 1/rhob**6.333333333333333d+0
            t226 = t134**2
            t227 = 1/t21**5
            t228 = 1/rhob**2.3333333333333334d+0
            t229 = 1/rhob**2.1666666666666665d+0
            t230 = t137**2
            t231 = 1.7854583920998188d-15*t226*t32/(t29**4*t30**2)+1.110
     1         2230246251565d-16*t129*t135*(2.1077825841639536d-1*t3+1.1
     2         632736958443765d+0*t229+9.89141964955861d-1*t228+6.003214
     3         762495226d-1*t227)*t32-2.220446049250313d-16*t129*t226*t3
     4         2/t29**3-4.0675215258019015d-19*t228*t31+1.0d+0*t136*t138
     5         *t28*(2.673190323653546d-1*t3+2.1622951122684114d+0*t229+
     6         1.7087761055320938d+0*t228+1.2335503316757068d+0*t227)+3.
     7         216395899738507d+1*t230*t28/(t25**4*t26**2)-2.0d+0*t136*t
     8         230*t28/t25**3-1.7613865241785684d-3*t228*t27-8.497974591
     9         333913d-2*t132*t136*t137*t138-9.812069668265515d-18*t129*
     :         t132*t134*t135
            t232 = 1.3333333333333333d+0*t104*(t197+t193)+1.333333333333
     1         3333d+0*t107*(t196+t194)+4.444444444444444d-1*t141**2*t19
     2         5+4.444444444444444d-1*t140**2*t191
            t233 = -1.923661050931536d+0*t232*t38*t39
            t234 = 1.5389288407452287d+1*t110*t142*t38
            t235 = 1.5389288407452287d+1*t112*t142*t39
            t236 = -6.155715362980915d+1*t110*t112*t43
            t237 = 1/t70**4
            t238 = 1/rhob**5.333333333333333d+0
            fnc(iq) = (1.0970205230680373d-1*t20*t33*t71*t72+1.097020523
     1         0680373d-1*t19*t6*t68*t69+1.0d+0*t5*t65)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0970205230680373d-1*t6*t68*t69*t83-7.313
     1         470153786915d-2*t19*t68*t69*t74+5.850776123029532d-1*gamm
     2         aaa*t127*t128*t19*t66*t69+2.742551307670093d-2*gammaaa*t1
     3         9*t2*t68+2.6666666666666666d+0*gammaaa*t1*t125*t126*t65+1
     4         .0d+0*t124*t5)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-7.313470153786915d-2*t130*t33*t71*t72+1.0
     1         970205230680373d-1*t139*t20*t71*t72+5.850776123029532d-1*
     2         gammabb*t152*t153*t33*t66*t72+2.742551307670093d-2*gammab
     3         b*t3*t33*t71+2.6666666666666666d+0*gammabb*t1*t126*t151*t
     4         65+1.0d+0*t150*t5)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = (-2.742551307670093d-2*t19*t68*t74-2.19404
     1         10461360746d-1*t127*t154*t19*t66*t69-1.0d+0*t1*t126*t2*t6
     2         5)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-2.1940410461360746d-1*t152*t155*t33*t66*
     1         t72-2.742551307670093d-2*t130*t33*t71-1.0d+0*t1*t126*t3*t
     2         65)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t19*t6*t68*wght+Mmat(
     1         iq,D1_TA)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t20*t33*t71*wght+Mmat
     1         (iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (1.0d+0*t5*(t34*(1.538928840745229d+1*t
     1         112*t39*t43*t60*t96*t97*t98+3.847322101863072d+0*t108*t38
     2         *t39*t60*t96*t97*t98-1.1696447245269295d+0*t117*t54*t92*t
     3         93*t94+2.0d+0*t114*t36*t88*t89*t90-9.087592854964233d-4*t
     4         117*t58*t86+5.495546528376875d-3*t114*t52*t86+1.913854996
     5         3583074d+0*t110*t112*t43*t60*t63-5.980796863619711d-2*t19
     6         8*t38*t39*t60*t63-4.7846374908957684d-1*t108*t112*t39*t60
     7         *t63+4.7846374908957684d-1*t108*t110*t38*t60*t63+2.032986
     8         3913187946d-2*t112*t121*t43*t63+5.082465978296986d-3*t108
     9         *t121*t38*t63+1.9751631321680768d-2*(t206+t204+t203+t201+
     :         t200+t199+1.923661050931536d+0*t198)*t54*t58-6.21814d-2*(
     ;         t206+t204+t203+t201+t200+t199)*t36*t52+t211+t210+t209+t20
     <         8+t207+t190+t189+t188+t187+t186+t184+t183+t182+t181+t179+
     =         t174+t173+t172)-2.0d+0*t14*t80*t81*t82-2.220446049250313d
     >         -16*t18*t73*t78*t79-6.101282288702853d-19*t17*t76-2.64207
     ?         9786267853d-3*t13*t76-4.7846374908957684d-1*t112*t39*t43*
     @         t60*t63-1.1961593727239421d-1*t108*t38*t39*t60*t63+3.9503
     1         262643361536d-2*t117*t54*t58-1.243628d-1*t114*t36*t52+t17
     2         0+t169+t168+t167+t166+t165+t164-rhoa*t163)+t2*t68*(5.4851
     3         02615340186d-2*gammaaa*t83+1.2189116922978192d-1*t19*t69)
     4         -1.462694030757383d-1*t68*t69*t74*t83+1.1701552246059063d
     5         +0*gammaaa*t127*t128*t66*t69*t83+1.0970205230680373d-1*t1
     6         63*t6*t68*t69-2.925388061514766d+0*gammaaa*t127*t19*t216*
     7         t66*t69+4.680620898423625d+0*t156*t19*t214*t215*t69/rhoa*
     8         *8-9.141837692233644d-2*gammaaa*t125*t19*t68+2.9253880615
     9         14766d-1*t127*t156*t157*t19*t66+1.4222222222222222d+1*t15
     :         6*t212*t213*t65/rhoa**7.333333333333333d+0-9.777777777777
     ;         776d+0*gammaaa*t1*t126*t65/rhoa**4.666666666666667d+0+5.3
     <         33333333333333d+0*gammaaa*t1*t124*t125*t126)*wght+Amat2(i
     =         q,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (1.0d+0*t5*(t34*(1.923661050931536d+0*t
     1         142*t38*t39*t60*t96*t97*t98+1.923661050931536d+0*t108*t38
     2         *t39*t60*t96*t97*t98-5.848223622634647d-1*t147*t54*t92*t9
     3         3*t94-5.848223622634647d-1*t117*t54*t92*t93*t94+1.0d+0*t1
     4         45*t36*t88*t89*t90+1.0d+0*t114*t36*t88*t89*t90-4.54379642
     5         74821163d-4*t147*t58*t86-4.5437964274821163d-4*t117*t58*t
     6         86+2.747773264188437d-3*t145*t52*t86+2.747773264188437d-3
     7         *t114*t52*t86+7.176956236343652d-1*t205*t39*t43*t60*t63-5
     8         .980796863619711d-2*t217*t38*t39*t60*t63-2.39231874544788
     9         42d-1*t112*t142*t39*t60*t63+2.3923187454478842d-1*t108*t1
     :         12*t39*t60*t63+2.3923187454478842d-1*t110*t142*t38*t60*t6
     ;         3+2.3923187454478842d-1*t108*t110*t38*t60*t63+2.541232989
     <         148493d-3*t121*t142*t38*t63+2.541232989148493d-3*t108*t12
     =         1*t38*t63+1.9751631321680768d-2*(t223+t222+t221+t220+t219
     >         +t218+1.923661050931536d+0*t217+t203)*t54*t58-6.21814d-2*
     ?         (t223+t222+t221+t220+t219+t218+t203)*t36*t52+t210+t209+t2
     @         08+t207+t190+t189+t188+t187+t186+t184+t183+t182+t181+t179
     1         +t174+t173+t172)+t170+t169+t168+t167+t166+t165+t164+t149+
     2         t148+t146+t120+t118+t115)+1.4222222222222222d+1*gammaaa*g
     3         ammabb*t125*t151*t212*t213*t65+2.6666666666666666d+0*gamm
     4         abb*t1*t124*t126*t151+2.6666666666666666d+0*gammaaa*t1*t1
     5         25*t126*t150)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (1.0d+0*t5*(t34*(-1.538928840745229d+1*
     1         t112*t39*t43*t60*t96*t97*t98+3.847322101863072d+0*t142*t3
     2         8*t39*t60*t96*t97*t98-1.1696447245269295d+0*t147*t54*t92*
     3         t93*t94+2.0d+0*t145*t36*t88*t89*t90-9.087592854964233d-4*
     4         t147*t58*t86+5.495546528376875d-3*t145*t52*t86-1.91385499
     5         63583074d+0*t110*t112*t43*t60*t63-5.980796863619711d-2*t2
     6         32*t38*t39*t60*t63+4.7846374908957684d-1*t112*t142*t39*t6
     7         0*t63+4.7846374908957684d-1*t110*t142*t38*t60*t63-2.03298
     8         63913187946d-2*t112*t121*t43*t63+5.082465978296986d-3*t12
     9         1*t142*t38*t63+1.9751631321680768d-2*(t236+t235+t234+t233
     :         +1.923661050931536d+0*t232+t206+t203)*t54*t58-6.21814d-2*
     ;         (t236+t235+t234+t233+t206+t203)*t36*t52+t211+t210+t209+t2
     <         08+t207+t190+t189+t188+t187+t186+t184+t183+t182+t181+t179
     =         +t174+t173+t172)+4.7846374908957684d-1*t112*t39*t43*t60*t
     >         63-1.1961593727239421d-1*t142*t38*t39*t60*t63+3.950326264
     ?         3361536d-2*t147*t54*t58-1.243628d-1*t145*t36*t52-2.220446
     @         049250313d-16*t129*t134*t135*t32-6.101282288702853d-19*t1
     1         32*t31-2.0d+0*t136*t137*t138*t28-2.642079786267853d-3*t13
     2         2*t27-rhob*t231+t170+t169+t168+t167+t166+t165+t164)+t3*t7
     3         1*(1.2189116922978192d-1*t33*t72+5.485102615340186d-2*gam
     4         mabb*t139)+1.0970205230680373d-1*t20*t231*t71*t72-1.46269
     5         4030757383d-1*t130*t139*t71*t72-2.925388061514766d+0*gamm
     6         abb*t152*t238*t33*t66*t72+1.1701552246059063d+0*gammabb*t
     7         139*t152*t153*t66*t72+4.680620898423625d+0*t214*t224*t237
     8         *t33*t72/rhob**8-9.141837692233644d-2*gammabb*t151*t33*t7
     9         1+2.925388061514766d-1*t152*t224*t225*t33*t66+1.422222222
     :         2222222d+1*t212*t213*t224*t65/rhob**7.333333333333333d+0-
     ;         9.777777777777776d+0*gammabb*t1*t126*t65/rhob**4.66666666
     <         6666667d+0+5.333333333333333d+0*gammabb*t1*t126*t150*t151
     =         )*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (-2.742551307670093d-2*t68*t74*t83-2.1
     1         940410461360746d-1*t127*t154*t66*t69*t83+7.31347015378691
     2         5d-1*t127*t128*t19*t66*t69-1.7552328369088593d+0*gammaaa*
     3         t19*t214*t215*t69/rhoa**7+4.570918846116822d-2*t19*t2*t68
     4         -2.0112042922914017d-1*gammaaa*t127*t19*t216*t66-5.333333
     5         333333333d+0*gammaaa*t157*t212*t213*t65+2.666666666666666
     6         6d+0*t1*t125*t126*t65-1.0d+0*t1*t124*t126*t2)*wght+Cmat2(
     7         iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (-5.333333333333333d+0*gammaaa*t125*t2
     1         12*t213*t3*t65-1.0d+0*t1*t124*t126*t3)*wght+Cmat2(iq,D2_R
     2         A_GBB)
            Cmat2(iq,D2_RB_GAA) = (-5.333333333333333d+0*gammabb*t151*t2
     1         *t212*t213*t65-1.0d+0*t1*t126*t150*t2)*wght+Cmat2(iq,D2_R
     2         B_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (7.313470153786915d-1*t152*t153*t33*t6
     1         6*t72-2.1940410461360746d-1*t139*t152*t155*t66*t72-1.7552
     2         328369088593d+0*gammabb*t214*t237*t33*t72/rhob**7+4.57091
     3         8846116822d-2*t3*t33*t71-2.742551307670093d-2*t130*t139*t
     4         71-2.0112042922914017d-1*gammabb*t152*t238*t33*t66-5.3333
     5         33333333333d+0*gammabb*t212*t213*t225*t65+2.6666666666666
     6         666d+0*t1*t126*t151*t65-1.0d+0*t1*t126*t150*t3)*wght+Cmat
     7         2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (6.582123138408223d-1*t19*t214*t215*t
     1         69/rhoa**6+1.0970205230680373d-1*t127*t128*t19*t66+2.0d+0
     2         *t212*t213*t216*t65)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 2.0d+0*t2*t212*t213*t3*t65*wght+Cmat2
     1         (iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (6.582123138408223d-1*t214*t237*t33*t
     1         72/rhob**6+1.0970205230680373d-1*t152*t153*t33*t66+2.0d+0
     2         *t212*t213*t238*t65)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = (2.1940410461360746d-1*t6*t68*t83-1.462
     1         694030757383d-1*t19*t68*t74+1.1701552246059063d+0*gammaaa
     2         *t127*t128*t19*t66)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (-1.462694030757383d-1*t130*t33*t71+2.1
     1         940410461360746d-1*t139*t20*t71+1.1701552246059063d+0*gam
     2         mabb*t152*t153*t33*t66)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t127*t154*t19*t66*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)-4.388082092272149d
     1         -1*t152*t155*t33*t66*wght
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = gammaaa*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 2.0d+0*taua-2.5d-1*gammaaa/rhoa
            t20 = 1/t3**3
            t21 = 1/rhoa**4.333333333333333d+0
            t22 = 1/rhoa**1.6666666666666669d+0
            t23 = 1/t15
            t24 = 1/t6**3
            t25 = 1/rhoa**1.3333333333333333d+0
            t26 = 1/rhoa**1.1666666666666667d+0
            t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4.0
     1         02143174996817d-1*t24-1.264669550498372d-1*t22
            t28 = 1/t14**2
            t29 = 1/t11
            t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25-8
     1         .223668877838045d-1*t24-1.6039141941921276d-1*t22
            t31 = 1/t10**2
            t32 = 1.0d+0*t13*t29*t30*t31+1.1102230246251565d-16*t17*t23*
     1         t27*t28+3.0506411443514264d-19*t16*t25+1.3210398931339265
     2         d-3*t12*t25
            t33 = 1/rhoa**3.3333333333333337d+0
            t34 = gammaaa**2
            t35 = t1**2
            t36 = 1/t3**4
            t37 = 1/rhoa**5.333333333333333d+0
            t38 = t27**2
            t39 = 1/t6**5
            t40 = 1/rhoa**2.3333333333333334d+0
            t41 = 1/rhoa**2.1666666666666665d+0
            t42 = t30**2
            fnc(iq) = 1.0970205230680373d-1*t18*t19*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0970205230680373d-1*t19*t32*t4*t5*wght-7.
     1         313470153786915d-2*t18*t19*t22*t4*wght+2.742551307670093d
     2         -2*gammaaa*t18*t2*t4*wght+5.850776123029532d-1*gammaaa*t1
     3         *t18*t19*t20*t21*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = -2.742551307670093d-2*t18*t22*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t19*t20*t33*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = t2*t4*(5.485102615340186d-2*gammaaa*t32
     1         *wght+1.2189116922978192d-1*t18*t19*wght)+1.0970205230680
     2         373d-1*t19*t4*(-2.0d+0*t13*t29*t42/t10**3+3.2163958997385
     3         07d+1*t13*t42/(t10**4*t11**2)+1.0d+0*t13*t29*t31*(2.16229
     4         51122684114d+0*t41+1.7087761055320938d+0*t40+1.2335503316
     5         757068d+0*t39+2.673190323653546d-1*t2)+1.1102230246251565
     6         d-16*t17*t23*t28*(1.1632736958443765d+0*t41+9.89141964955
     7         861d-1*t40+6.003214762495226d-1*t39+2.1077825841639536d-1
     8         *t2)-4.0675215258019015d-19*t16*t40-1.7613865241785684d-3
     9         *t12*t40-2.220446049250313d-16*t17*t23*t38/t14**3+1.78545
     :         83920998188d-15*t17*t38/(t14**4*t15**2)-8.497974591333913
     ;         d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*t27*t28
     <         )*t5*wght-1.462694030757383d-1*t19*t22*t32*t4*wght-9.1418
     =         37692233644d-2*gammaaa*t18*t4*wght/rhoa**3.66666666666666
     >         64d+0-2.925388061514766d+0*gammaaa*t1*t18*t19*t20*t37*wgh
     ?         t+4.680620898423625d+0*t18*t19*t34*t35*t36*wght/rhoa**8+2
     @         .925388061514766d-1*t1*t18*t20*t34*wght/rhoa**6.333333333
     1         333333d+0+1.1701552246059063d+0*gammaaa*t1*t19*t20*t21*t3
     2         2*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = -2.742551307670093d-2*t22*t32*t4*wght+
     1         4.570918846116822d-2*t18*t2*t4*wght-2.0112042922914017d-1
     2         *gammaaa*t1*t18*t20*t37*wght-1.7552328369088593d+0*gammaa
     3         a*t18*t19*t35*t36*wght/rhoa**7-2.1940410461360746d-1*t1*t
     4         19*t20*t32*t33*wght+7.313470153786915d-1*t1*t18*t19*t20*t
     5         21*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 6.582123138408223d-1*t18*t19*t35*t36*
     1         wght/rhoa**6+1.0970205230680373d-1*t1*t18*t20*t21*wght+Cm
     2         at2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = 2.1940410461360746d-1*t32*t4*t5*wght-1.
     1         462694030757383d-1*t18*t22*t4*wght+1.1701552246059063d+0*
     2         gammaaa*t1*t18*t20*t21*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t1*t18*t20*t33*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhob**2.6666666666666666d+0
            t3 = gammabb*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhob**6.666666666666666d-1
            t6 = rhob**5.0d-1
            t7 = 1/t6
            t8 = 1/rhob**3.333333333333333d-1
            t9 = 1/rhob**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 2.0d+0*taub-2.5d-1*gammabb/rhob
            t20 = 1/t3**3
            t21 = 1/rhob**4.333333333333333d+0
            t22 = 1/rhob**1.6666666666666669d+0
            t23 = 1/t15
            t24 = 1/t6**3
            t25 = 1/rhob**1.3333333333333333d+0
            t26 = 1/rhob**1.1666666666666667d+0
            t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4.0
     1         02143174996817d-1*t24-1.264669550498372d-1*t22
            t28 = 1/t14**2
            t29 = 1/t11
            t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25-8
     1         .223668877838045d-1*t24-1.6039141941921276d-1*t22
            t31 = 1/t10**2
            t32 = 1.0d+0*t13*t29*t30*t31+1.1102230246251565d-16*t17*t23*
     1         t27*t28+3.0506411443514264d-19*t16*t25+1.3210398931339265
     2         d-3*t12*t25
            t33 = 1/rhob**3.3333333333333337d+0
            t34 = gammabb**2
            t35 = t1**2
            t36 = 1/t3**4
            t37 = 1/rhob**5.333333333333333d+0
            t38 = t27**2
            t39 = 1/t6**5
            t40 = 1/rhob**2.3333333333333334d+0
            t41 = 1/rhob**2.1666666666666665d+0
            t42 = t30**2
            fnc(iq) = 1.0970205230680373d-1*t18*t19*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0970205230680373d-1*t19*t32*t4*t5*wght-7.
     1         313470153786915d-2*t18*t19*t22*t4*wght+2.742551307670093d
     2         -2*gammabb*t18*t2*t4*wght+5.850776123029532d-1*gammabb*t1
     3         *t18*t19*t20*t21*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = -2.742551307670093d-2*t18*t22*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t19*t20*t33*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = t2*t4*(5.485102615340186d-2*gammabb*t32
     1         *wght+1.2189116922978192d-1*t18*t19*wght)+1.0970205230680
     2         373d-1*t19*t4*(-2.0d+0*t13*t29*t42/t10**3+3.2163958997385
     3         07d+1*t13*t42/(t10**4*t11**2)+1.0d+0*t13*t29*t31*(2.16229
     4         51122684114d+0*t41+1.7087761055320938d+0*t40+1.2335503316
     5         757068d+0*t39+2.673190323653546d-1*t2)+1.1102230246251565
     6         d-16*t17*t23*t28*(1.1632736958443765d+0*t41+9.89141964955
     7         861d-1*t40+6.003214762495226d-1*t39+2.1077825841639536d-1
     8         *t2)-4.0675215258019015d-19*t16*t40-1.7613865241785684d-3
     9         *t12*t40-2.220446049250313d-16*t17*t23*t38/t14**3+1.78545
     :         83920998188d-15*t17*t38/(t14**4*t15**2)-8.497974591333913
     ;         d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*t27*t28
     <         )*t5*wght-1.462694030757383d-1*t19*t22*t32*t4*wght-9.1418
     =         37692233644d-2*gammabb*t18*t4*wght/rhob**3.66666666666666
     >         64d+0-2.925388061514766d+0*gammabb*t1*t18*t19*t20*t37*wgh
     ?         t+4.680620898423625d+0*t18*t19*t34*t35*t36*wght/rhob**8+2
     @         .925388061514766d-1*t1*t18*t20*t34*wght/rhob**6.333333333
     1         333333d+0+1.1701552246059063d+0*gammabb*t1*t19*t20*t21*t3
     2         2*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = -2.742551307670093d-2*t22*t32*t4*wght+
     1         4.570918846116822d-2*t18*t2*t4*wght-2.0112042922914017d-1
     2         *gammabb*t1*t18*t20*t37*wght-1.7552328369088593d+0*gammab
     3         b*t18*t19*t35*t36*wght/rhob**7-2.1940410461360746d-1*t1*t
     4         19*t20*t32*t33*wght+7.313470153786915d-1*t1*t18*t19*t20*t
     5         21*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 6.582123138408223d-1*t18*t19*t35*t36*
     1         wght/rhob**6+1.0970205230680373d-1*t1*t18*t20*t21*wght+Cm
     2         at2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 2.1940410461360746d-1*t32*t4*t5*wght-1.
     1         462694030757383d-1*t18*t22*t4*wght+1.1701552246059063d+0*
     2         gammabb*t1*t18*t20*t21*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)-4.388082092272149d
     1         -1*t1*t18*t20*t33*wght
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_b95 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   f &=& {{0.1097020523068037\,{\it t_{10}}\,{\it t_6}\,\left(2.0
C>    \,\tau_\beta-{{0.25\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}+1.0\right)^2}}
C>    +{{0.1097020523068037\,{\it t_5}\,{\it t_1}\,\left(2.0
C>    \,\tau_\alpha-{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\left({\it t_{24}}\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}+1.0\right)^2}}+{{1.0
C>    \,\left({\it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}
C>    \,{\it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}
C>    +1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)}
C>    \over{{\it param}\left(1\right)\,\left({\it t_{23}}\,
C>    \sigma_{\beta\beta}+{\it t_{22}}\,\sigma_{\alpha\alpha}\right)
C>    +1.0}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.1097020523068037\,\left(-6.903522198342671 \times 10^{
C>    -18}\,\log \left({{16.08197949869254}\over{5.98255043577108
C>    \,{\it t_{28}}+2.225569421150687\,{\it t_{27}}
C>    +0.8004286349993635\,{\it t_{26}}+0.1897004325747558\,{
C>    \it t_{25}}}}+1.0\right)\,\left(0.1325688999052018\,{\it t_{27}}
C>    +1.0\right)-0.0310907\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{28}}+3.844746237447211\,{
C>    \it t_{27}}+1.644733775567609\,{\it t_{26}}+0.2405871291288192
C>    \,{\it t_{25}}}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{27}}+1.0\right)\right)\,{\it t_{25}}\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\left({{{
C>    \it t_{24}}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0\right)^2}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 104, 1040 (1996)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.4708298 "> 
C> 10.1063/1.4708298 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b95_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 2*gammaaa*t1*t2+1.0d+0
            t4 = 1/t3
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = -2*rhoa*t18
            t20 = param(2)
            t21 = gammaaa*t2*t20+1.0d+0
            t22 = 1/t21**2
            t23 = 1/rhoa
            t24 = 2.0d+0*taua-2.5d-1*gammaaa*t23
            t25 = 6.299605249474366d-1
            t26 = 1.414213562373095d+0
            t27 = 1/t26
            t28 = 7.937005259840998d-1
            t29 = 8.908987181403393d-1
            t30 = 5.982550435771079d+0*t29*t9+2.2255694211506874d+0*t28*
     1         t8+8.004286349993635d-1*t27*t7+1.8970043257475583d-1*t25*
     2         t5
            t31 = 1.6081979498692536d+1/t30+1.0d+0
            t32 = log(t31)
            t33 = 1.3256889990520176d-1*t28*t8+1.0d+0
            t34 = 1/t15
            t35 = 1/rhoa**1.6666666666666669d+0
            t36 = 1/t6**3
            t37 = 1/rhoa**1.3333333333333333d+0
            t38 = 1/rhoa**1.1666666666666667d+0
            t39 = -9.970917392951799d-1*t38-7.418564737168958d-1*t37-4.0
     1         02143174996817d-1*t36-1.264669550498372d-1*t35
            t40 = 1/t14**2
            t41 = 1/t11
            t42 = -1.8533958105157808d+0*t38-1.2815820791490704d+0*t37-8
     1         .223668877838045d-1*t36-1.6039141941921276d-1*t35
            t43 = 1/t10**2
            t44 = 1.0d+0*t13*t41*t42*t43+1.1102230246251565d-16*t17*t34*
     1         t39*t40+3.0506411443514264d-19*t16*t37+1.3210398931339265
     2         d-3*t12*t37
            t45 = 1/t31
            t46 = 3.149802624737183d-1
            t47 = 1/t26**3
            t48 = 3.968502629920499d-1
            t49 = 4.4544935907016964d-1
            t50 = -9.970917392951799d-1*t38*t49-7.418564737168958d-1*t37
     1         *t48-4.002143174996817d-1*t36*t47-1.264669550498372d-1*t3
     2         5*t46
            t51 = 1/t30**2
            t52 = 2*rhoa*(1.0d+0*t33*t45*t50*t51+2.747773264188437d-3*t3
     1         2*t37*t48)-rhoa*t44-6.21814d-2*t32*t33+6.903522198342671d
     2         -18*t16*t17+3.1090699999999993d-2*t12*t13
            t53 = 1/t3**2
            t54 = 1/rhoa**3.6666666666666664d+0
            t55 = t19-1.243628d-1*rhoa*t32*t33
            t56 = 1/t21**3
            t57 = 1/rhoa**4.333333333333333d+0
            t58 = 1/rhoa**3.3333333333333337d+0
            t59 = gammaaa**2
            t60 = 1/rhoa**6.333333333333333d+0
            t61 = 5.333333333333333d+0*gammaaa*t1*t52*t53*t54
            t62 = 2.0d+0*t33*t45*t50*t51
            t63 = 5.495546528376875d-3*t32*t37*t48
            t64 = 1/t15**2
            t65 = t39**2
            t66 = 1/t14**4
            t67 = 1/t14**3
            t68 = 1/t6**5
            t69 = 1/rhoa**2.3333333333333334d+0
            t70 = 1/rhoa**2.1666666666666665d+0
            t71 = 1.1632736958443765d+0*t70+9.89141964955861d-1*t69+6.00
     1         3214762495226d-1*t68+2.1077825841639536d-1*t2
            t72 = 1/t11**2
            t73 = t42**2
            t74 = 1/t10**4
            t75 = 1/t10**3
            t76 = 2.1622951122684114d+0*t70+1.7087761055320938d+0*t69+1.
     1         2335503316757068d+0*t68+2.673190323653546d-1*t2
            t77 = 1.0d+0*t13*t41*t43*t76-2.0d+0*t13*t41*t73*t75+3.216395
     1         899738507d+1*t13*t72*t73*t74+1.1102230246251565d-16*t17*t
     2         34*t40*t71-4.0675215258019015d-19*t16*t69-1.7613865241785
     3         684d-3*t12*t69-2.220446049250313d-16*t17*t34*t65*t67+1.78
     4         54583920998188d-15*t17*t64*t65*t66-8.497974591333913d-2*t
     5         37*t41*t42*t43-9.812069668265515d-18*t34*t37*t39*t40
            t78 = 1/t31**2
            t79 = t50**2
            t80 = 1/t30**4
            t81 = 1.6081979498692536d+1*t33*t78*t79*t80
            t82 = 1/t30**3
            t83 = -2.0d+0*t33*t45*t79*t82
            t84 = 1.9842513149602492d-1
            t85 = 9.89141964955861d-1*t69*t84+2.5908976111853255d-1*t70+
     1         6.003214762495226d-1*t68/t26**5+3.319549557987472d-2*t2
            t86 = 1.0d+0*t33*t45*t51*t85
            t87 = -3.663697685584583d-3*t32*t69*t84
            t88 = 8.157414703487641d+0*t29*t9+2.247591863577616d+0*t28*t
     1         8+4.3009724712766434d-1*t27*t7+1.9115125951273373d-1*t25*
     2         t5
            t89 = 2.9608813203268075d+1/t88+1.0d+0
            t90 = log(t89)
            t91 = 6.901399211255825d-2*t28*t8+1.0d+0
            t92 = 1/rhoa**2
            t93 = -8.837926660346784d-2*t37*t45*t48*t50*t51
            t94 = 2*rhoa*(t93+8.443431970194815d-3*t90*t91*t92+t87+t86+t
     1         83+t81)-rhoa*t77+t63+t62-2.0d+0*t13*t41*t42*t43-2.2204460
     2         49250313d-16*t17*t34*t39*t40-6.101282288702853d-19*t16*t3
     3         7-2.642079786267853d-3*t12*t37
            t95 = t1**2
            t96 = 1/t3**3
            t97 = 1/rhoa**7.333333333333333d+0
            t98 = 1.4222222222222222d+1*t55*t59*t95*t96*t97
            t99 = 1/rhoa**4.666666666666667d+0
            t100 = t20**2
            t101 = 1/t21**4
            t102 = 1/rhoa**8
            t103 = 1/rhoa**5.333333333333333d+0
            t104 = 5.485102615340186d-2*gammaaa*t44+1.2189116922978192d-
     1         1*t18*t24
            t105 = -8.443431970194815d-3*t90*t91*t92
            t106 = 2*rhoa*(t93+t87+t86+t83+t81+t105)+t63+t62
            t107 = -1.0d+0*t1*t2*t52*t53
            t108 = -5.333333333333333d+0*gammaaa*t55*t60*t95*t96
            t109 = 1/rhoa**7
            t110 = 1/rhoa**6
            t111 = gammaaa**3
            t112 = 1/rhoa**10
            t113 = 4.2666666666666664d+1*t52*t59*t95*t96*t97
            t114 = 4.824593849607761d+1*t33*t78*t79*t80
            t115 = -6.0d+0*t33*t45*t79*t82
            t116 = 3.0d+0*t33*t45*t51*t85
            t117 = -1.099109305675375d-2*t32*t69*t84
            t118 = -2.6513779981040353d-1*t37*t45*t48*t50*t51
            t119 = t39**3
            t120 = 1/t6**7
            t121 = 1/rhoa**3.1666666666666665d+0
            t122 = t42**3
            t123 = -6.0d+0*t13*t41*t42*t75*t76+9.649187699215522d+1*t13*
     1         t42*t72*t74*t76-1.274696188700087d-1*t37*t41*t43*t76+2.54
     2         9392377400174d-1*t37*t41*t73*t75-4.0999275947472624d+0*t3
     3         7*t72*t73*t74+6.0d+0*t122*t13*t41*t74-1.9298375398431045d
     4         +2*t122*t13*t72/t10**5-6.661338147750939d-16*t17*t34*t39*
     5         t67*t71+5.356375176299456d-15*t17*t39*t64*t66*t71-1.47181
     6         04502398274d-17*t34*t37*t40*t71+1.6995949182667827d-1*t41
     7         *t42*t43*t69+1.962413933653103d-17*t34*t39*t40*t69+2.9436
     8         20900479655d-17*t34*t37*t65*t67-2.3669625486718335d-16*t3
     9         7*t64*t65*t66+6.661338147750939d-16*t119*t17*t34*t66-1.07
     :         12750352598913d-14*t119*t17*t64/t14**5+9.490883560204437d
     ;         -19*t16*t58+4.1099018897499934d-3*t12*t58+1.1102230246251
     <         565d-16*t17*t34*t40*(-2.3079979182303428d+0*t58-5.6207535
     =         57770543d-1*t54-2.520426340996149d+0*t121-1.5008036906238
     >         065d+0*t120)+1.0d+0*t13*t41*t43*(-3.9871442462415524d+0*t
     ?         58-7.128507529742789d-1*t54-4.684972743248224d+0*t121-3.0
     @         83875829189267d+0*t120)+5.742741051503565d-14*t119*t17/(t
     1         14**6*t15**3)+2.0690405167709364d+3*t122*t13/(t10**6*t11*
     2         *3)
            t124 = t50**3
            t125 = 5.172601291927341d+2*t124*t33/(t30**6*t31**3)
            t126 = -9.649187699215522d+1*t124*t33*t78/t30**5
            t127 = 6.0d+0*t124*t33*t45*t80
            t128 = 4.824593849607761d+1*t33*t50*t78*t80*t85
            t129 = -6.0d+0*t33*t45*t50*t82*t85
            t130 = 9.921256574801247d-2
            t131 = 1.0d+0*t33*t45*t51*(-2.3079979182303428d+0*t130*t58-4
     1         .4260660773166294d-2*t54-1.5008036906238065d+0*t120/t26**
     2         7-2.8068057454507694d-1*t121)
            t132 = 8.548627933030694d-3*t130*t32*t58
            t133 = 1/rhoa**3
            t134 = 1.767585332069357d-1*t45*t50*t51*t69*t84
            t135 = 1/t89
            t136 = -1.3595691172479402d+0*t38*t49-7.491972878592053d-1*t
     1         37*t48-2.1504862356383217d-1*t36*t47-1.2743417300848914d-
     2         1*t35*t46
            t137 = 1/t88**2
            t138 = -2.1319703304396778d+0*t37*t48*t78*t79*t80
            t139 = 2.6513779981040353d-1*t37*t45*t48*t79*t82
            t140 = -1.3256889990520176d-1*t37*t45*t48*t51*t85
            t141 = t1**3
            t142 = 1/t3**4
            t143 = 1.1377777777777777d+2*t111*t141*t142*t55/rhoa**11
            t144 = 1/rhoa**8.333333333333334d+0
            t145 = t20**3
            t146 = 1/t21**5
            t147 = 1/rhoa**9
            t148 = -1.0666666666666666d+1*gammaaa*t52*t60*t95*t96
            t149 = -1.0d+0*t1*t2*t53*t94
            t150 = -4.2666666666666664d+1*t112*t141*t142*t55*t59
            t151 = 2.0d+0*t103*t52*t95*t96
            t152 = 1.6d+1*gammaaa*t141*t142*t147*t55
            fnc(iq) = (1.0d+0*t4*(t19-1.243628d-1*rhoa*(1.05220005583892
     1         12d-1*t8+1.0d+0)*log(1.6081979498692536d+1/(5.32984651443
     2         8383d+0*t9+1.766435620181429d+0*t8+5.659885156639418d-1*t
     3         7+1.19503784087549d-1*t5)+1.0d+0))+2.1940410461360746d-1*
     4         t18*t22*t24*t5)*wght+fnc(iq)
            Amat(iq,D1_RA) = (5.850776123029532d-1*gammaaa*t18*t20*t24*t
     1         56*t57+2.6666666666666666d+0*gammaaa*t1*t53*t54*t55+1.0d+
     2         0*t4*t52+1.0970205230680373d-1*t22*t24*t44*t5-7.313470153
     3         786915d-2*t18*t22*t24*t35+2.742551307670093d-2*gammaaa*t1
     4         8*t2*t22)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-2.1940410461360746d-1*t18*t20*t24*t56*t5
     1         8-1.0d+0*t1*t2*t53*t55-2.742551307670093d-2*t18*t22*t35)*
     2         wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t22*t5*wght+Mmat(
     1         iq,D1_TA)
            Amat2(iq,D2_RA_RA) = (-9.777777777777776d+0*gammaaa*t1*t53*t
     1         55*t99+t98+1.0d+0*t4*t94+1.0970205230680373d-1*t22*t24*t5
     2         *t77+t61+2.925388061514766d-1*t18*t20*t56*t59*t60+4.68062
     3         0898423625d+0*t100*t101*t102*t18*t24*t59+1.17015522460590
     4         63d+0*gammaaa*t20*t24*t44*t56*t57-2.925388061514766d+0*ga
     5         mmaaa*t103*t18*t20*t24*t56-9.141837692233644d-2*gammaaa*t
     6         18*t22*t54-1.462694030757383d-1*t22*t24*t35*t44+t104*t2*t
     7         22)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t98+t61+1.0d+0*t106*t4)*wght+Amat2(iq,
     1         D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (-2.1940410461360746d-1*t20*t24*t44*t5
     1         6*t58+7.313470153786915d-1*t18*t20*t24*t56*t57-2.01120429
     2         22914017d-1*gammaaa*t103*t18*t20*t56+2.6666666666666666d+
     3         0*t1*t53*t54*t55-2.742551307670093d-2*t22*t35*t44-1.75523
     4         28369088593d+0*gammaaa*t100*t101*t109*t18*t24+4.570918846
     5         116822d-2*t18*t2*t22+t108+t107)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (t108+t107)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (2.0d+0*t103*t55*t95*t96+1.0970205230
     1         680373d-1*t18*t20*t56*t57+6.582123138408223d-1*t100*t101*
     2         t110*t18*t24)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 2.0d+0*t103*t55*t95*t96*wght+Cmat2(iq
     1         ,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = (1.1701552246059063d+0*gammaaa*t18*t20*
     1         t56*t57+2.1940410461360746d-1*t22*t44*t5-1.46269403075738
     2         3d-1*t18*t22*t35)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t18*t20*t56*t58*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Amat3(iq,D3_RA_RA_RA) = (-2.933333333333333d+1*gammaaa*t1*t5
     1         2*t53*t99+3.3520071538190027d-1*gammaaa*t18*t22*t99-3.071
     2         657464590504d+0*t18*t20*t56*t59*t97-1.5644444444444444d+2
     3         *t144*t55*t59*t95*t96+8.0d+0*gammaaa*t1*t53*t54*t94+1.0d+
     4         0*t4*(2*rhoa*(-7.5d-1*t135*t136*t137*t91*t92-2.5330295910
     5         58444d-2*t133*t90*t91-5.82714947393947d-4*t48*t58*t90+t14
     6         0+t139+t138+t134+t132+t131+t129+t128+t127+t126+t125)+2.53
     7         30295910584444d-2*t90*t91*t92-3.0d+0*t13*t41*t43*t76+6.0d
     8         +0*t13*t41*t73*t75-9.649187699215522d+1*t13*t72*t73*t74-3
     9         .3306690738754696d-16*t17*t34*t40*t71+1.2202564577405706d
     :         -18*t16*t69+5.284159572535705d-3*t12*t69+6.66133814775093
     ;         9d-16*t17*t34*t65*t67-5.356375176299456d-15*t17*t64*t65*t
     <         66+2.549392377400174d-1*t37*t41*t42*t43+2.943620900479655
     =         d-17*t34*t37*t39*t40-rhoa*t123+t118+t117+t116+t115+t114)+
     >         t2*t22*(3.047279230744548d-2*gammaaa*t18*t92+8.2276539230
     ?         1028d-2*gammaaa*t77+3.6567350768934576d-1*t24*t44)+1.7552
     @         328369088593d+0*gammaaa*t20*t24*t56*t57*t77-2.19404104613
     1         60743d-1*t22*t24*t35*t77+t56*(5.850776123029532d-1*t20*t4
     2         4*t59+1.5602069661412085d+1*gammaaa*t18*t20*t24)*t60+5.33
     3         3333333333333d+0*gammaaa*t104*t20*t56*t60+1.4041862695270
     4         876d+1*t100*t101*t102*t24*t44*t59-6.084807167950713d+1*t1
     5         00*t101*t147*t18*t24*t59-8.776164184544297d+0*gammaaa*t10
     6         3*t20*t24*t44*t56+4.5629629629629626d+1*gammaaa*t1*t53*t5
     7         5/rhoa**5.666666666666667d+0-1.27985727691271d-1*gammaaa*
     8         t22*t44*t54-2.6666666666666666d+0*t104*t22*t54+1.09702052
     9         30680373d-1*t123*t22*t24*t5+4.9926622916518665d+1*t111*t1
     :         45*t146*t18*t24/rhoa**1.1666666666666665d+1+3.51046567381
     ;         77187d+0*t100*t101*t111*t112*t18+t143+t113)*wght+Amat3(iq
     <         ,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = (-9.777777777777776d+0*gammaaa*t1*t5
     1         2*t53*t99-5.214814814814814d+1*t144*t55*t59*t95*t96+2.666
     2         6666666666666d+0*gammaaa*t1*t53*t54*t94+1.0d+0*t4*(2*rhoa
     3         *(2.5d-1*t135*t136*t137*t91*t92+8.443431970194815d-3*t133
     4         *t90*t91+1.9423831579798237d-4*t48*t58*t90+t140+t139+t138
     5         +t134+t132+t131+t129+t128+t127+t126+t125)+t118+t117+t116+
     6         t115+t114+t105)+5.333333333333333d+0*gammaaa*t1*t106*t53*
     7         t54+t143+t113)*wght+Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (-9.777777777777776d+0*t1*t53*t55*t
     1         99+4.8d+1*gammaaa*t55*t95*t96*t97-2.1940410461360746d-1*t
     2         20*t24*t56*t58*t77-2.742551307670093d-2*t22*t35*t77+1.499
     3         2613815263175d+0*gammaaa*t18*t20*t56*t60-1.87224835936945
     4         03d+1*t145*t146*t18*t24*t59/rhoa**1.0666666666666666d+1-2
     5         .047771643060336d+0*t100*t101*t147*t18*t59+1.462694030757
     6         383d+0*t20*t24*t44*t56*t57+t103*(-2.925388061514766d-1*ga
     7         mmaaa*t20*t44-2.925388061514766d+0*t18*t20*t24-2*t104*t20
     8         )*t56+5.333333333333333d+0*t1*t52*t53*t54-9.1418376922336
     9         44d-2*t18*t22*t54-3.5104656738177187d+0*gammaaa*t100*t101
     :         *t109*t24*t44+t2*t22*(9.141837692233644d-2*t44-3.04727923
     ;         0744548d-2*t18*t23)+1.813740598139155d+1*gammaaa*t100*t10
     <         1*t102*t18*t24+t150+t149+t148)*wght+Cmat3(iq,D3_RA_RA_GAA
     =         )
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = (1.9555555555555554d+1*gammaaa*t55*
     1         t95*t96*t97+t150+t149+t148)*wght+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = (1.4222222222222222d+1*gammaaa*t55*
     1         t95*t96*t97+2.6666666666666666d+0*t1*t52*t53*t54-1.0d+0*t
     2         1*t106*t2*t53+t150+t148)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = (-1.0666666666666666d+1*t55*t60*t9
     1         5*t96+1.0970205230680373d-1*t20*t44*t56*t57-4.75375559996
     2         14944d-1*t103*t18*t20*t56+6.582123138408223d-1*t100*t101*
     3         t110*t24*t44+7.020931347635437d+0*gammaaa*t145*t146*t18*t
     4         24/rhoa**9.666666666666666d+0-3.9492738830449337d+0*t100*
     5         t101*t109*t18*t24+1.0421694969146353d+0*gammaaa*t100*t101
     6         *t102*t18+t152+t151)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = (-5.333333333333333d+0*t55*t60*t95
     1         *t96+t152+t151)*wght+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = (t152+t151)*wght+Cmat3(iq,D3_RA_GB
     1         B_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (-6.0d+0*t102*t141*t142*t55-2.632
     1         8492553632893d+0*t145*t146*t18*t24/rhoa**8.66666666666666
     2         6d+0-4.9365923538061673d-1*t100*t101*t109*t18)*wght+Cmat3
     3         (iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)-6.0d+0*t
     1         102*t141*t142*t55*wght
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Mmat3(iq,D3_RA_RA_TA) = (2.1940410461360746d-1*t22*t5*t77+9.
     1         36124179684725d+0*t100*t101*t102*t18*t59+2.34031044921181
     2         26d+0*gammaaa*t20*t44*t56*t57-5.850776123029532d+0*gammaa
     3         a*t103*t18*t20*t56-2.925388061514766d-1*t22*t35*t44+2.437
     4         8233845956385d-1*t18*t2*t22)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_GAA_TA) = (-4.388082092272149d-1*t20*t44*t56*
     1         t58+1.462694030757383d+0*t18*t20*t56*t57-3.51046567381771
     2         87d+0*gammaaa*t100*t101*t109*t18)*wght+Mmat3(iq,D3_RA_GAA
     3         _TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.3164246276816446d+0*t100*t101*t1
     1         10*t18*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = t1*(gammabb*t3+gammaaa*t2)+1.0d+0
            t5 = 1/t4
            t6 = 1/rhoa**6.666666666666666d-1
            t7 = rhoa**5.0d-1
            t8 = 1/t7
            t9 = 1/rhoa**3.333333333333333d-1
            t10 = 1/rhoa**1.6666666666666666d-1
            t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.405
     1         8712912881916d-1*t6+1.1120374863094686d+1*t10
            t12 = 3.216395899738507d+1/t11+1.0d+0
            t13 = log(t12)
            t14 = 1.274696188700087d-1*t9+1.0d+0
            t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.897
     1         0043257475583d-1*t6+5.982550435771079d+0*t10
            t16 = 1.6081979498692536d+1/t15+1.0d+0
            t17 = log(t16)
            t18 = 1.3256889990520176d-1*t9+1.0d+0
            t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2*t
     1         13*t14
            t20 = 1/rhob**6.666666666666666d-1
            t21 = rhob**5.0d-1
            t22 = 1/t21
            t23 = 1/rhob**3.333333333333333d-1
            t24 = 1/rhob**1.6666666666666666d-1
            t25 = 1.1120374863094686d+1*t24+3.8447462374472113d+0*t23+1.
     1         644733775567609d+0*t22+2.4058712912881916d-1*t20
            t26 = 3.216395899738507d+1/t25+1.0d+0
            t27 = log(t26)
            t28 = 1.274696188700087d-1*t23+1.0d+0
            t29 = 5.982550435771079d+0*t24+2.2255694211506874d+0*t23+8.0
     1         04286349993635d-1*t22+1.8970043257475583d-1*t20
            t30 = 1.6081979498692536d+1/t29+1.0d+0
            t31 = log(t30)
            t32 = 1.3256889990520176d-1*t23+1.0d+0
            t33 = -6.903522198342671d-18*t31*t32-3.1090699999999993d-2*t
     1         27*t28
            t34 = rhob+rhoa
            t35 = 1/t34**3.333333333333333d-1
            t36 = 1.3256889990520176d-1*t35+1.0d+0
            t37 = rhoa-rhob
            t38 = t37**4
            t39 = 1/t34**4
            t40 = 1/t34
            t41 = 1.0d+0-t37*t40
            t42 = t37*t40+1.0d+0
            t43 = t42**1.3333333333333333d+0+t41**1.3333333333333333d+0-
     1         2.0d+0
            t44 = -1.923661050931536d+0*t38*t39*t43
            t45 = t44+1.0d+0
            t46 = 1/t34**6.666666666666666d-1
            t47 = t34**5.0d-1
            t48 = 1/t47
            t49 = 1/t34**1.6666666666666666d-1
            t50 = 5.982550435771079d+0*t49+8.004286349993635d-1*t48+1.89
     1         70043257475583d-1*t46+2.2255694211506874d+0*t35
            t51 = 1.6081979498692536d+1/t50+1.0d+0
            t52 = log(t51)
            t53 = -6.21814d-2*t36*t45*t52
            t54 = 6.901399211255825d-2*t35+1.0d+0
            t55 = t44+1.923661050931536d+0*t43
            t56 = 8.157414703487641d+0*t49+4.3009724712766434d-1*t48+1.9
     1         115125951273373d-1*t46+2.247591863577616d+0*t35
            t57 = 2.9608813203268075d+1/t56+1.0d+0
            t58 = log(t57)
            t59 = 1.9751631321680768d-2*t54*t55*t58
            t60 = 1.274696188700087d-1*t35+1.0d+0
            t61 = 1.1120374863094686d+1*t49+1.644733775567609d+0*t48+2.4
     1         058712912881916d-1*t46+3.8447462374472113d+0*t35
            t62 = 3.216395899738507d+1/t61+1.0d+0
            t63 = log(t62)
            t64 = -5.980796863619711d-2*t38*t39*t43*t60*t63
            t65 = t34*(t64+t59+t53)-rhob*t33-rhoa*t19
            t66 = param(2)
            t67 = gammaaa*t2*t66+1.0d+0
            t68 = 1/t67**2
            t69 = 1/rhoa
            t70 = 2.0d+0*taua-2.5d-1*gammaaa*t69
            t71 = gammabb*t3*t66+1.0d+0
            t72 = 1/t71**2
            t73 = 1/rhob
            t74 = 2.0d+0*taub-2.5d-1*gammabb*t73
            t75 = 1/t16
            t76 = 1/rhoa**1.6666666666666669d+0
            t77 = 1/t7**3
            t78 = 1/rhoa**1.3333333333333333d+0
            t79 = 1/rhoa**1.1666666666666667d+0
            t80 = -9.970917392951799d-1*t79-7.418564737168958d-1*t78-4.0
     1         02143174996817d-1*t77-1.264669550498372d-1*t76
            t81 = 1/t15**2
            t82 = 1/t12
            t83 = -1.8533958105157808d+0*t79-1.2815820791490704d+0*t78-8
     1         .223668877838045d-1*t77-1.6039141941921276d-1*t76
            t84 = 1/t11**2
            t85 = 1.0d+0*t14*t82*t83*t84+1.1102230246251565d-16*t18*t75*
     1         t80*t81+3.0506411443514264d-19*t17*t78+1.3210398931339265
     2         d-3*t13*t78
            t86 = 1/t34**1.6666666666666669d+0
            t87 = 1/t47**3
            t88 = 1/t34**1.3333333333333333d+0
            t89 = 1/t34**1.1666666666666667d+0
            t90 = -9.970917392951799d-1*t89-7.418564737168958d-1*t88-4.0
     1         02143174996817d-1*t87-1.264669550498372d-1*t86
            t91 = 1/t50**2
            t92 = 1/t51
            t93 = 1.0d+0*t36*t45*t90*t91*t92
            t94 = -1.3595691172479402d+0*t89-7.491972878592053d-1*t88-2.
     1         1504862356383217d-1*t87-1.2743417300848914d-1*t86
            t95 = 1/t56**2
            t96 = 1/t57
            t97 = -5.848223622634647d-1*t54*t55*t94*t95*t96
            t98 = -1.8533958105157808d+0*t89-1.2815820791490704d+0*t88-8
     1         .223668877838045d-1*t87-1.6039141941921276d-1*t86
            t99 = 1/t61**2
            t100 = 1/t62
            t101 = 1.923661050931536d+0*t100*t38*t39*t43*t60*t98*t99
            t102 = 1/t34**2
            t103 = t102*t37
            t104 = -t40
            t105 = t104+t103
            t106 = t41**3.333333333333333d-1
            t107 = -t102*t37
            t108 = t40+t107
            t109 = t42**3.333333333333333d-1
            t110 = 1.3333333333333333d+0*t108*t109+1.3333333333333333d+0
     1         *t105*t106
            t111 = -1.923661050931536d+0*t110*t38*t39
            t112 = 1/t34**5
            t113 = 7.694644203726144d+0*t112*t38*t43
            t114 = t37**3
            t115 = -7.694644203726144d+0*t114*t39*t43
            t116 = t115+t113+t111
            t117 = -6.21814d-2*t116*t36*t52
            t118 = 2.747773264188437d-3*t45*t52*t88
            t119 = t115+t113+t111+1.923661050931536d+0*t110
            t120 = 1.9751631321680768d-2*t119*t54*t58
            t121 = -4.5437964274821163d-4*t55*t58*t88
            t122 = -5.980796863619711d-2*t110*t38*t39*t60*t63
            t123 = 1/t34**5.333333333333333d+0
            t124 = 2.541232989148493d-3*t123*t38*t43*t63
            t125 = 2.3923187454478842d-1*t112*t38*t43*t60*t63
            t126 = t34*(t97+t93-2.3923187454478842d-1*t114*t39*t43*t60*t
     1         63+t125+t124+t122+t121+t120+t118+t117+t101)-rhoa*t85+t64+
     2         t59+t53+6.903522198342671d-18*t17*t18+3.1090699999999993d
     3         -2*t13*t14
            t127 = 1/rhoa**3.6666666666666664d+0
            t128 = 1/t4**2
            t129 = 1/t67**3
            t130 = 1/rhoa**4.333333333333333d+0
            t131 = 1/t30
            t132 = 1/rhob**1.6666666666666669d+0
            t133 = 1/t21**3
            t134 = 1/rhob**1.3333333333333333d+0
            t135 = 1/rhob**1.1666666666666667d+0
            t136 = -9.970917392951799d-1*t135-7.418564737168958d-1*t134-
     1         4.002143174996817d-1*t133-1.264669550498372d-1*t132
            t137 = 1/t29**2
            t138 = 1/t26
            t139 = -1.8533958105157808d+0*t135-1.2815820791490704d+0*t13
     1         4-8.223668877838045d-1*t133-1.6039141941921276d-1*t132
            t140 = 1/t25**2
            t141 = 1.1102230246251565d-16*t131*t136*t137*t32+3.050641144
     1         3514264d-19*t134*t31+1.0d+0*t138*t139*t140*t28+1.32103989
     2         31339265d-3*t134*t27
            t142 = t40+t103
            t143 = t107+t104
            t144 = 1.3333333333333333d+0*t109*t143+1.3333333333333333d+0
     1         *t106*t142
            t145 = -1.923661050931536d+0*t144*t38*t39
            t146 = 7.694644203726144d+0*t114*t39*t43
            t147 = t146+t145+t113
            t148 = -6.21814d-2*t147*t36*t52
            t149 = t146+t145+1.923661050931536d+0*t144+t113
            t150 = 1.9751631321680768d-2*t149*t54*t58
            t151 = -5.980796863619711d-2*t144*t38*t39*t60*t63
            t152 = t34*(t97+t93+2.3923187454478842d-1*t114*t39*t43*t60*t
     1         63+t151+t150+t148+t125+t124+t121+t118+t101)+t64+t59+t53+6
     2         .903522198342671d-18*t31*t32+3.1090699999999993d-2*t27*t2
     3         8-rhob*t141
            t153 = 1/rhob**3.6666666666666664d+0
            t154 = 1/t71**3
            t155 = 1/rhob**4.333333333333333d+0
            t156 = 1/rhoa**3.3333333333333337d+0
            t157 = 1/rhob**3.3333333333333337d+0
            t158 = gammaaa**2
            t159 = 1/rhoa**6.333333333333333d+0
            t160 = 1/t16**2
            t161 = t80**2
            t162 = 1/t15**4
            t163 = 1/t15**3
            t164 = 1/t7**5
            t165 = 1/rhoa**2.3333333333333334d+0
            t166 = 1/rhoa**2.1666666666666665d+0
            t167 = 2.1077825841639536d-1*t2+1.1632736958443765d+0*t166+9
     1         .89141964955861d-1*t165+6.003214762495226d-1*t164
            t168 = 1/t12**2
            t169 = t83**2
            t170 = 1/t11**4
            t171 = 1/t11**3
            t172 = 2.673190323653546d-1*t2+2.1622951122684114d+0*t166+1.
     1         7087761055320938d+0*t165+1.2335503316757068d+0*t164
            t173 = -8.497974591333913d-2*t78*t82*t83*t84+1.0d+0*t14*t172
     1         *t82*t84-2.0d+0*t14*t169*t171*t82-9.812069668265515d-18*t
     2         75*t78*t80*t81+1.1102230246251565d-16*t167*t18*t75*t81-2.
     3         220446049250313d-16*t161*t163*t18*t75+1.7854583920998188d
     4         -15*t160*t161*t162*t18+3.216395899738507d+1*t14*t168*t169
     5         *t170-4.0675215258019015d-19*t165*t17-1.7613865241785684d
     6         -3*t13*t165
            t174 = 2.0d+0*t36*t45*t90*t91*t92
            t175 = -1.1696447245269295d+0*t54*t55*t94*t95*t96
            t176 = 3.847322101863072d+0*t100*t38*t39*t43*t60*t98*t99
            t177 = 5.495546528376875d-3*t45*t52*t88
            t178 = -9.087592854964233d-4*t55*t58*t88
            t179 = 5.082465978296986d-3*t123*t38*t43*t63
            t180 = 4.7846374908957684d-1*t112*t38*t43*t60*t63
            t181 = t90**2
            t182 = 1/t50**4
            t183 = 1/t51**2
            t184 = 1.6081979498692536d+1*t181*t182*t183*t36*t45
            t185 = 2.0d+0*t116*t36*t90*t91*t92
            t186 = 1/t50**3
            t187 = -2.0d+0*t181*t186*t36*t45*t92
            t188 = -8.837926660346784d-2*t45*t88*t90*t91*t92
            t189 = 1/t34**2.6666666666666666d+0
            t190 = 1/t47**5
            t191 = 1/t34**2.3333333333333334d+0
            t192 = 1/t34**2.1666666666666665d+0
            t193 = 1.1632736958443765d+0*t192+9.89141964955861d-1*t191+6
     1         .003214762495226d-1*t190+2.1077825841639536d-1*t189
            t194 = 1.0d+0*t193*t36*t45*t91*t92
            t195 = t94**2
            t196 = 1/t56**4
            t197 = 1/t57**2
            t198 = -1.73158960813529d+1*t195*t196*t197*t54*t55
            t199 = -1.1696447245269295d+0*t119*t54*t94*t95*t96
            t200 = 1/t56**3
            t201 = 1.1696447245269295d+0*t195*t200*t54*t55*t96
            t202 = 2.690728393099896d-2*t55*t88*t94*t95*t96
            t203 = 1.5861639701225969d+0*t192+9.98929717145607d-1*t191+3
     1         .2257293534574827d-1*t190+2.1239028834748191d-1*t189
            t204 = -5.848223622634647d-1*t203*t54*t55*t95*t96
            t205 = t98**2
            t206 = 1/t61**4
            t207 = 1/t62**2
            t208 = 6.187255516702861d+1*t205*t206*t207*t38*t39*t43*t60
            t209 = 3.847322101863072d+0*t100*t110*t38*t39*t60*t98*t99
            t210 = 1/t61**3
            t211 = -3.847322101863072d+0*t100*t205*t210*t38*t39*t43*t60
            t212 = -1.6347222733154887d-1*t100*t123*t38*t43*t98*t99
            t213 = 2.1622951122684114d+0*t192+1.7087761055320938d+0*t191
     1         +1.2335503316757068d+0*t190+2.673190323653546d-1*t189
            t214 = 1.923661050931536d+0*t100*t213*t38*t39*t43*t60*t99
            t215 = -1.538928840745229d+1*t100*t112*t38*t43*t60*t98*t99
            t216 = 1.538928840745229d+1*t100*t114*t39*t43*t60*t98*t99
            t217 = t105**2
            t218 = 1/t41**6.666666666666666d-1
            t219 = 1/t34**3
            t220 = -2*t219*t37
            t221 = 2*t102
            t222 = t221+t220
            t223 = t108**2
            t224 = 1/t42**6.666666666666666d-1
            t225 = 2*t219*t37
            t226 = -2*t102
            t227 = t226+t225
            t228 = 1.3333333333333333d+0*t109*t227+4.444444444444444d-1*
     1         t223*t224+1.3333333333333333d+0*t106*t222+4.4444444444444
     2         44d-1*t217*t218
            t229 = -1.923661050931536d+0*t228*t38*t39
            t230 = 1.5389288407452287d+1*t110*t112*t38
            t231 = -1.5389288407452287d+1*t110*t114*t39
            t232 = 1/t34**6
            t233 = -3.8473221018630716d+1*t232*t38*t43
            t234 = 6.155715362980915d+1*t112*t114*t43
            t235 = t37**2
            t236 = -2.3083932611178434d+1*t235*t39*t43
            t237 = t236+t234+t233+t231+t230+t229
            t238 = -6.21814d-2*t237*t36*t52
            t239 = 5.495546528376875d-3*t116*t52*t88
            t240 = -3.663697685584583d-3*t191*t45*t52
            t241 = t236+t234+t233+t231+t230+t229+1.923661050931536d+0*t2
     1         28
            t242 = 1.9751631321680768d-2*t241*t54*t58
            t243 = -9.087592854964233d-4*t119*t58*t88
            t244 = 6.058395236642822d-4*t191*t55*t58
            t245 = -5.980796863619711d-2*t228*t38*t39*t60*t63
            t246 = 5.082465978296986d-3*t110*t123*t38*t63
            t247 = 4.7846374908957684d-1*t110*t112*t38*t60*t63
            t248 = 1/t34**6.333333333333333d+0
            t249 = -2.3718174565385935d-2*t248*t38*t43*t63
            t250 = 2.0329863913187946d-2*t114*t123*t43*t63
            t251 = -1.1961593727239421d+0*t232*t38*t43*t60*t63
            t252 = 1.9138549963583074d+0*t112*t114*t43*t60*t63
            t253 = -7.176956236343652d-1*t235*t39*t43*t60*t63
            t254 = -2.0d+0*t14*t82*t83*t84-2.220446049250313d-16*t18*t75
     1         *t80*t81-6.101282288702853d-19*t17*t78-2.642079786267853d
     2         -3*t13*t78+t34*(-4.7846374908957684d-1*t110*t114*t39*t60*
     3         t63+t253+t252+t251+t250+t249+t247+t246+t245+t244+t243+t24
     4         2+t240+t239+t238+t216+t215+t214+t212+t211+t209+t208+t204+
     5         t202+t201+t199+t198+t194+t188+t187+t185+t184)-4.784637490
     6         8957684d-1*t114*t39*t43*t60*t63-1.1961593727239421d-1*t11
     7         0*t38*t39*t60*t63+3.9503262643361536d-2*t119*t54*t58-1.24
     8         3628d-1*t116*t36*t52+t180+t179+t178+t177+t176+t175+t174-r
     9         hoa*t173
            t255 = t1**2
            t256 = 1/rhoa**7.333333333333333d+0
            t257 = 1/t4**3
            t258 = 1/rhoa**4.666666666666667d+0
            t259 = t66**2
            t260 = 1/t67**4
            t261 = 1/rhoa**8
            t262 = 1/rhoa**5.333333333333333d+0
            t263 = 5.485102615340186d-2*gammaaa*t85+1.2189116922978192d-
     1         1*t19*t70
            t264 = 2.6666666666666666d+0*t109*t219*t37-2.666666666666666
     1         6d+0*t106*t219*t37+4.444444444444444d-1*t108*t143*t224+4.
     2         444444444444444d-1*t105*t142*t218
            t265 = -1.923661050931536d+0*t264*t38*t39
            t266 = 7.694644203726144d+0*t112*t144*t38
            t267 = -7.694644203726144d+0*t114*t144*t39
            t268 = 7.694644203726144d+0*t110*t112*t38
            t269 = 7.694644203726144d+0*t110*t114*t39
            t270 = 2.3083932611178434d+1*t235*t39*t43
            t271 = t270+t269+t268+t267+t266+t265+t233
            t272 = t270+t269+t268+t267+t266+t265+1.923661050931536d+0*t2
     1         64+t233
            t273 = 7.176956236343652d-1*t235*t39*t43*t60*t63
            t274 = t34*(1.923661050931536d+0*t100*t144*t38*t39*t60*t98*t
     1         99+1.923661050931536d+0*t100*t110*t38*t39*t60*t98*t99-5.8
     2         48223622634647d-1*t149*t54*t94*t95*t96-5.848223622634647d
     3         -1*t119*t54*t94*t95*t96+1.0d+0*t147*t36*t90*t91*t92+1.0d+
     4         0*t116*t36*t90*t91*t92-4.5437964274821163d-4*t149*t58*t88
     5         -4.5437964274821163d-4*t119*t58*t88+2.747773264188437d-3*
     6         t147*t52*t88+2.747773264188437d-3*t116*t52*t88-5.98079686
     7         3619711d-2*t264*t38*t39*t60*t63-2.3923187454478842d-1*t11
     8         4*t144*t39*t60*t63+2.3923187454478842d-1*t110*t114*t39*t6
     9         0*t63+2.3923187454478842d-1*t112*t144*t38*t60*t63+2.39231
     :         87454478842d-1*t110*t112*t38*t60*t63+2.541232989148493d-3
     ;         *t123*t144*t38*t63+2.541232989148493d-3*t110*t123*t38*t63
     <         +1.9751631321680768d-2*t272*t54*t58-6.21814d-2*t271*t36*t
     =         52+t273+t251+t249+t244+t240+t215+t214+t212+t211+t208+t204
     >         +t202+t201+t198+t194+t188+t187+t184)+t180+t179+t178+t177+
     ?         t176+t175+t174+t151+t150+t148+t122+t120+t117
            t275 = gammabb**2
            t276 = 1/rhob**6.333333333333333d+0
            t277 = 1/t30**2
            t278 = t136**2
            t279 = 1/t29**4
            t280 = 1/t29**3
            t281 = 1/t21**5
            t282 = 1/rhob**2.3333333333333334d+0
            t283 = 1/rhob**2.1666666666666665d+0
            t284 = 2.1077825841639536d-1*t3+1.1632736958443765d+0*t283+9
     1         .89141964955861d-1*t282+6.003214762495226d-1*t281
            t285 = 1/t26**2
            t286 = t139**2
            t287 = 1/t25**4
            t288 = 1/t25**3
            t289 = 2.673190323653546d-1*t3+2.1622951122684114d+0*t283+1.
     1         7087761055320938d+0*t282+1.2335503316757068d+0*t281
            t290 = 1.1102230246251565d-16*t131*t137*t284*t32-2.220446049
     1         250313d-16*t131*t278*t280*t32+1.7854583920998188d-15*t277
     2         *t278*t279*t32-4.0675215258019015d-19*t282*t31+1.0d+0*t13
     3         8*t140*t28*t289-2.0d+0*t138*t28*t286*t288+3.2163958997385
     4         07d+1*t28*t285*t286*t287-1.7613865241785684d-3*t27*t282-8
     5         .497974591333913d-2*t134*t138*t139*t140-9.812069668265515
     6         d-18*t131*t134*t136*t137
            t291 = 2.0d+0*t147*t36*t90*t91*t92
            t292 = -1.1696447245269295d+0*t149*t54*t94*t95*t96
            t293 = 3.847322101863072d+0*t100*t144*t38*t39*t60*t98*t99
            t294 = -1.538928840745229d+1*t100*t114*t39*t43*t60*t98*t99
            t295 = t142**2
            t296 = t226+t220
            t297 = t143**2
            t298 = t225+t221
            t299 = 1.3333333333333333d+0*t109*t298+4.444444444444444d-1*
     1         t224*t297+1.3333333333333333d+0*t106*t296+4.4444444444444
     2         44d-1*t218*t295
            t300 = -1.923661050931536d+0*t299*t38*t39
            t301 = 1.5389288407452287d+1*t112*t144*t38
            t302 = 1.5389288407452287d+1*t114*t144*t39
            t303 = -6.155715362980915d+1*t112*t114*t43
            t304 = t303+t302+t301+t300+t236+t233
            t305 = -6.21814d-2*t304*t36*t52
            t306 = 5.495546528376875d-3*t147*t52*t88
            t307 = t303+t302+t301+t300+1.923661050931536d+0*t299+t236+t2
     1         33
            t308 = 1.9751631321680768d-2*t307*t54*t58
            t309 = -9.087592854964233d-4*t149*t58*t88
            t310 = -5.980796863619711d-2*t299*t38*t39*t60*t63
            t311 = 5.082465978296986d-3*t123*t144*t38*t63
            t312 = 4.7846374908957684d-1*t112*t144*t38*t60*t63
            t313 = -2.0329863913187946d-2*t114*t123*t43*t63
            t314 = -1.9138549963583074d+0*t112*t114*t43*t60*t63
            t315 = t34*(4.7846374908957684d-1*t114*t144*t39*t60*t63+t314
     1         +t313+t312+t311+t310+t309+t308+t306+t305+t294+t293+t292+t
     2         291+t253+t251+t249+t244+t240+t215+t214+t212+t211+t208+t20
     3         4+t202+t201+t198+t194+t188+t187+t184)+4.7846374908957684d
     4         -1*t114*t39*t43*t60*t63-1.1961593727239421d-1*t144*t38*t3
     5         9*t60*t63+3.9503262643361536d-2*t149*t54*t58-1.243628d-1*
     6         t147*t36*t52-2.220446049250313d-16*t131*t136*t137*t32-6.1
     7         01282288702853d-19*t134*t31-rhob*t290-2.0d+0*t138*t139*t1
     8         40*t28-2.642079786267853d-3*t134*t27+t180+t179+t178+t177+
     9         t176+t175+t174
            t316 = 1/rhob**7.333333333333333d+0
            t317 = 1/rhob**4.666666666666667d+0
            t318 = 1/t71**4
            t319 = 1/rhob**8
            t320 = 1/rhob**5.333333333333333d+0
            t321 = 1.2189116922978192d-1*t33*t74+5.485102615340186d-2*ga
     1         mmabb*t141
            t322 = 1/rhoa**7
            t323 = 1/rhob**7
            t324 = 1/rhoa**6
            t325 = 1/rhob**6
            t326 = gammaaa**3
            t327 = 1/rhoa**10
            t328 = t1**3
            t329 = 1/t4**4
            t330 = t80**3
            t331 = 1/t7**7
            t332 = 1/rhoa**3.1666666666666665d+0
            t333 = t83**3
            t334 = 1.6995949182667827d-1*t165*t82*t83*t84-1.274696188700
     1         087d-1*t172*t78*t82*t84+1.0d+0*t14*(-4.684972743248224d+0
     2         *t332-3.083875829189267d+0*t331-3.9871442462415524d+0*t15
     3         6-7.128507529742789d-1*t127)*t82*t84-6.0d+0*t14*t171*t172
     4         *t82*t83+9.649187699215522d+1*t14*t168*t170*t172*t83+2.54
     5         9392377400174d-1*t169*t171*t78*t82+6.0d+0*t14*t170*t333*t
     6         82+1.962413933653103d-17*t165*t75*t80*t81-1.4718104502398
     7         274d-17*t167*t75*t78*t81+1.1102230246251565d-16*t18*(-2.5
     8         20426340996149d+0*t332-1.5008036906238065d+0*t331-2.30799
     9         79182303428d+0*t156-5.620753557770543d-1*t127)*t75*t81-6.
     :         661338147750939d-16*t163*t167*t18*t75*t80+5.3563751762994
     ;         56d-15*t160*t162*t167*t18*t80+2.943620900479655d-17*t161*
     <         t163*t75*t78-4.0999275947472624d+0*t168*t169*t170*t78-2.3
     =         669625486718335d-16*t160*t161*t162*t78+6.661338147750939d
     >         -16*t162*t18*t330*t75-1.9298375398431045d+2*t14*t168*t333
     ?         /t11**5+2.0690405167709364d+3*t14*t333/(t11**6*t12**3)-1.
     @         0712750352598913d-14*t160*t18*t330/t15**5+5.7427410515035
     1         65d-14*t18*t330/(t15**6*t16**3)+9.490883560204437d-19*t15
     2         6*t17+4.1099018897499934d-3*t13*t156
            t335 = 4.824593849607761d+1*t181*t182*t183*t36*t45
            t336 = -6.0d+0*t181*t186*t36*t45*t92
            t337 = -2.6513779981040353d-1*t45*t88*t90*t91*t92
            t338 = 3.0d+0*t193*t36*t45*t91*t92
            t339 = -5.19476882440587d+1*t195*t196*t197*t54*t55
            t340 = 3.5089341735807883d+0*t195*t200*t54*t55*t96
            t341 = 8.072185179299687d-2*t55*t88*t94*t95*t96
            t342 = -1.7544670867903941d+0*t203*t54*t55*t95*t96
            t343 = 1.856176655010858d+2*t205*t206*t207*t38*t39*t43*t60
            t344 = -1.1541966305589217d+1*t100*t205*t210*t38*t39*t43*t60
            t345 = -4.904166819946466d-1*t100*t123*t38*t43*t98*t99
            t346 = 5.770983152794609d+0*t100*t213*t38*t39*t43*t60*t99
            t347 = -4.616786522235687d+1*t100*t112*t38*t43*t60*t98*t99
            t348 = -1.099109305675375d-2*t191*t45*t52
            t349 = 1.8175185709928465d-3*t191*t55*t58
            t350 = -7.11545236961578d-2*t248*t38*t43*t63
            t351 = -3.588478118171826d+0*t232*t38*t43*t60*t63
            t352 = -2.1530868709030954d+0*t235*t39*t43*t60*t63
            t353 = t90**3
            t354 = 5.172601291927341d+2*t353*t36*t45/(t50**6*t51**3)
            t355 = -9.649187699215522d+1*t183*t353*t36*t45/t50**5
            t356 = 4.824593849607761d+1*t182*t183*t193*t36*t45*t90
            t357 = -2.1319703304396778d+0*t181*t182*t183*t45*t88
            t358 = 6.0d+0*t182*t353*t36*t45*t92
            t359 = -6.0d+0*t186*t193*t36*t45*t90*t92
            t360 = 2.6513779981040353d-1*t181*t186*t45*t88*t92
            t361 = -1.3256889990520176d-1*t193*t45*t88*t91*t92
            t362 = 1.767585332069357d-1*t191*t45*t90*t91*t92
            t363 = 1/t34**3.6666666666666664d+0
            t364 = 1/t47**7
            t365 = 1/t34**3.3333333333333337d+0
            t366 = 1/t34**3.1666666666666665d+0
            t367 = 1.0d+0*t36*(-2.520426340996149d+0*t366-2.307997918230
     1         3428d+0*t365-1.5008036906238065d+0*t364-5.620753557770543
     2         d-1*t363)*t45*t91*t92
            t368 = t94**3
            t369 = -1.0254062650399592d+3*t368*t54*t55/(t56**6*t57**3)
            t370 = 1.0389537648811739d+2*t197*t368*t54*t55/t56**5
            t371 = -5.19476882440587d+1*t196*t197*t203*t54*t55*t94
            t372 = 1.1950391155803675d+0*t195*t196*t197*t55*t88
            t373 = -3.5089341735807883d+0*t196*t368*t54*t55*t96
            t374 = 3.5089341735807883d+0*t200*t203*t54*t55*t94*t96
            t375 = -8.072185179299687d-2*t195*t200*t55*t88*t96
            t376 = 4.0360925896498434d-2*t203*t55*t88*t95*t96
            t377 = -5.381456786199791d-2*t191*t55*t94*t95*t96
            t378 = -5.848223622634647d-1*(-3.436688601932293d+0*t366-2.3
     1         308360066730832d+0*t365-8.064323383643707d-1*t364-5.66374
     2         1022599518d-1*t363)*t54*t55*t95*t96
            t379 = t98**3
            t380 = 3.9801326549115085d+3*t379*t38*t39*t43*t60/(t61**6*t6
     1         2**3)
            t381 = -3.712353310021716d+2*t207*t379*t38*t39*t43*t60/t61**
     1         5
            t382 = 1.856176655010858d+2*t206*t207*t213*t38*t39*t43*t60*t
     1         98
            t383 = -7.424706620043432d+2*t112*t205*t206*t207*t38*t43*t60
            t384 = -7.886871025654724d+0*t123*t205*t206*t207*t38*t43
            t385 = 1.1541966305589217d+1*t100*t206*t379*t38*t39*t43*t60
            t386 = -1.1541966305589217d+1*t100*t210*t213*t38*t39*t43*t60
     1         *t98
            t387 = 4.616786522235687d+1*t100*t112*t205*t210*t38*t43*t60
            t388 = 4.904166819946466d-1*t100*t123*t205*t210*t38*t43
            t389 = -2.452083409973233d-1*t100*t123*t213*t38*t43*t99
            t390 = 2.2886111826416838d+0*t100*t248*t38*t43*t98*t99
            t391 = 1.923661050931536d+0*t100*(-4.684972743248224d+0*t366
     1         -3.9871442462415524d+0*t365-3.083875829189267d+0*t364-7.1
     2         28507529742789d-1*t363)*t38*t39*t43*t60*t99
            t392 = -2.3083932611178434d+1*t100*t112*t213*t38*t43*t60*t99
            t393 = 1.1541966305589217d+2*t100*t232*t38*t43*t60*t98*t99
            t394 = 6.925179783353531d+1*t100*t235*t39*t43*t60*t98*t99
            t395 = 8.548627933030694d-3*t365*t45*t52
            t396 = 1/t41**1.6666666666666669d+0
            t397 = 6*t37*t39
            t398 = -6*t219
            t399 = 1/t42**1.6666666666666669d+0
            t400 = -6*t37*t39
            t401 = 6*t219
            t402 = 1.3333333333333333d+0*t109*(t401+t400)-2.962962962962
     1         963d-1*t108**3*t399+1.3333333333333333d+0*t106*(t398+t397
     2         )-2.962962962962963d-1*t105**3*t396+1.3333333333333333d+0
     3         *t108*t224*t227+1.3333333333333333d+0*t105*t218*t222
            t403 = -1.923661050931536d+0*t38*t39*t402
            t404 = 2.3083932611178434d+1*t112*t228*t38
            t405 = -2.3083932611178434d+1*t114*t228*t39
            t406 = -1.1541966305589216d+2*t110*t232*t38
            t407 = 1.8467146088942746d+2*t110*t112*t114
            t408 = -6.925179783353531d+1*t110*t235*t39
            t409 = 1/t34**7
            t410 = 2.3083932611178432d+2*t38*t409*t43
            t411 = -4.6167865222356863d+2*t114*t232*t43
            t412 = 2.770071913341412d+2*t112*t235*t43
            t413 = -4.616786522235687d+1*t37*t39*t43
            t414 = -1.4136255552166585d-3*t365*t55*t58
            t415 = 2.0103976536374746d-1*t38*t43*t63/t34**7.333333333333
     1         333d+0
            t416 = 9.148438760934575d-2*t123*t235*t43*t63
            t417 = 7.176956236343652d+0*t38*t409*t43*t60*t63
            t418 = 8.612347483612381d+0*t112*t235*t43*t60*t63
            t419 = -1.4353912472687305d+0*t37*t39*t43*t60*t63
            t420 = t66**3
            t421 = 1/t67**5
            t422 = 1/rhoa**9
            t423 = -1.243628d-1*t271*t36*t52
            t424 = 3.9503262643361536d-2*t272*t54*t58
            t425 = -1.1961593727239421d-1*t264*t38*t39*t60*t63
            t426 = 2.0d+0*t271*t36*t90*t91*t92
            t427 = -1.1696447245269295d+0*t272*t54*t94*t95*t96
            t428 = 3.847322101863072d+0*t100*t264*t38*t39*t60*t98*t99
            t429 = -2.3083932611178434d+1*t100*t235*t39*t43*t60*t98*t99
            t430 = 5.495546528376875d-3*t271*t52*t88
            t431 = 1.5389288407452287d+1*t112*t264*t38
            t432 = -1.5389288407452287d+1*t114*t264*t39
            t433 = 1.3333333333333333d+0*t109*(t400+2*t219)-2.9629629629
     1         62963d-1*t143*t223*t399+1.3333333333333333d+0*t106*(t397-
     2         2*t219)-2.962962962962963d-1*t142*t217*t396+1.77777777777
     3         77776d+0*t108*t219*t224*t37-1.7777777777777776d+0*t105*t2
     4         18*t219*t37+4.444444444444444d-1*t143*t224*t227+4.4444444
     5         44444444d-1*t142*t218*t222
            t434 = -1.923661050931536d+0*t38*t39*t433
            t435 = 7.694644203726144d+0*t112*t228*t38
            t436 = 7.694644203726144d+0*t114*t228*t39
            t437 = -3.8473221018630716d+1*t144*t232*t38
            t438 = 6.155715362980915d+1*t112*t114*t144
            t439 = -2.3083932611178434d+1*t144*t235*t39
            t440 = -7.694644203726143d+1*t110*t232*t38
            t441 = 4.616786522235687d+1*t110*t235*t39
            t442 = -1.5389288407452287d+2*t114*t232*t43
            t443 = -9.233573044471374d+1*t112*t235*t43
            t444 = 4.616786522235687d+1*t37*t39*t43
            t445 = -9.087592854964233d-4*t272*t58*t88
            t446 = 5.082465978296986d-3*t123*t264*t38*t63
            t447 = 4.7846374908957684d-1*t112*t264*t38*t60*t63
            t448 = -2.870782494537461d+0*t112*t235*t43*t60*t63
            t449 = 1.4353912472687305d+0*t37*t39*t43*t60*t63
            t450 = -2.962962962962963d-1*t108*t297*t399-2.96296296296296
     1         3d-1*t105*t295*t396-8*t109*t37*t39+8*t106*t37*t39+1.77777
     2         77777777776d+0*t143*t219*t224*t37-1.7777777777777776d+0*t
     3         142*t218*t219*t37+4.444444444444444d-1*t108*t224*t298+4.4
     4         44444444444444d-1*t105*t218*t296-2.6666666666666666d+0*t1
     5         09*t219+2.6666666666666666d+0*t106*t219
            t451 = -1.923661050931536d+0*t38*t39*t450
            t452 = 1.5389288407452287d+1*t114*t264*t39
            t453 = 7.694644203726144d+0*t112*t299*t38
            t454 = -7.694644203726144d+0*t114*t299*t39
            t455 = -7.694644203726143d+1*t144*t232*t38
            t456 = 4.616786522235687d+1*t144*t235*t39
            t457 = -3.8473221018630716d+1*t110*t232*t38
            t458 = -6.155715362980915d+1*t110*t112*t114
            t459 = -2.3083932611178434d+1*t110*t235*t39
            t460 = 1.5389288407452287d+2*t114*t232*t43
            t461 = gammabb**3
            t462 = 1/rhob**10
            t463 = t136**3
            t464 = 1/t21**7
            t465 = 1/rhob**3.1666666666666665d+0
            t466 = t139**3
            t467 = 6.0d+0*t138*t28*t287*t466-1.9298375398431045d+2*t28*t
     1         285*t466/t25**5+2.0690405167709364d+3*t28*t466/(t25**6*t2
     2         6**3)+1.1102230246251565d-16*t131*t137*t32*(-2.5204263409
     3         96149d+0*t465-1.5008036906238065d+0*t464-2.30799791823034
     4         28d+0*t157-5.620753557770543d-1*t153)+1.0d+0*t138*t140*t2
     5         8*(-4.684972743248224d+0*t465-3.083875829189267d+0*t464-3
     6         .9871442462415524d+0*t157-7.128507529742789d-1*t153)+5.74
     7         2741051503565d-14*t32*t463/(t29**6*t30**3)-1.071275035259
     8         8913d-14*t277*t32*t463/t29**5+6.661338147750939d-16*t131*
     9         t279*t32*t463-6.661338147750939d-16*t131*t136*t280*t284*t
     :         32+5.356375176299456d-15*t136*t277*t279*t284*t32+9.490883
     ;         560204437d-19*t157*t31-6.0d+0*t138*t139*t28*t288*t289+9.6
     <         49187699215522d+1*t139*t28*t285*t287*t289-1.2746961887000
     =         87d-1*t134*t138*t140*t289+2.549392377400174d-1*t134*t138*
     >         t286*t288-4.0999275947472624d+0*t134*t285*t286*t287-1.471
     ?         8104502398274d-17*t131*t134*t137*t284+1.6995949182667827d
     @         -1*t138*t139*t140*t282+1.962413933653103d-17*t131*t136*t1
     1         37*t282+2.943620900479655d-17*t131*t134*t278*t280-2.36696
     2         25486718335d-16*t134*t277*t278*t279+4.1099018897499934d-3
     3         *t157*t27
            t468 = 1.3333333333333333d+0*t106*(t401+t397)+1.333333333333
     1         3333d+0*t109*(t400+t398)-2.962962962962963d-1*t143**3*t39
     2         9-2.962962962962963d-1*t142**3*t396+1.3333333333333333d+0
     3         *t143*t224*t298+1.3333333333333333d+0*t142*t218*t296
            t469 = -1.923661050931536d+0*t38*t39*t468
            t470 = 2.3083932611178434d+1*t112*t299*t38
            t471 = 2.3083932611178434d+1*t114*t299*t39
            t472 = -1.1541966305589216d+2*t144*t232*t38
            t473 = -1.8467146088942746d+2*t112*t114*t144
            t474 = -6.925179783353531d+1*t144*t235*t39
            t475 = 4.6167865222356863d+2*t114*t232*t43
            t476 = 1/t71**5
            t477 = 1/rhob**9
            fnc(iq) = (1.0970205230680373d-1*t20*t33*t72*t74+1.097020523
     1         0680373d-1*t19*t6*t68*t70+1.0d+0*t5*t65)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0970205230680373d-1*t6*t68*t70*t85-7.313
     1         470153786915d-2*t19*t68*t70*t76+5.850776123029532d-1*gamm
     2         aaa*t129*t130*t19*t66*t70+2.742551307670093d-2*gammaaa*t1
     3         9*t2*t68+2.6666666666666666d+0*gammaaa*t1*t127*t128*t65+1
     4         .0d+0*t126*t5)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-7.313470153786915d-2*t132*t33*t72*t74+1.0
     1         970205230680373d-1*t141*t20*t72*t74+5.850776123029532d-1*
     2         gammabb*t154*t155*t33*t66*t74+2.742551307670093d-2*gammab
     3         b*t3*t33*t72+2.6666666666666666d+0*gammabb*t1*t128*t153*t
     4         65+1.0d+0*t152*t5)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = (-2.742551307670093d-2*t19*t68*t76-2.19404
     1         10461360746d-1*t129*t156*t19*t66*t70-1.0d+0*t1*t128*t2*t6
     2         5)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-2.1940410461360746d-1*t154*t157*t33*t66*
     1         t74-2.742551307670093d-2*t132*t33*t72-1.0d+0*t1*t128*t3*t
     2         65)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t19*t6*t68*wght+Mmat(
     1         iq,D1_TA)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t20*t33*t72*wght+Mmat
     1         (iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (-1.462694030757383d-1*t68*t70*t76*t85+
     1         1.1701552246059063d+0*gammaaa*t129*t130*t66*t70*t85+1.097
     2         0205230680373d-1*t173*t6*t68*t70-2.925388061514766d+0*gam
     3         maaa*t129*t19*t262*t66*t70+4.680620898423625d+0*t158*t19*
     4         t259*t260*t261*t70+t2*t263*t68-9.141837692233644d-2*gamma
     5         aa*t127*t19*t68+2.925388061514766d-1*t129*t158*t159*t19*t
     6         66-9.777777777777776d+0*gammaaa*t1*t128*t258*t65+1.422222
     7         2222222222d+1*t158*t255*t256*t257*t65+1.0d+0*t254*t5+5.33
     8         3333333333333d+0*gammaaa*t1*t126*t127*t128)*wght+Amat2(iq
     9         ,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (1.4222222222222222d+1*gammaaa*gammabb*
     1         t127*t153*t255*t257*t65+1.0d+0*t274*t5+2.6666666666666666
     2         d+0*gammabb*t1*t126*t128*t153+2.6666666666666666d+0*gamma
     3         aa*t1*t127*t128*t152)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (1.0970205230680373d-1*t20*t290*t72*t74
     1         -1.462694030757383d-1*t132*t141*t72*t74-2.925388061514766
     2         d+0*gammabb*t154*t320*t33*t66*t74+1.1701552246059063d+0*g
     3         ammabb*t141*t154*t155*t66*t74+4.680620898423625d+0*t259*t
     4         275*t318*t319*t33*t74-9.141837692233644d-2*gammabb*t153*t
     5         33*t72+t3*t321*t72+2.925388061514766d-1*t154*t275*t276*t3
     6         3*t66-9.777777777777776d+0*gammabb*t1*t128*t317*t65+1.422
     7         2222222222222d+1*t255*t257*t275*t316*t65+1.0d+0*t315*t5+5
     8         .333333333333333d+0*gammabb*t1*t128*t152*t153)*wght+Amat2
     9         (iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (-2.742551307670093d-2*t68*t76*t85-2.1
     1         940410461360746d-1*t129*t156*t66*t70*t85+7.31347015378691
     2         5d-1*t129*t130*t19*t66*t70-1.7552328369088593d+0*gammaaa*
     3         t19*t259*t260*t322*t70+4.570918846116822d-2*t19*t2*t68-2.
     4         0112042922914017d-1*gammaaa*t129*t19*t262*t66-5.333333333
     5         333333d+0*gammaaa*t159*t255*t257*t65+2.6666666666666666d+
     6         0*t1*t127*t128*t65-1.0d+0*t1*t126*t128*t2)*wght+Cmat2(iq,
     7         D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = (-5.333333333333333d+0*gammaaa*t127*t2
     1         55*t257*t3*t65-1.0d+0*t1*t126*t128*t3)*wght+Cmat2(iq,D2_R
     2         A_GBB)
            Cmat2(iq,D2_RB_GAA) = (-5.333333333333333d+0*gammabb*t153*t2
     1         *t255*t257*t65-1.0d+0*t1*t128*t152*t2)*wght+Cmat2(iq,D2_R
     2         B_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (7.313470153786915d-1*t154*t155*t33*t6
     1         6*t74-2.1940410461360746d-1*t141*t154*t157*t66*t74-1.7552
     2         328369088593d+0*gammabb*t259*t318*t323*t33*t74+4.57091884
     3         6116822d-2*t3*t33*t72-2.742551307670093d-2*t132*t141*t72-
     4         2.0112042922914017d-1*gammabb*t154*t320*t33*t66-5.3333333
     5         33333333d+0*gammabb*t255*t257*t276*t65+2.6666666666666666
     6         d+0*t1*t128*t153*t65-1.0d+0*t1*t128*t152*t3)*wght+Cmat2(i
     7         q,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (6.582123138408223d-1*t19*t259*t260*t
     1         324*t70+1.0970205230680373d-1*t129*t130*t19*t66+2.0d+0*t2
     2         55*t257*t262*t65)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 2.0d+0*t2*t255*t257*t3*t65*wght+Cmat2
     1         (iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (6.582123138408223d-1*t259*t318*t325*
     1         t33*t74+1.0970205230680373d-1*t154*t155*t33*t66+2.0d+0*t2
     2         55*t257*t320*t65)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = (2.1940410461360746d-1*t6*t68*t85-1.462
     1         694030757383d-1*t19*t68*t76+1.1701552246059063d+0*gammaaa
     2         *t129*t130*t19*t66)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (-1.462694030757383d-1*t132*t33*t72+2.1
     1         940410461360746d-1*t141*t20*t72+1.1701552246059063d+0*gam
     2         mabb*t154*t155*t33*t66)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t129*t156*t19*t66*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)-4.388082092272149d
     1         -1*t154*t157*t33*t66*wght
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t5*(t34*(-1.8467146088942746
     1         d+2*t100*t112*t114*t43*t60*t98*t99+5.770983152794609d+0*t
     2         100*t228*t38*t39*t60*t98*t99+4.616786522235687d+1*t100*t1
     3         10*t114*t39*t60*t98*t99-4.616786522235687d+1*t100*t110*t1
     4         12*t38*t60*t98*t99-1.9616667279785865d+0*t100*t114*t123*t
     5         43*t98*t99-4.904166819946466d-1*t100*t110*t123*t38*t98*t9
     6         9+2.3083932611178434d+1*t100*t114*t213*t39*t43*t60*t99+5.
     7         770983152794609d+0*t100*t110*t213*t38*t39*t60*t99+8.07218
     8         5179299687d-2*t119*t88*t94*t95*t96-1.7544670867903941d+0*
     9         t241*t54*t94*t95*t96-1.7544670867903941d+0*t119*t203*t54*
     :         t95*t96+3.5089341735807883d+0*t119*t195*t200*t54*t96-2.65
     ;         13779981040353d-1*t116*t88*t90*t91*t92+3.0d+0*t237*t36*t9
     <         0*t91*t92+3.0d+0*t116*t193*t36*t91*t92-6.0d+0*t116*t181*t
     =         186*t36*t92-1.363138928244635d-3*t241*t58*t88+8.243319792
     >         565312d-3*t237*t52*t88-1.4353912472687305d+1*t114*t232*t4
     ?         3*t60*t63-5.980796863619711d-2*t38*t39*t402*t60*t63-2.153
     @         0868709030954d+0*t110*t235*t39*t60*t63-7.176956236343652d
     1         -1*t114*t228*t39*t60*t63-3.588478118171826d+0*t110*t232*t
     2         38*t60*t63+7.176956236343652d-1*t112*t228*t38*t60*t63+5.7
     3         41564989074922d+0*t110*t112*t114*t60*t63-2.84618094784631
     4         24d-1*t114*t248*t43*t63-7.11545236961578d-2*t110*t248*t38
     5         *t63+7.623698967445479d-3*t123*t228*t38*t63+6.09895917395
     6         6384d-2*t110*t114*t123*t63-4.616786522235687d+1*t100*t114
     7         *t205*t210*t39*t43*t60+7.424706620043432d+2*t114*t205*t20
     8         6*t207*t39*t43*t60-1.1541966305589217d+1*t100*t110*t205*t
     9         210*t38*t39*t60+1.856176655010858d+2*t110*t205*t206*t207*
     :         t38*t39*t60+1.9751631321680768d-2*(t413+t412+t411+t410+t4
     ;         08+t407+t406+t405+t404+t403+1.923661050931536d+0*t402)*t5
     <         4*t58+1.8175185709928465d-3*t119*t191*t58-5.1947688244058
     =         7d+1*t119*t195*t196*t197*t54-6.21814d-2*t36*(t413+t412+t4
     >         11+t410+t408+t407+t406+t405+t404+t403)*t52-1.099109305675
     ?         375d-2*t116*t191*t52+t419+t418+t417+t416+t415+t414+t395+t
     @         394+t393+t392+t391+t390+t389+t388+t387+t386+t385+t384+t38
     1         3+t382+t381+t380+t378+t377+t376+t375+t374+t373+t372+t371+
     2         t370+t369+t367+t362+t361+t360+4.824593849607761d+1*t116*t
     3         181*t182*t183*t36+t359+t358+t357+t356+t355+t354)+4.616786
     4         522235687d+1*t100*t114*t39*t43*t60*t98*t99+1.154196630558
     5         9217d+1*t100*t110*t38*t39*t60*t98*t99-3.5089341735807883d
     6         +0*t119*t54*t94*t95*t96+6.0d+0*t116*t36*t90*t91*t92-2.726
     7         27785648927d-3*t119*t58*t88+1.6486639585130625d-2*t116*t5
     8         2*t88+2.549392377400174d-1*t78*t82*t83*t84-3.0d+0*t14*t17
     9         2*t82*t84+6.0d+0*t14*t169*t171*t82+2.943620900479655d-17*
     :         t75*t78*t80*t81-3.3306690738754696d-16*t167*t18*t75*t81+6
     ;         .661338147750939d-16*t161*t163*t18*t75+5.741564989074922d
     <         +0*t112*t114*t43*t60*t63-1.794239059085913d-1*t228*t38*t3
     =         9*t60*t63-1.4353912472687305d+0*t110*t114*t39*t60*t63+1.4
     >         353912472687305d+0*t110*t112*t38*t60*t63+6.09895917395638
     ?         4d-2*t114*t123*t43*t63+1.524739793489096d-2*t110*t123*t38
     @         *t63+5.92548939650423d-2*t241*t54*t58-1.865442d-1*t237*t3
     1         6*t52+t352+t351+t350+t349+t348+t347+t346+t345+t344+t343+t
     2         342+t341+t340+t339+t338+t337+t336+t335-rhoa*t334-5.356375
     3         176299456d-15*t160*t161*t162*t18-9.649187699215522d+1*t14
     4         *t168*t169*t170+1.2202564577405706d-18*t165*t17+5.2841595
     5         72535705d-3*t13*t165)+t2*t68*(3.6567350768934576d-1*t70*t
     6         85+3.047279230744548d-2*gammaaa*t19/rhoa**2+8.22765392301
     7         028d-2*gammaaa*t173)+t129*t159*(5.850776123029532d-1*t158
     8         *t66*t85+1.5602069661412085d+1*gammaaa*t19*t66*t70)-8.776
     9         164184544297d+0*gammaaa*t129*t262*t66*t70*t85+1.404186269
     :         5270876d+1*t158*t259*t260*t261*t70*t85-1.27985727691271d-
     ;         1*gammaaa*t127*t68*t85-2.1940410461360743d-1*t173*t68*t70
     <         *t76+1.0970205230680373d-1*t334*t6*t68*t70+1.755232836908
     =         8593d+0*gammaaa*t129*t130*t173*t66*t70-6.084807167950713d
     >         +1*t158*t19*t259*t260*t422*t70+4.9926622916518665d+1*t19*
     ?         t326*t420*t421*t70/rhoa**1.1666666666666665d+1-2.66666666
     @         66666666d+0*t127*t263*t68+3.3520071538190027d-1*gammaaa*t
     1         19*t258*t68+5.333333333333333d+0*gammaaa*t129*t159*t263*t
     2         66-3.071657464590504d+0*t129*t158*t19*t256*t66+1.13777777
     3         77777777d+2*t326*t328*t329*t65/rhoa**11-1.564444444444444
     4         4d+2*t158*t255*t257*t65/rhoa**8.333333333333334d+0+4.5629
     5         629629629626d+1*gammaaa*t1*t128*t65/rhoa**5.6666666666666
     6         67d+0+3.5104656738177187d+0*t19*t259*t260*t326*t327-2.933
     7         333333333333d+1*gammaaa*t1*t126*t128*t258+4.2666666666666
     8         664d+1*t126*t158*t255*t256*t257+8.0d+0*gammaaa*t1*t127*t1
     9         28*t254)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t5*(t34*(-6.155715362980916d
     1         +1*t100*t112*t114*t43*t60*t98*t99+1.923661050931536d+0*t1
     2         00*t228*t38*t39*t60*t98*t99+1.538928840745229d+1*t100*t11
     3         4*t144*t39*t60*t98*t99-1.538928840745229d+1*t100*t112*t14
     4         4*t38*t60*t98*t99-3.077857681490458d+1*t100*t110*t112*t38
     5         *t60*t98*t99-6.538889093261956d-1*t100*t114*t123*t43*t98*
     6         t99-1.6347222733154887d-1*t100*t123*t144*t38*t98*t99-3.26
     7         94445466309774d-1*t100*t110*t123*t38*t98*t99+7.6946442037
     8         26144d+0*t100*t114*t213*t39*t43*t60*t99+1.923661050931536
     9         d+0*t100*t144*t213*t38*t39*t60*t99+3.847322101863072d+0*t
     :         100*t110*t213*t38*t39*t60*t99+2.690728393099896d-2*t149*t
     ;         88*t94*t95*t96+5.381456786199792d-2*t119*t88*t94*t95*t96-
     <         5.848223622634647d-1*t241*t54*t94*t95*t96-5.8482236226346
     =         47d-1*t149*t203*t54*t95*t96-1.1696447245269295d+0*t119*t2
     >         03*t54*t95*t96+1.1696447245269295d+0*t149*t195*t200*t54*t
     ?         96+2.339289449053859d+0*t119*t195*t200*t54*t96-8.83792666
     @         0346784d-2*t147*t88*t90*t91*t92-1.767585332069357d-1*t116
     1         *t88*t90*t91*t92+1.0d+0*t237*t36*t90*t91*t92+1.0d+0*t147*
     2         t193*t36*t91*t92+2.0d+0*t116*t193*t36*t91*t92-2.0d+0*t147
     3         *t181*t186*t36*t92-4.0d+0*t116*t181*t186*t36*t92-4.543796
     4         4274821163d-4*t241*t58*t88+2.747773264188437d-3*t237*t52*
     5         t88-5.980796863619711d-2*t38*t39*t433*t60*t63-4.784637490
     6         8957684d+0*t114*t232*t43*t60*t63-4.7846374908957684d-1*t1
     7         14*t264*t39*t60*t63-7.176956236343652d-1*t144*t235*t39*t6
     8         0*t63+1.4353912472687305d+0*t110*t235*t39*t60*t63+2.39231
     9         87454478842d-1*t114*t228*t39*t60*t63-1.1961593727239421d+
     :         0*t144*t232*t38*t60*t63-2.3923187454478842d+0*t110*t232*t
     ;         38*t60*t63+2.3923187454478842d-1*t112*t228*t38*t60*t63+1.
     <         9138549963583074d+0*t112*t114*t144*t60*t63-9.487269826154
     =         375d-2*t114*t248*t43*t63-3.049479586978192d-2*t123*t235*t
     >         43*t63-2.3718174565385935d-2*t144*t248*t38*t63-4.74363491
     ?         3077187d-2*t110*t248*t38*t63+2.541232989148493d-3*t123*t2
     @         28*t38*t63+2.0329863913187946d-2*t114*t123*t144*t63-1.538
     1         928840745229d+1*t100*t114*t205*t210*t39*t43*t60+2.4749022
     2         066811444d+2*t114*t205*t206*t207*t39*t43*t60-3.8473221018
     3         63072d+0*t100*t144*t205*t210*t38*t39*t60-7.69464420372614
     4         4d+0*t100*t110*t205*t210*t38*t39*t60+6.187255516702861d+1
     5         *t144*t205*t206*t207*t38*t39*t60+1.2374511033405722d+2*t1
     6         10*t205*t206*t207*t38*t39*t60+1.9751631321680768d-2*(t444
     7         +t443+t442+t441+t440+t439+t438+t437+t436+t435+t434+1.9236
     8         61050931536d+0*t433+t432+t431+t410)*t54*t58+6.05839523664
     9         2822d-4*t149*t191*t58+1.2116790473285642d-3*t119*t191*t58
     :         -1.73158960813529d+1*t149*t195*t196*t197*t54-3.4631792162
     ;         7058d+1*t119*t195*t196*t197*t54-6.21814d-2*t36*(t444+t443
     <         +t442+t441+t440+t439+t438+t437+t436+t435+t434+t432+t431+t
     =         410)*t52-3.663697685584583d-3*t147*t191*t52-7.32739537116
     >         9166d-3*t116*t191*t52+t449+t448+t447+t446+t445+t430+t429+
     ?         t428+t427+t426+t417+t415+t414+t395+t393+t392+t391+t390+t3
     @         89+t388+t387+t386+t385+t384+t383+t382+t381+t380+t378+t377
     1         +t376+t375+t374+t373+t372+t371+t370+t369+t367+t362+t361+t
     2         360+1.6081979498692536d+1*t147*t181*t182*t183*t36+3.21639
     3         5899738507d+1*t116*t181*t182*t183*t36+t359+t358+t357+t356
     4         +t355+t354)+7.694644203726144d+0*t100*t110*t38*t39*t60*t9
     5         8*t99-2.339289449053859d+0*t119*t54*t94*t95*t96+4.0d+0*t1
     6         16*t36*t90*t91*t92-1.8175185709928465d-3*t119*t58*t88+1.0
     7         99109305675375d-2*t116*t52*t88-4.7846374908957684d-1*t114
     8         *t144*t39*t60*t63+9.569274981791537d-1*t110*t112*t38*t60*
     9         t63+1.0164931956593973d-2*t110*t123*t38*t63+t425+t424+t42
     :         3+t351+t350+t349+t348+t347+t346+t345+t344+t343+t342+t341+
     ;         t340+t339+t338+t337+t336+t335+t312+t311+t309+t306+t293+t2
     <         92+t291+t273+t252+t250+t245+t242+t238+t216)+1.13777777777
     =         77777d+2*gammabb*t153*t158*t256*t328*t329*t65-5.214814814
     >         814814d+1*gammaaa*gammabb*t153*t255*t257*t258*t65+5.33333
     ?         3333333333d+0*gammaaa*t1*t127*t128*t274-9.777777777777776
     @         d+0*gammaaa*t1*t128*t152*t258+1.4222222222222222d+1*t152*
     1         t158*t255*t256*t257+2.8444444444444444d+1*gammaaa*gammabb
     2         *t126*t127*t153*t255*t257+2.6666666666666666d+0*gammabb*t
     3         1*t128*t153*t254)*wght+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t5*(t34*(6.155715362980916d+
     1         1*t100*t112*t114*t43*t60*t98*t99+1.923661050931536d+0*t10
     2         0*t299*t38*t39*t60*t98*t99-1.538928840745229d+1*t100*t110
     3         *t114*t39*t60*t98*t99-3.077857681490458d+1*t100*t112*t144
     4         *t38*t60*t98*t99-1.538928840745229d+1*t100*t110*t112*t38*
     5         t60*t98*t99+6.538889093261955d-1*t100*t114*t123*t43*t98*t
     6         99-3.2694445466309774d-1*t100*t123*t144*t38*t98*t99-1.634
     7         7222733154887d-1*t100*t110*t123*t38*t98*t99-7.69464420372
     8         6144d+0*t100*t114*t213*t39*t43*t60*t99+3.847322101863072d
     9         +0*t100*t144*t213*t38*t39*t60*t99+1.923661050931536d+0*t1
     :         00*t110*t213*t38*t39*t60*t99+5.381456786199792d-2*t149*t8
     ;         8*t94*t95*t96+2.690728393099896d-2*t119*t88*t94*t95*t96-5
     <         .848223622634647d-1*t307*t54*t94*t95*t96-1.16964472452692
     =         95d+0*t149*t203*t54*t95*t96-5.848223622634647d-1*t119*t20
     >         3*t54*t95*t96+2.339289449053859d+0*t149*t195*t200*t54*t96
     ?         +1.1696447245269295d+0*t119*t195*t200*t54*t96-1.767585332
     @         069357d-1*t147*t88*t90*t91*t92-8.837926660346784d-2*t116*
     1         t88*t90*t91*t92+1.0d+0*t304*t36*t90*t91*t92+2.0d+0*t147*t
     2         193*t36*t91*t92+1.0d+0*t116*t193*t36*t91*t92-4.0d+0*t147*
     3         t181*t186*t36*t92-2.0d+0*t116*t181*t186*t36*t92-4.5437964
     4         274821163d-4*t307*t58*t88+2.747773264188437d-3*t304*t52*t
     5         88-5.980796863619711d-2*t38*t39*t450*t60*t63+4.7846374908
     6         957684d+0*t114*t232*t43*t60*t63-2.3923187454478842d-1*t11
     7         4*t299*t39*t60*t63+4.7846374908957684d-1*t114*t264*t39*t6
     8         0*t63+1.4353912472687305d+0*t144*t235*t39*t60*t63-7.17695
     9         6236343652d-1*t110*t235*t39*t60*t63+2.3923187454478842d-1
     :         *t112*t299*t38*t60*t63-2.3923187454478842d+0*t144*t232*t3
     ;         8*t60*t63-1.1961593727239421d+0*t110*t232*t38*t60*t63-1.9
     <         138549963583074d+0*t110*t112*t114*t60*t63+9.4872698261543
     =         74d-2*t114*t248*t43*t63-3.0494795869781915d-2*t123*t235*t
     >         43*t63+2.541232989148493d-3*t123*t299*t38*t63-4.743634913
     ?         077187d-2*t144*t248*t38*t63-2.3718174565385935d-2*t110*t2
     @         48*t38*t63-2.0329863913187946d-2*t110*t114*t123*t63+1.538
     1         928840745229d+1*t100*t114*t205*t210*t39*t43*t60-2.4749022
     2         066811444d+2*t114*t205*t206*t207*t39*t43*t60-7.6946442037
     3         26144d+0*t100*t144*t205*t210*t38*t39*t60-3.84732210186307
     4         2d+0*t100*t110*t205*t210*t38*t39*t60+1.2374511033405722d+
     5         2*t144*t205*t206*t207*t38*t39*t60+6.187255516702861d+1*t1
     6         10*t205*t206*t207*t38*t39*t60+1.9751631321680768d-2*(t460
     7         +t459+t458+t457+t456+t455+t454+t453+t452+t451+1.923661050
     8         931536d+0*t450+t443+t431+t413+t410)*t54*t58+1.21167904732
     9         85642d-3*t149*t191*t58+6.058395236642822d-4*t119*t191*t58
     :         -3.46317921627058d+1*t149*t195*t196*t197*t54-1.7315896081
     ;         3529d+1*t119*t195*t196*t197*t54-6.21814d-2*t36*(t460+t459
     <         +t458+t457+t456+t455+t454+t453+t452+t451+t443+t431+t413+t
     =         410)*t52-7.327395371169166d-3*t147*t191*t52-3.66369768558
     >         4583d-3*t116*t191*t52+t448+t447+t446+t445+t430+t429+t428+
     ?         t427+t426+t419+t417+t415+t414+t395+t393+t392+t391+t390+t3
     @         89+t388+t387+t386+t385+t384+t383+t382+t381+t380+t378+t377
     1         +t376+t375+t374+t373+t372+t371+t370+t369+t367+t362+t361+t
     2         360+3.216395899738507d+1*t147*t181*t182*t183*t36+1.608197
     3         9498692536d+1*t116*t181*t182*t183*t36+t359+t358+t357+t356
     4         +t355+t354)+7.694644203726144d+0*t100*t144*t38*t39*t60*t9
     5         8*t99-2.339289449053859d+0*t149*t54*t94*t95*t96+4.0d+0*t1
     6         47*t36*t90*t91*t92-1.8175185709928465d-3*t149*t58*t88+1.0
     7         99109305675375d-2*t147*t52*t88+4.7846374908957684d-1*t110
     8         *t114*t39*t60*t63+9.569274981791537d-1*t112*t144*t38*t60*
     9         t63+1.0164931956593973d-2*t123*t144*t38*t63+t425+t424+t42
     :         3+t351+t350+t349+t348+t347+t346+t345+t344+t343+t342+t341+
     ;         t340+t339+t338+t337+t336+t335+t314+t313+t310+t308+t305+t2
     <         94+t273+t247+t246+t243+t239+t209+t199+t185)+1.13777777777
     =         77777d+2*gammaaa*t127*t275*t316*t328*t329*t65-5.214814814
     >         814814d+1*gammaaa*gammabb*t127*t255*t257*t317*t65-9.77777
     ?         7777777776d+0*gammabb*t1*t126*t128*t317+1.422222222222222
     @         2d+1*t126*t255*t257*t275*t316+2.6666666666666666d+0*gamma
     1         aa*t1*t127*t128*t315+5.333333333333333d+0*gammabb*t1*t128
     2         *t153*t274+2.8444444444444444d+1*gammaaa*gammabb*t127*t15
     3         2*t153*t255*t257)*wght+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t5*(t34*(1.8467146088942746d
     1         +2*t100*t112*t114*t43*t60*t98*t99+5.770983152794609d+0*t1
     2         00*t299*t38*t39*t60*t98*t99-4.616786522235687d+1*t100*t11
     3         4*t144*t39*t60*t98*t99-4.616786522235687d+1*t100*t112*t14
     4         4*t38*t60*t98*t99+1.9616667279785865d+0*t100*t114*t123*t4
     5         3*t98*t99-4.904166819946466d-1*t100*t123*t144*t38*t98*t99
     6         -2.3083932611178434d+1*t100*t114*t213*t39*t43*t60*t99+5.7
     7         70983152794609d+0*t100*t144*t213*t38*t39*t60*t99+8.072185
     8         179299687d-2*t149*t88*t94*t95*t96-1.7544670867903941d+0*t
     9         307*t54*t94*t95*t96-1.7544670867903941d+0*t149*t203*t54*t
     :         95*t96+3.5089341735807883d+0*t149*t195*t200*t54*t96-2.651
     ;         3779981040353d-1*t147*t88*t90*t91*t92+3.0d+0*t304*t36*t90
     <         *t91*t92+3.0d+0*t147*t193*t36*t91*t92-6.0d+0*t147*t181*t1
     =         86*t36*t92-1.363138928244635d-3*t307*t58*t88+8.2433197925
     >         65312d-3*t304*t52*t88-5.980796863619711d-2*t38*t39*t468*t
     ?         60*t63+1.4353912472687305d+1*t114*t232*t43*t60*t63+7.1769
     @         56236343652d-1*t114*t299*t39*t60*t63-2.1530868709030954d+
     1         0*t144*t235*t39*t60*t63+7.176956236343652d-1*t112*t299*t3
     2         8*t60*t63-3.588478118171826d+0*t144*t232*t38*t60*t63-5.74
     3         1564989074922d+0*t112*t114*t144*t60*t63+2.846180947846312
     4         4d-1*t114*t248*t43*t63+7.623698967445479d-3*t123*t299*t38
     5         *t63-7.11545236961578d-2*t144*t248*t38*t63-6.098959173956
     6         384d-2*t114*t123*t144*t63+4.616786522235687d+1*t100*t114*
     7         t205*t210*t39*t43*t60-7.424706620043432d+2*t114*t205*t206
     8         *t207*t39*t43*t60-1.1541966305589217d+1*t100*t144*t205*t2
     9         10*t38*t39*t60+1.856176655010858d+2*t144*t205*t206*t207*t
     :         38*t39*t60+1.9751631321680768d-2*(t475+t474+t473+t472+t47
     ;         1+t470+t469+1.923661050931536d+0*t468+t444+t412+t410)*t54
     <         *t58+1.8175185709928465d-3*t149*t191*t58-5.19476882440587
     =         d+1*t149*t195*t196*t197*t54-6.21814d-2*t36*(t475+t474+t47
     >         3+t472+t471+t470+t469+t444+t412+t410)*t52-1.0991093056753
     ?         75d-2*t147*t191*t52+t449+t418+t417+t416+t415+t414+t395+t3
     @         94+t393+t392+t391+t390+t389+t388+t387+t386+t385+t384+t383
     1         +t382+t381+t380+t378+t377+t376+t375+t374+t373+t372+t371+t
     2         370+t369+t367+t362+t361+t360+4.824593849607761d+1*t147*t1
     3         81*t182*t183*t36+t359+t358+t357+t356+t355+t354)-4.6167865
     4         22235687d+1*t100*t114*t39*t43*t60*t98*t99+1.1541966305589
     5         217d+1*t100*t144*t38*t39*t60*t98*t99-3.5089341735807883d+
     6         0*t149*t54*t94*t95*t96+6.0d+0*t147*t36*t90*t91*t92-2.7262
     7         7785648927d-3*t149*t58*t88+1.6486639585130625d-2*t147*t52
     8         *t88-5.741564989074922d+0*t112*t114*t43*t60*t63-1.7942390
     9         59085913d-1*t299*t38*t39*t60*t63+1.4353912472687305d+0*t1
     :         14*t144*t39*t60*t63+1.4353912472687305d+0*t112*t144*t38*t
     ;         60*t63-6.098959173956384d-2*t114*t123*t43*t63+1.524739793
     <         489096d-2*t123*t144*t38*t63+5.92548939650423d-2*t307*t54*
     =         t58-1.865442d-1*t304*t36*t52-rhob*t467+t352+t351+t350+t34
     >         9+t348+t347+t346+t345+t344+t343+t342+t341+t340+t339+t338+
     ?         t337+t336+t335-3.3306690738754696d-16*t131*t137*t284*t32+
     @         6.661338147750939d-16*t131*t278*t280*t32-5.35637517629945
     1         6d-15*t277*t278*t279*t32+1.2202564577405706d-18*t282*t31-
     2         3.0d+0*t138*t140*t28*t289+6.0d+0*t138*t28*t286*t288-9.649
     3         187699215522d+1*t28*t285*t286*t287+5.284159572535705d-3*t
     4         27*t282+2.549392377400174d-1*t134*t138*t139*t140+2.943620
     5         900479655d-17*t131*t134*t136*t137)+t154*t276*(1.560206966
     6         1412085d+1*gammabb*t33*t66*t74+5.850776123029532d-1*t141*
     7         t275*t66)+t3*t72*(3.6567350768934576d-1*t141*t74+3.047279
     8         230744548d-2*gammabb*t33/rhob**2+8.22765392301028d-2*gamm
     9         abb*t290)+1.0970205230680373d-1*t20*t467*t72*t74-2.194041
     :         0461360743d-1*t132*t290*t72*t74-8.776164184544297d+0*gamm
     ;         abb*t141*t154*t320*t66*t74+1.7552328369088593d+0*gammabb*
     <         t154*t155*t290*t66*t74-6.084807167950713d+1*t259*t275*t31
     =         8*t33*t477*t74+4.9926622916518665d+1*t33*t420*t461*t476*t
     >         74/rhob**1.1666666666666665d+1+1.4041862695270876d+1*t141
     ?         *t259*t275*t318*t319*t74+3.3520071538190027d-1*gammabb*t3
     @         17*t33*t72-2.6666666666666666d+0*t153*t321*t72-1.27985727
     1         691271d-1*gammabb*t141*t153*t72-3.071657464590504d+0*t154
     2         *t275*t316*t33*t66+5.333333333333333d+0*gammabb*t154*t276
     3         *t321*t66+1.1377777777777777d+2*t328*t329*t461*t65/rhob**
     4         11-1.5644444444444444d+2*t255*t257*t275*t65/rhob**8.33333
     5         3333333334d+0+4.5629629629629626d+1*gammabb*t1*t128*t65/r
     6         hob**5.666666666666667d+0+3.5104656738177187d+0*t259*t318
     7         *t33*t461*t462-2.933333333333333d+1*gammabb*t1*t128*t152*
     8         t317+4.2666666666666664d+1*t152*t255*t257*t275*t316+8.0d+
     9         0*gammabb*t1*t128*t153*t315)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (t129*t262*(-2.925388061514766d-1*g
     1         ammaaa*t66*t85-2.925388061514766d+0*t19*t66*t70-2*t263*t6
     2         6)+1.462694030757383d+0*t129*t130*t66*t70*t85-3.510465673
     3         8177187d+0*gammaaa*t259*t260*t322*t70*t85+t2*t68*(9.14183
     4         7692233644d-2*t85-3.047279230744548d-2*t19*t69)-2.7425513
     5         07670093d-2*t173*t68*t76-2.1940410461360746d-1*t129*t156*
     6         t173*t66*t70-1.8722483593694503d+1*t158*t19*t420*t421*t70
     7         /rhoa**1.0666666666666666d+1+1.813740598139155d+1*gammaaa
     8         *t19*t259*t260*t261*t70-9.141837692233644d-2*t127*t19*t68
     9         +1.4992613815263175d+0*gammaaa*t129*t159*t19*t66-4.266666
     :         6666666664d+1*t158*t327*t328*t329*t65-9.777777777777776d+
     ;         0*t1*t128*t258*t65+4.8d+1*gammaaa*t255*t256*t257*t65-2.04
     <         7771643060336d+0*t158*t19*t259*t260*t422-1.06666666666666
     =         66d+1*gammaaa*t126*t159*t255*t257-1.0d+0*t1*t128*t2*t254+
     >         5.333333333333333d+0*t1*t126*t127*t128)*wght+Cmat3(iq,D3_
     ?         RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = (-4.2666666666666664d+1*t158*t256*t
     1         3*t328*t329*t65+1.9555555555555554d+1*gammaaa*t255*t257*t
     2         258*t3*t65-1.0666666666666666d+1*gammaaa*t126*t127*t255*t
     3         257*t3-1.0d+0*t1*t128*t254*t3)*wght+Cmat3(iq,D3_RA_RA_GBB
     4         )
            Cmat3(iq,D3_RA_RB_GAA) = (-4.2666666666666664d+1*gammaaa*gam
     1         mabb*t153*t159*t328*t329*t65+1.4222222222222222d+1*gammab
     2         b*t127*t153*t255*t257*t65-1.0d+0*t1*t128*t2*t274-5.333333
     3         333333333d+0*gammabb*t126*t153*t2*t255*t257-5.33333333333
     4         3333d+0*gammaaa*t152*t159*t255*t257+2.6666666666666666d+0
     5         *t1*t127*t128*t152)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = (-4.2666666666666664d+1*gammaaa*gam
     1         mabb*t127*t276*t328*t329*t65+1.4222222222222222d+1*gammaa
     2         a*t127*t153*t255*t257*t65-1.0d+0*t1*t128*t274*t3-5.333333
     3         333333333d+0*gammaaa*t127*t152*t255*t257*t3-5.33333333333
     4         3333d+0*gammabb*t126*t255*t257*t276+2.6666666666666666d+0
     5         *t1*t126*t128*t153)*wght+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = (-4.2666666666666664d+1*t2*t275*t31
     1         6*t328*t329*t65+1.9555555555555554d+1*gammabb*t2*t255*t25
     2         7*t317*t65-1.0d+0*t1*t128*t2*t315-1.0666666666666666d+1*g
     3         ammabb*t152*t153*t2*t255*t257)*wght+Cmat3(iq,D3_RB_RB_GAA
     4         )
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = (t154*t320*(-2.925388061514766d+0*t
     1         33*t66*t74-2*t321*t66-2.925388061514766d-1*gammabb*t141*t
     2         66)-2.1940410461360746d-1*t154*t157*t290*t66*t74+1.462694
     3         030757383d+0*t141*t154*t155*t66*t74-1.8722483593694503d+1
     4         *t275*t33*t420*t476*t74/rhob**1.0666666666666666d+1+1.813
     5         740598139155d+1*gammabb*t259*t318*t319*t33*t74-3.51046567
     6         38177187d+0*gammabb*t141*t259*t318*t323*t74+t3*t72*(9.141
     7         837692233644d-2*t141-3.047279230744548d-2*t33*t73)-9.1418
     8         37692233644d-2*t153*t33*t72-2.742551307670093d-2*t132*t29
     9         0*t72+1.4992613815263175d+0*gammabb*t154*t276*t33*t66-4.2
     :         666666666666664d+1*t275*t328*t329*t462*t65-9.777777777777
     ;         776d+0*t1*t128*t317*t65+4.8d+1*gammabb*t255*t257*t316*t65
     <         -2.047771643060336d+0*t259*t275*t318*t33*t477-1.0d+0*t1*t
     =         128*t3*t315-1.0666666666666666d+1*gammabb*t152*t255*t257*
     >         t276+5.333333333333333d+0*t1*t128*t152*t153)*wght+Cmat3(i
     ?         q,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = (6.582123138408223d-1*t259*t260*t3
     1         24*t70*t85+1.0970205230680373d-1*t129*t130*t66*t85+7.0209
     2         31347635437d+0*gammaaa*t19*t420*t421*t70/rhoa**9.66666666
     3         6666666d+0-3.9492738830449337d+0*t19*t259*t260*t322*t70-4
     4         .7537555999614944d-1*t129*t19*t262*t66+1.6d+1*gammaaa*t32
     5         8*t329*t422*t65-1.0666666666666666d+1*t159*t255*t257*t65+
     6         2.0d+0*t126*t255*t257*t262+1.0421694969146353d+0*gammaaa*
     7         t19*t259*t260*t261)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = (1.6d+1*gammaaa*t159*t3*t328*t329*
     1         t65-5.333333333333333d+0*t127*t255*t257*t3*t65+2.0d+0*t12
     2         6*t2*t255*t257*t3)*wght+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = (1.6d+1*gammaaa*t127*t320*t328*t32
     1         9*t65+2.0d+0*t126*t255*t257*t320)*wght+Cmat3(iq,D3_RA_GBB
     2         _GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = (1.6d+1*gammabb*t153*t262*t328*t32
     1         9*t65+2.0d+0*t152*t255*t257*t262)*wght+Cmat3(iq,D3_RB_GAA
     2         _GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = (1.6d+1*gammabb*t2*t276*t328*t329*
     1         t65-5.333333333333333d+0*t153*t2*t255*t257*t65+2.0d+0*t15
     2         2*t2*t255*t257*t3)*wght+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (7.020931347635437d+0*gammabb*t33*
     1         t420*t476*t74/rhob**9.666666666666666d+0-3.94927388304493
     2         37d+0*t259*t318*t323*t33*t74+6.582123138408223d-1*t141*t2
     3         59*t318*t325*t74-4.7537555999614944d-1*t154*t320*t33*t66+
     4         1.0970205230680373d-1*t141*t154*t155*t66+1.6d+1*gammabb*t
     5         328*t329*t477*t65-1.0666666666666666d+1*t255*t257*t276*t6
     6         5+1.0421694969146353d+0*gammabb*t259*t318*t319*t33+2.0d+0
     7         *t152*t255*t257*t320)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (-2.6328492553632893d+0*t19*t420*
     1         t421*t70/rhoa**8.666666666666666d+0-6.0d+0*t261*t328*t329
     2         *t65-4.9365923538061673d-1*t19*t259*t260*t322)*wght+Cmat3
     3         (iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)-6.0d+0*t
     1         262*t3*t328*t329*t65*wght
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)-6.0d+0*t
     1         2*t320*t328*t329*t65*wght
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = (-2.6328492553632893d+0*t33*t420*
     1         t476*t74/rhob**8.666666666666666d+0-6.0d+0*t319*t328*t329
     2         *t65-4.9365923538061673d-1*t259*t318*t323*t33)*wght+Cmat3
     3         (iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RA_RA_TA) = (-2.925388061514766d-1*t68*t76*t85+2
     1         .3403104492118126d+0*gammaaa*t129*t130*t66*t85+2.19404104
     2         61360746d-1*t173*t6*t68+2.4378233845956385d-1*t19*t2*t68-
     3         5.850776123029532d+0*gammaaa*t129*t19*t262*t66+9.36124179
     4         684725d+0*t158*t19*t259*t260*t261)*wght+Mmat3(iq,D3_RA_RA
     5         _TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = (2.4378233845956385d-1*t3*t33*t72+2.
     1         1940410461360746d-1*t20*t290*t72-2.925388061514766d-1*t13
     2         2*t141*t72-5.850776123029532d+0*gammabb*t154*t320*t33*t66
     3         +2.3403104492118126d+0*gammabb*t141*t154*t155*t66+9.36124
     4         179684725d+0*t259*t275*t318*t319*t33)*wght+Mmat3(iq,D3_RB
     5         _RB_TB)
            Mmat3(iq,D3_RA_GAA_TA) = (-4.388082092272149d-1*t129*t156*t6
     1         6*t85+1.462694030757383d+0*t129*t130*t19*t66-3.5104656738
     2         177187d+0*gammaaa*t19*t259*t260*t322)*wght+Mmat3(iq,D3_RA
     3         _GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
            Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
            Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
            Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = (1.462694030757383d+0*t154*t155*t33
     1         *t66-4.388082092272149d-1*t141*t154*t157*t66-3.5104656738
     2         177187d+0*gammabb*t259*t318*t323*t33)*wght+Mmat3(iq,D3_RB
     3         _GBB_TB)
            Mmat3(iq,D3_RA_TA_TA) = 1.3164246276816446d+0*t19*t259*t260*
     1         t324*wght+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAA_GBB_TB) = 1.3164246276816446d+0*t259*t318*t3
     1         25*t33*wght+Mmat3(iq,D3_GAA_GBB_TB)
            Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
            Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
            Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
            Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
            Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhoa**2.6666666666666666d+0
            t3 = gammaaa*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhoa**6.666666666666666d-1
            t6 = rhoa**5.0d-1
            t7 = 1/t6
            t8 = 1/rhoa**3.333333333333333d-1
            t9 = 1/rhoa**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 1/rhoa
            t20 = 2.0d+0*taua-2.5d-1*gammaaa*t19
            t21 = 1/t3**3
            t22 = 1/rhoa**4.333333333333333d+0
            t23 = 1/rhoa**1.6666666666666669d+0
            t24 = 1/t15
            t25 = 1/t6**3
            t26 = 1/rhoa**1.3333333333333333d+0
            t27 = 1/rhoa**1.1666666666666667d+0
            t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4.0
     1         02143174996817d-1*t25-1.264669550498372d-1*t23
            t29 = 1/t14**2
            t30 = 1/t11
            t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26-8
     1         .223668877838045d-1*t25-1.6039141941921276d-1*t23
            t32 = 1/t10**2
            t33 = 1.0d+0*t13*t30*t31*t32+1.1102230246251565d-16*t17*t24*
     1         t28*t29+3.0506411443514264d-19*t16*t26+1.3210398931339265
     2         d-3*t12*t26
            t34 = 1/rhoa**3.3333333333333337d+0
            t35 = gammaaa**2
            t36 = 1/rhoa**6.333333333333333d+0
            t37 = 1/rhoa**3.6666666666666664d+0
            t38 = t1**2
            t39 = 1/t3**4
            t40 = 1/rhoa**8
            t41 = 1/rhoa**5.333333333333333d+0
            t42 = 1/t15**2
            t43 = t28**2
            t44 = 1/t14**4
            t45 = 1/t14**3
            t46 = 1/t6**5
            t47 = 1/rhoa**2.3333333333333334d+0
            t48 = 1/rhoa**2.1666666666666665d+0
            t49 = 1.1632736958443765d+0*t48+9.89141964955861d-1*t47+6.00
     1         3214762495226d-1*t46+2.1077825841639536d-1*t2
            t50 = 1/t11**2
            t51 = t31**2
            t52 = 1/t10**4
            t53 = 1/t10**3
            t54 = 2.1622951122684114d+0*t48+1.7087761055320938d+0*t47+1.
     1         2335503316757068d+0*t46+2.673190323653546d-1*t2
            t55 = 1.0d+0*t13*t30*t32*t54-2.0d+0*t13*t30*t51*t53+3.216395
     1         899738507d+1*t13*t50*t51*t52+1.1102230246251565d-16*t17*t
     2         24*t29*t49-4.0675215258019015d-19*t16*t47-1.7613865241785
     3         684d-3*t12*t47-2.220446049250313d-16*t17*t24*t43*t45+1.78
     4         54583920998188d-15*t17*t42*t43*t44-8.497974591333913d-2*t
     5         26*t30*t31*t32-9.812069668265515d-18*t24*t26*t28*t29
            t56 = 5.485102615340186d-2*gammaaa*t33*wght+1.21891169229781
     1         92d-1*t18*t20*wght
            t57 = 1/rhoa**7
            t58 = 1/rhoa**6
            t59 = gammaaa**3
            t60 = t1**3
            t61 = 1/t3**5
            t62 = 1/rhoa**9
            t63 = t28**3
            t64 = 1/t6**7
            t65 = 1/rhoa**3.1666666666666665d+0
            t66 = t31**3
            fnc(iq) = 1.0970205230680373d-1*t18*t20*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0970205230680373d-1*t20*t33*t4*t5*wght-7.
     1         313470153786915d-2*t18*t20*t23*t4*wght+2.742551307670093d
     2         -2*gammaaa*t18*t2*t4*wght+5.850776123029532d-1*gammaaa*t1
     3         *t18*t20*t21*t22*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = -2.742551307670093d-2*t18*t23*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t20*t21*t34*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0970205230680373d-1*t20*t4*t5*t55*wgh
     1         t-2.925388061514766d+0*gammaaa*t1*t18*t20*t21*t41*wght+4.
     2         680620898423625d+0*t18*t20*t35*t38*t39*t40*wght-9.1418376
     3         92233644d-2*gammaaa*t18*t37*t4*wght-1.462694030757383d-1*
     4         t20*t23*t33*t4*wght+2.925388061514766d-1*t1*t18*t21*t35*t
     5         36*wght+1.1701552246059063d+0*gammaaa*t1*t20*t21*t22*t33*
     6         wght+t2*t4*t56+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = -1.7552328369088593d+0*gammaaa*t18*t20
     1         *t38*t39*t57*wght-2.0112042922914017d-1*gammaaa*t1*t18*t2
     2         1*t41*wght-2.742551307670093d-2*t23*t33*t4*wght+4.5709188
     3         46116822d-2*t18*t2*t4*wght-2.1940410461360746d-1*t1*t20*t
     4         21*t33*t34*wght+7.313470153786915d-1*t1*t18*t20*t21*t22*w
     5         ght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 6.582123138408223d-1*t18*t20*t38*t39*
     1         t58*wght+1.0970205230680373d-1*t1*t18*t21*t22*wght+Cmat2(
     2         iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = 2.1940410461360746d-1*t33*t4*t5*wght-1.
     1         462694030757383d-1*t18*t23*t4*wght+1.1701552246059063d+0*
     2         gammaaa*t1*t18*t21*t22*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)-4.388082092272149d
     1         -1*t1*t18*t21*t34*wght
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = t2*t4*(8.22765392301028d-2*gammaaa*t
     1         55*wght+3.6567350768934576d-1*t20*t33*wght+3.047279230744
     2         548d-2*gammaaa*t18*wght/rhoa**2)+t21*t36*(5.8507761230295
     3         32d-1*t1*t33*t35*wght+1.5602069661412085d+1*gammaaa*t1*t1
     4         8*t20*wght)+1.0970205230680373d-1*t20*t4*t5*(6.0d+0*t13*t
     5         30*t52*t66-1.9298375398431045d+2*t13*t50*t66/t10**5+2.069
     6         0405167709364d+3*t13*t66/(t10**6*t11**3)+1.11022302462515
     7         65d-16*t17*t24*t29*(-2.520426340996149d+0*t65-1.500803690
     8         6238065d+0*t64-5.620753557770543d-1*t37-2.307997918230342
     9         8d+0*t34)+1.0d+0*t13*t30*t32*(-4.684972743248224d+0*t65-3
     :         .083875829189267d+0*t64-7.128507529742789d-1*t37-3.987144
     ;         2462415524d+0*t34)+6.661338147750939d-16*t17*t24*t44*t63-
     <         1.0712750352598913d-14*t17*t42*t63/t14**5+5.7427410515035
     =         65d-14*t17*t63/(t14**6*t15**3)-6.0d+0*t13*t30*t31*t53*t54
     >         +9.649187699215522d+1*t13*t31*t50*t52*t54-1.2746961887000
     ?         87d-1*t26*t30*t32*t54+2.549392377400174d-1*t26*t30*t51*t5
     @         3-4.0999275947472624d+0*t26*t50*t51*t52-6.661338147750939
     1         d-16*t17*t24*t28*t45*t49+5.356375176299456d-15*t17*t28*t4
     2         2*t44*t49-1.4718104502398274d-17*t24*t26*t29*t49+1.699594
     3         9182667827d-1*t30*t31*t32*t47+1.962413933653103d-17*t24*t
     4         28*t29*t47+2.943620900479655d-17*t24*t26*t43*t45-2.366962
     5         5486718335d-16*t26*t42*t43*t44+9.490883560204437d-19*t16*
     6         t34+4.1099018897499934d-3*t12*t34)*wght-6.084807167950713
     7         d+1*t18*t20*t35*t38*t39*t62*wght+4.9926622916518665d+1*t1
     8         8*t20*t59*t60*t61*wght/rhoa**1.1666666666666665d+1+3.5104
     9         656738177187d+0*t18*t38*t39*t59*wght/rhoa**10-2.194041046
     :         1360743d-1*t20*t23*t4*t55*wght+1.7552328369088593d+0*gamm
     ;         aaa*t1*t20*t21*t22*t55*wght-8.776164184544297d+0*gammaaa*
     <         t1*t20*t21*t33*t41*wght+1.4041862695270876d+1*t20*t33*t35
     =         *t38*t39*t40*wght-1.27985727691271d-1*gammaaa*t33*t37*t4*
     >         wght+3.3520071538190027d-1*gammaaa*t18*t4*wght/rhoa**4.66
     ?         6666666666667d+0-3.071657464590504d+0*t1*t18*t21*t35*wght
     @         /rhoa**7.333333333333333d+0-2.6666666666666666d+0*t37*t4*
     1         t56+5.333333333333333d+0*gammaaa*t1*t21*t36*t56+Amat3(iq,
     2         D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = t21*t41*(-2.925388061514766d-1*gamm
     1         aaa*t1*t33*wght-2.925388061514766d+0*t1*t18*t20*wght-2*t1
     2         *t56)+t2*t4*(9.141837692233644d-2*t33*wght-3.047279230744
     3         548d-2*t18*t19*wght)-2.047771643060336d+0*t18*t35*t38*t39
     4         *t62*wght-1.8722483593694503d+1*t18*t20*t35*t60*t61*wght/
     5         rhoa**1.0666666666666666d+1-3.5104656738177187d+0*gammaaa
     6         *t20*t33*t38*t39*t57*wght-2.742551307670093d-2*t23*t4*t55
     7         *wght-2.1940410461360746d-1*t1*t20*t21*t34*t55*wght+1.813
     8         740598139155d+1*gammaaa*t18*t20*t38*t39*t40*wght-9.141837
     9         692233644d-2*t18*t37*t4*wght+1.4992613815263175d+0*gammaa
     :         a*t1*t18*t21*t36*wght+1.462694030757383d+0*t1*t20*t21*t22
     ;         *t33*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 7.020931347635437d+0*gammaaa*t18*t
     1         20*t60*t61*wght/rhoa**9.666666666666666d+0+6.582123138408
     2         223d-1*t20*t33*t38*t39*t58*wght-3.9492738830449337d+0*t18
     3         *t20*t38*t39*t57*wght-4.7537555999614944d-1*t1*t18*t21*t4
     4         1*wght+1.0421694969146353d+0*gammaaa*t18*t38*t39*t40*wght
     5         +1.0970205230680373d-1*t1*t21*t22*t33*wght+Cmat3(iq,D3_RA
     6         _GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = -2.6328492553632893d+0*t18*t20*t6
     1         0*t61*wght/rhoa**8.666666666666666d+0-4.9365923538061673d
     2         -1*t18*t38*t39*t57*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Mmat3(iq,D3_RA_RA_TA) = 2.1940410461360746d-1*t4*t5*t55*wght
     1         -5.850776123029532d+0*gammaaa*t1*t18*t21*t41*wght+9.36124
     2         179684725d+0*t18*t35*t38*t39*t40*wght-2.925388061514766d-
     3         1*t23*t33*t4*wght+2.4378233845956385d-1*t18*t2*t4*wght+2.
     4         3403104492118126d+0*gammaaa*t1*t21*t22*t33*wght+Mmat3(iq,
     5         D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_GAA_TA) = -3.5104656738177187d+0*gammaaa*t18*
     1         t38*t39*t57*wght-4.388082092272149d-1*t1*t21*t33*t34*wght
     2         +1.462694030757383d+0*t1*t18*t21*t22*wght+Mmat3(iq,D3_RA_
     3         GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.3164246276816446d+0*t18*t38*t39*
     1         t58*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = 1/rhob**2.6666666666666666d+0
            t3 = gammabb*t1*t2+1.0d+0
            t4 = 1/t3**2
            t5 = 1/rhob**6.666666666666666d-1
            t6 = rhob**5.0d-1
            t7 = 1/t6
            t8 = 1/rhob**3.333333333333333d-1
            t9 = 1/rhob**1.6666666666666666d-1
            t10 = 1.1120374863094686d+1*t9+3.8447462374472113d+0*t8+1.64
     1         4733775567609d+0*t7+2.4058712912881916d-1*t5
            t11 = 3.216395899738507d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.274696188700087d-1*t8+1.0d+0
            t14 = 5.982550435771079d+0*t9+2.2255694211506874d+0*t8+8.004
     1         286349993635d-1*t7+1.8970043257475583d-1*t5
            t15 = 1.6081979498692536d+1/t14+1.0d+0
            t16 = log(t15)
            t17 = 1.3256889990520176d-1*t8+1.0d+0
            t18 = -6.903522198342671d-18*t16*t17-3.1090699999999993d-2*t
     1         12*t13
            t19 = 1/rhob
            t20 = 2.0d+0*taub-2.5d-1*gammabb*t19
            t21 = 1/t3**3
            t22 = 1/rhob**4.333333333333333d+0
            t23 = 1/rhob**1.6666666666666669d+0
            t24 = 1/t15
            t25 = 1/t6**3
            t26 = 1/rhob**1.3333333333333333d+0
            t27 = 1/rhob**1.1666666666666667d+0
            t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4.0
     1         02143174996817d-1*t25-1.264669550498372d-1*t23
            t29 = 1/t14**2
            t30 = 1/t11
            t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26-8
     1         .223668877838045d-1*t25-1.6039141941921276d-1*t23
            t32 = 1/t10**2
            t33 = 1.0d+0*t13*t30*t31*t32+1.1102230246251565d-16*t17*t24*
     1         t28*t29+3.0506411443514264d-19*t16*t26+1.3210398931339265
     2         d-3*t12*t26
            t34 = 1/rhob**3.3333333333333337d+0
            t35 = gammabb**2
            t36 = 1/rhob**6.333333333333333d+0
            t37 = 1/rhob**3.6666666666666664d+0
            t38 = t1**2
            t39 = 1/t3**4
            t40 = 1/rhob**8
            t41 = 1/rhob**5.333333333333333d+0
            t42 = 1/t15**2
            t43 = t28**2
            t44 = 1/t14**4
            t45 = 1/t14**3
            t46 = 1/t6**5
            t47 = 1/rhob**2.3333333333333334d+0
            t48 = 1/rhob**2.1666666666666665d+0
            t49 = 1.1632736958443765d+0*t48+9.89141964955861d-1*t47+6.00
     1         3214762495226d-1*t46+2.1077825841639536d-1*t2
            t50 = 1/t11**2
            t51 = t31**2
            t52 = 1/t10**4
            t53 = 1/t10**3
            t54 = 2.1622951122684114d+0*t48+1.7087761055320938d+0*t47+1.
     1         2335503316757068d+0*t46+2.673190323653546d-1*t2
            t55 = 1.0d+0*t13*t30*t32*t54-2.0d+0*t13*t30*t51*t53+3.216395
     1         899738507d+1*t13*t50*t51*t52+1.1102230246251565d-16*t17*t
     2         24*t29*t49-4.0675215258019015d-19*t16*t47-1.7613865241785
     3         684d-3*t12*t47-2.220446049250313d-16*t17*t24*t43*t45+1.78
     4         54583920998188d-15*t17*t42*t43*t44-8.497974591333913d-2*t
     5         26*t30*t31*t32-9.812069668265515d-18*t24*t26*t28*t29
            t56 = 5.485102615340186d-2*gammabb*t33*wght+1.21891169229781
     1         92d-1*t18*t20*wght
            t57 = 1/rhob**7
            t58 = 1/rhob**6
            t59 = gammabb**3
            t60 = t1**3
            t61 = 1/t3**5
            t62 = 1/rhob**9
            t63 = t28**3
            t64 = 1/t6**7
            t65 = 1/rhob**3.1666666666666665d+0
            t66 = t31**3
            fnc(iq) = 1.0970205230680373d-1*t18*t20*t4*t5*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0970205230680373d-1*t20*t33*t4*t5*wght-7.
     1         313470153786915d-2*t18*t20*t23*t4*wght+2.742551307670093d
     2         -2*gammabb*t18*t2*t4*wght+5.850776123029532d-1*gammabb*t1
     3         *t18*t20*t21*t22*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = -2.742551307670093d-2*t18*t23*t4*wght-2.19
     1         40410461360746d-1*t1*t18*t20*t21*t34*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 2.1940410461360746d-1*t18*t4*t5*wght+Mmat(i
     1         q,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0970205230680373d-1*t20*t4*t5*t55*wgh
     1         t-2.925388061514766d+0*gammabb*t1*t18*t20*t21*t41*wght+4.
     2         680620898423625d+0*t18*t20*t35*t38*t39*t40*wght-9.1418376
     3         92233644d-2*gammabb*t18*t37*t4*wght-1.462694030757383d-1*
     4         t20*t23*t33*t4*wght+2.925388061514766d-1*t1*t18*t21*t35*t
     5         36*wght+1.1701552246059063d+0*gammabb*t1*t20*t21*t22*t33*
     6         wght+t2*t4*t56+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = -1.7552328369088593d+0*gammabb*t18*t20
     1         *t38*t39*t57*wght-2.0112042922914017d-1*gammabb*t1*t18*t2
     2         1*t41*wght-2.742551307670093d-2*t23*t33*t4*wght+4.5709188
     3         46116822d-2*t18*t2*t4*wght-2.1940410461360746d-1*t1*t20*t
     4         21*t33*t34*wght+7.313470153786915d-1*t1*t18*t20*t21*t22*w
     5         ght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 6.582123138408223d-1*t18*t20*t38*t39*
     1         t58*wght+1.0970205230680373d-1*t1*t18*t21*t22*wght+Cmat2(
     2         iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 2.1940410461360746d-1*t33*t4*t5*wght-1.
     1         462694030757383d-1*t18*t23*t4*wght+1.1701552246059063d+0*
     2         gammabb*t1*t18*t21*t22*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)-4.388082092272149d
     1         -1*t1*t18*t21*t34*wght
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RB_RB_RB) = t2*t4*(8.22765392301028d-2*gammabb*t
     1         55*wght+3.6567350768934576d-1*t20*t33*wght+3.047279230744
     2         548d-2*gammabb*t18*wght/rhob**2)+t21*t36*(5.8507761230295
     3         32d-1*t1*t33*t35*wght+1.5602069661412085d+1*gammabb*t1*t1
     4         8*t20*wght)+1.0970205230680373d-1*t20*t4*t5*(6.0d+0*t13*t
     5         30*t52*t66-1.9298375398431045d+2*t13*t50*t66/t10**5+2.069
     6         0405167709364d+3*t13*t66/(t10**6*t11**3)+1.11022302462515
     7         65d-16*t17*t24*t29*(-2.520426340996149d+0*t65-1.500803690
     8         6238065d+0*t64-5.620753557770543d-1*t37-2.307997918230342
     9         8d+0*t34)+1.0d+0*t13*t30*t32*(-4.684972743248224d+0*t65-3
     :         .083875829189267d+0*t64-7.128507529742789d-1*t37-3.987144
     ;         2462415524d+0*t34)+6.661338147750939d-16*t17*t24*t44*t63-
     <         1.0712750352598913d-14*t17*t42*t63/t14**5+5.7427410515035
     =         65d-14*t17*t63/(t14**6*t15**3)-6.0d+0*t13*t30*t31*t53*t54
     >         +9.649187699215522d+1*t13*t31*t50*t52*t54-1.2746961887000
     ?         87d-1*t26*t30*t32*t54+2.549392377400174d-1*t26*t30*t51*t5
     @         3-4.0999275947472624d+0*t26*t50*t51*t52-6.661338147750939
     1         d-16*t17*t24*t28*t45*t49+5.356375176299456d-15*t17*t28*t4
     2         2*t44*t49-1.4718104502398274d-17*t24*t26*t29*t49+1.699594
     3         9182667827d-1*t30*t31*t32*t47+1.962413933653103d-17*t24*t
     4         28*t29*t47+2.943620900479655d-17*t24*t26*t43*t45-2.366962
     5         5486718335d-16*t26*t42*t43*t44+9.490883560204437d-19*t16*
     6         t34+4.1099018897499934d-3*t12*t34)*wght-6.084807167950713
     7         d+1*t18*t20*t35*t38*t39*t62*wght+4.9926622916518665d+1*t1
     8         8*t20*t59*t60*t61*wght/rhob**1.1666666666666665d+1+3.5104
     9         656738177187d+0*t18*t38*t39*t59*wght/rhob**10-2.194041046
     :         1360743d-1*t20*t23*t4*t55*wght+1.7552328369088593d+0*gamm
     ;         abb*t1*t20*t21*t22*t55*wght-8.776164184544297d+0*gammabb*
     <         t1*t20*t21*t33*t41*wght+1.4041862695270876d+1*t20*t33*t35
     =         *t38*t39*t40*wght-1.27985727691271d-1*gammabb*t33*t37*t4*
     >         wght+3.3520071538190027d-1*gammabb*t18*t4*wght/rhob**4.66
     ?         6666666666667d+0-3.071657464590504d+0*t1*t18*t21*t35*wght
     @         /rhob**7.333333333333333d+0-2.6666666666666666d+0*t37*t4*
     1         t56+5.333333333333333d+0*gammabb*t1*t21*t36*t56+Amat3(iq,
     2         D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = t21*t41*(-2.925388061514766d-1*gamm
     1         abb*t1*t33*wght-2.925388061514766d+0*t1*t18*t20*wght-2*t1
     2         *t56)+t2*t4*(9.141837692233644d-2*t33*wght-3.047279230744
     3         548d-2*t18*t19*wght)-2.047771643060336d+0*t18*t35*t38*t39
     4         *t62*wght-1.8722483593694503d+1*t18*t20*t35*t60*t61*wght/
     5         rhob**1.0666666666666666d+1-3.5104656738177187d+0*gammabb
     6         *t20*t33*t38*t39*t57*wght-2.742551307670093d-2*t23*t4*t55
     7         *wght-2.1940410461360746d-1*t1*t20*t21*t34*t55*wght+1.813
     8         740598139155d+1*gammabb*t18*t20*t38*t39*t40*wght-9.141837
     9         692233644d-2*t18*t37*t4*wght+1.4992613815263175d+0*gammab
     :         b*t1*t18*t21*t36*wght+1.462694030757383d+0*t1*t20*t21*t22
     ;         *t33*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 7.020931347635437d+0*gammabb*t18*t
     1         20*t60*t61*wght/rhob**9.666666666666666d+0+6.582123138408
     2         223d-1*t20*t33*t38*t39*t58*wght-3.9492738830449337d+0*t18
     3         *t20*t38*t39*t57*wght-4.7537555999614944d-1*t1*t18*t21*t4
     4         1*wght+1.0421694969146353d+0*gammabb*t18*t38*t39*t40*wght
     5         +1.0970205230680373d-1*t1*t21*t22*t33*wght+Cmat3(iq,D3_RB
     6         _GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = -2.6328492553632893d+0*t18*t20*t6
     1         0*t61*wght/rhob**8.666666666666666d+0-4.9365923538061673d
     2         -1*t18*t38*t39*t57*wght+Cmat3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = 2.1940410461360746d-1*t4*t5*t55*wght
     1         -5.850776123029532d+0*gammabb*t1*t18*t21*t41*wght+9.36124
     2         179684725d+0*t18*t35*t38*t39*t40*wght-2.925388061514766d-
     3         1*t23*t33*t4*wght+2.4378233845956385d-1*t18*t2*t4*wght+2.
     4         3403104492118126d+0*gammabb*t1*t21*t22*t33*wght+Mmat3(iq,
     5         D3_RB_RB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = -3.5104656738177187d+0*gammabb*t18*
     1         t38*t39*t57*wght-4.388082092272149d-1*t1*t21*t33*t34*wght
     2         +1.462694030757383d+0*t1*t18*t21*t22*wght+Mmat3(iq,D3_RB_
     3         GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = 1.3164246276816446d+0*t18*t38*t39*
     1         t58*wght+Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
            Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
