/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.dsm.util.DAVResourcePropertyVector;
import com.sourceforge.knecs.util.CMCSProperties;
import java.util.Hashtable;
import java.util.Vector;

public class Annotation
extends DAVResource {
    protected Vector mChildren = new Vector();
    protected String mMimeType = null;
    protected String mTextContent;
    protected String mContentNodeUrl = null;
    protected int mLevel = 0;
    protected Annotation mParent = null;
    protected static Hashtable mIconMap = new Hashtable();
    private static String[] defaultEditors;

    public Annotation(DAVResource resource) {
        super(resource);
    }

    public void setParent(Annotation parent) {
        this.mParent = parent;
    }

    public Annotation getParent() {
        return this.mParent;
    }

    public String getPortalUser() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("portaluser"));
        String ret = null;
        if (vec != null) {
            ret = vec.toString();
        }
        return ret;
    }

    public String getNodeId() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        DAVResourcePropertyVector vec = (DAVResourcePropertyVector)this.get(CMCSProperties.getPropertyAsNSProperty("nodeid"));
        String ret = null;
        if (vec != null) {
            ret = vec.toString();
        }
        return ret;
    }

    public void addChild(Annotation child) {
        this.mChildren.add(child);
    }

    public Vector getChildResources() {
        return this.mChildren;
    }

    public void setAnnotationMimeType(String type) {
        this.mMimeType = type;
    }

    public String getAnnotationMimeType() {
        return this.mMimeType;
    }

    public void setContentNodeUrl(String url) {
        this.mContentNodeUrl = url;
    }

    public String getContentNodeUrl() {
        return this.mContentNodeUrl;
    }

    public boolean isText() {
        boolean ret = false;
        if (this.mMimeType != null && this.mMimeType.equals("text/plain")) {
            ret = true;
        }
        return ret;
    }

    public void setTextContent(String content) {
        this.mTextContent = content;
    }

    public String getTextContent() {
        return this.mTextContent;
    }

    public String getImageIcon() {
        String ret = null;
        if (this.mMimeType != null) {
            ret = (String)mIconMap.get(this.mMimeType);
        }
        return ret;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    static {
        String base = "images/cmcs/";
        mIconMap.put("application/whiteboard", base + "EDwhitebd16.gif");
        mIconMap.put("text/plain", base + "EDtext16.gif");
        mIconMap.put("text/html", base + "EDhtml16.gif");
        mIconMap.put("text/equation", base + "EDequation16.gif");
        mIconMap.put("text/pub", base + "EDpublisher16.gif");
        mIconMap.put("audio/x-wav", base + "EDsound16.gif");
        defaultEditors = new String[]{"eln.editors.WhiteBoardWrapper", "eln.editors.TextEditor", "eln.editors.HtmlEditor", "eln.editors.EqnEditor", "eln.editors.ELNPublisherEditor", "eln.editors.SoundEditor"};
    }
}

