// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_EdgeConnect_HeaderFile
#define _ShapeFix_EdgeConnect_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_DataMapOfShapeShape.hxx>
#include <TopTools_DataMapOfShapeListOfShape.hxx>
class TopoDS_Edge;
class TopoDS_Shape;


//! Rebuilds edges to connect with new vertices, was moved from ShapeBuild.
//! Makes vertices to be shared to connect edges,
//! updates positions and tolerances for shared vertices.
//! Accepts edges bounded by two vertices each.
class ShapeFix_EdgeConnect 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT ShapeFix_EdgeConnect();
  
  //! Adds information on connectivity between start vertex
  //! of second edge and end vertex of first edge,
  //! taking edges orientation into account
  Standard_EXPORT   void Add (const TopoDS_Edge& aFirst, const TopoDS_Edge& aSecond) ;
  
  //! Adds connectivity information for the whole shape.
  //! Note: edges in wires must be well ordered
  //! Note: flag Closed should be set for closed wires
  Standard_EXPORT   void Add (const TopoDS_Shape& aShape) ;
  
  //! Builds shared vertices, updates their positions and tolerances
  Standard_EXPORT   void Build() ;
  
  //! Clears internal data structure
  Standard_EXPORT   void Clear() ;




protected:





private:



  TopTools_DataMapOfShapeShape myVertices;
  TopTools_DataMapOfShapeListOfShape myLists;


};







#endif // _ShapeFix_EdgeConnect_HeaderFile
