/*******************************************************************************
* Copyright 2024 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {
namespace v2 {
namespace conv {

// clang-format off
const char** get_plan_registry_entries() {
    static const char *entries[] = {
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb16oc64 tg=oc2ow16 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000E0004B4414C4BF3EFEC7B23F0000803FADD1A03C",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000A83F49440168683FFFBFA13F65C6EA40F6FFA741",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb16oc64 tg=x loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000914D554405161A3FFF4F853F985FC53FF90B5940",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb32oc64 tg=ow2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=05000000000000001FF47A441234E13E04F44A3F62FCB53FF6FFA741",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb16oc64 tg=ic8 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000A6FBA84400708D3F5F34D23D65FE8C3F15C0E63E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=oc2ow16 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000600924441234C83EFBA1B03F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb16oc64 tg=ow16 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=05000000000000003B4C434413F4C63EFBEFA33FFD778F3F05E00E3F",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=16777216:g*oc*od*oh*outsz*ow<=16777216:ic%64==0:mb<=16777216:oc%64==0 ext=out_b2,out_b4 model=0500000000000000CA3613441438CE3EFD5F9D3F66CE863F6334B93D",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow32 tg=oc4 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=05000000000000003368314417888D3EFEC77B3F7FB9F640F6FFA741",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc32ow8 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x3 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=0500000000000000DDFA00440C20F53EFEC38E3F0000803F2D9A093E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc32ow8 tg=mb4oc2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x3 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=0500000000000000404F05441260EC3EFD83AB3F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow32 tg=x loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=050000000000000031AF5C44140CC83E05A3643F55811542F6FFA741",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow16 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=05000000000000009CEA3B440658053F043A783F326BEA41FD7F0D40",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow32 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=05000000000000000F6D38441828983E043C6C3F349E7140F6FFA741",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow8 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=05000000000000003425F043152CC13EFE8B8A3F0000803F0FEDC93E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic64oc64ow16 tg=ow4 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=16777216:g*oc*outsz<=16777216:ic%64==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b2,out_b4 model=0500000000000000B19027441222DA3EFE6B873FCDFED33F016C913F",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32mb8oc16 tg=ic2 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=0500000000000000AA475245FE479C3F04604D3F9A79823F17809F3E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32mb8oc16 tg=x loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=0500000000000000473F5645FC3FB83F04204C3F0000803F3200513E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32mb8oc16 tg=ic8 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=05000000000000002A874B45FF27943F02A84B3F0000803F1200E83E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32oc16ow8 tg=ic4 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=0500000000000000DDDA4D45FF4F993F02604D3F0000803F1480C73E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32oc16ow8 tg=x loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=050000000000000073435445FFF7A53F02F85A3F34DB813F3380713E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32oc16ow8 tg=ic8 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=0500000000000000B6CF4945FFB7903F03504E3F33F3843F1400C03E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32mb8oc16 tg=ic4 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=05000000000000006BAB5145FF6FA13F02F04E3F0000803F1400DE3E",
        "hw=xehpc prop=fwd src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=dpas simd=16 regs=256 iter=ic32oc16ow8 tg=ic2 loop_desc=kw,kh,kd,ic ext=out_b2,out_b4 model=0500000000000000866A544500E89C3F02A0623F0000803F36005B3E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32mb8oc64 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000E78FF543175CA53EFDB5833F0000803F124D9C3E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc32 tg=ow16 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000A7AE30441140F33E00B08E3F9A69A13F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc32 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000624E34440550083F0108913F0094A33F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb16oc32 tg=oc4ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000D38643441362D13E008C993F0000803FAF8D263B",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb16oc64 tg=x loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=050000000000000018BED844FD3B943F1658AE3E0000803FF1FFF741",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32mb32oc64 tg=mb2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=05000000000000004017374415C4973E06F2423F16D25541F6FFA741",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb16oc32 tg=ic8 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000B744DA44FF3B8A3F12A0E33E33238B3F3100743E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=4194304:ic%32==0:mb<=16777216:oc%64==0 ext=out_b1,out_b4 model=0500000000000000A2B2664406D41A3FFE5F7F3F342D843F1700E33E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32oc32ow32 tg=x loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=050000000000000088D08744FEF3903F0044963F32450740F8FF8441",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64oc32ow8 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=050000000000000004261B440638113F00C1873F9A71C33F0540183F",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64oc32ow8 tg=mb8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=0500000000000000E2EE244406A40E3FFE6B8C3FCC44A33F2D9A223E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32oc32ow64 tg=oc4ow2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=0500000000000000F998FA433444493E03C85D3FAA894E40F6FFA741",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64oc32ow16 tg=oc2ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=0500000000000000FB813C44084E003FFFA58E3F9903AD3F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32oc32ow16 tg=ic16 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=05000000000000006AE592440028803F0600173F9959DD3F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32oc32ow32 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=0500000000000000426608441420BE3E06882F3F6590F63FF3DF5E41",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64oc32ow16 tg=oc2ow4 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=4194304:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b4 model=0500000000000000B421404406FC1A3FFE0A8E3F3295B23F0240633F",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc16ow16 tg=ic16 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=05000000000000002EA8084501A4683FFE8FA43F9A79823FA9D1F03C",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc32ow16 tg=ic8 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=050000000000000027F6324501E0633FFE6F923F6646963F1300C53E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16mb16oc16 tg=ic16 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=050000000000000073790745011C693FFFEF9E3F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc32ow16 tg=ic2 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=050000000000000053341A450738203F00107F3F9ABA863F3580673E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc16ow8 tg=ic8 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=05000000000000005988DF4401C0743FFE2FAF3F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc16ow8 tg=ic2 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=05000000000000009CA8AF440508233F00208D3F0000803F309A043E",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc32ow16 tg=x loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=050000000000000045ED03451304E43E0160523F0382883FFC5FA23F",
        "hw=xehpc prop=fwd src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc16ow16 tg=ic4 loop_desc=kw,kh,kd,ic ext=out_b1,out_b4 model=0500000000000000A826ED4402283F3FFE679A3F34DB813F17B7D138",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8mb16oc32 tg=x loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=0500000000000000BB9F804435A01F3E0054813F67B6833FF93FFE3F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=oc8ow2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=050000000000000041CC9E440718223F0154683F0000803F1240E43E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=x loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=05000000000000002F42934405A0303F04204C3F0000803F0470243F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=ic2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=05000000000000006451B844FC0FB63F02F0443F0000803F3600243E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=05000000000000005D46984406701F3F03BC503F334F803F14C0DC3E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=05000000000000009A1E964400688B3F0450303F9AD2893F1200C53E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=ic4 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=05000000000000008FEBB944FF179A3F0468273F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16mb8oc32 tg=ow8 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc*outsz%64==0 ext=out_b1,out_b2 model=0500000000000000D2CF8C4408E0133F04D03C3F4B86843F0680283F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16oc32ow8 tg=mb16oc2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=0500000000000000F80897440830143F0298513FCF628E3F3300333E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow32 tg=x loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=05000000000000003A274944F2E1F83CFF64703FC9264942F6FFA741",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow16 tg=x loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=05000000000000005D394C443510233E00B4583F3B0CF03FF6FFA741",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16oc32ow8 tg=ic2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=0500000000000000EBF1A144FF9F9E3F0568183F0000803F1000E83E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16oc32ow8 tg=ow2 loop_desc=kw,kh,kd,ic 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=050000000000000033BA864406F0303F05203D3F0000803F0280783F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow16 tg=ow2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=0500000000000000B3A0324474C8C63D0192573F99B30140F6FFA741",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16oc32ow8 tg=oc2 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=0500000000000000BCC68E4402885C3F05782B3F0000803F06800F3F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic16oc32ow8 tg=ic4 loop_desc=kw,kh,kd,ic 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc*outsz%64==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b1,out_b2 model=05000000000000007500BE44FECFBE3F0528123F0000803F17B7D138",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=oc2 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=0500000000000000FD0198441300D93E01C8623F99FF9B3F00C08D3F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=ow2 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=0500000000000000E862A44408D0003F00B0753F0000803F0540543F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8mb8oc32 tg=ic16 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=05000000000000004815DE4403143F3FFE47973F6696C13F17B7D138",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=ic8 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=0500000000000000C187C8440348383FFE1FA13F69F6CD3F1200D43E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=ic2 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=05000000000000009F20AA4408300A3F00A87D3F0000803F08A0173F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=ic16 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=05000000000000005C71DC440358323FFEDBA33FFF2FE93F128D8E3E",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=x loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=0500000000000000A673A3441000E83E002C8B3FFF7A833F00B4803F",
        "hw=xehpc prop=fwd src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic8oc32ow8 tg=ic4 loop_desc=kw,kh,kd,ic ext=out_b1,out_b2 model=0500000000000000F099B64406101B3F0040863FCDECB83F6134C33D",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=iw16 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=0500000000000000B4235B4405440F3FFE47883F35D1883F5B34F53D",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32mb8oc64 tg=ic2iw4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=050000000000000086C1274405DC123F0078993F6616903F2D5A2B3E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb16oc32 tg=mb4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=05000000000000007CDD15441274D33E0268773F7F0BD63FFEB78B3F",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc32 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=050000000000000072D6C94316048F3E036C643F0086993F0720153F",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb16oc32 tg=ic2iw16 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=05000000000000000A56F04332943F3E02007B3FB41D803F17C0AA3E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32mb8oc64 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=050000000000000066732744063C083FFE878E3FCAAA973F17B7D138",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb32oc32 tg=iw4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=05000000000000006F774F441448AF3E0388613F6834FB3FF6FFA241",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64mb8oc64 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:sd1sh1sw1 model=0500000000000000C14A5B4405EC203F00C8763F6868923F1480A93E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw8oc64 tg=ic2iw2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000564314440578263FFD37BB3F0290923FFA3F1B40",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw16oc32 tg=iw2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000DC38194406BC1E3FFE17A93F9B28BA3FFD7FAA3F",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw32oc32 tg=ic2iw2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000B5261D441350E33EFE2F8C3F31652C40F81F8341",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw8oc64 tg=ic2iw4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=05000000000000001F6D2A44030C383FFEF39F3F0000803F6134D73D",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw16oc64 tg=ic4iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000F2253044161CEA3E00DC8F3F9A27803F17B7D138",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64iw32oc32 tg=ic2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000BD8B3C4416E4BD3E0270473FD40AA242F6FFA741",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic64iw32oc32 tg=ic4 loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=050000000000000042ED5F440E30F93E05FA353FE4F73242F6FFA741",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw16oc64 tg=ic2iw4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=8388608:g*oc<=8388608:ic%32==0:iw<=16777216:oc%32==0:ow<=16777216:sd1sh1sw1 model=0500000000000000C2B9424403B8273F8006863F6564813FFFAFCF3F",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw16oc16 tg=iw4 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000A2E8DB4403702E3F00E4873F0000803F13C0F03E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32mb16oc16 tg=x loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000655B1A4508C0153FFFF7783F9A79823F16C0873E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw8oc16 tg=iw4 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000B51BB1440420423F00B07A3F0000803F2E5A263E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16mb8oc32 tg=ic4iw2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000005ED31B4502204C3F00B8633F0000803F5D34FA3D",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic32iw16oc16 tg=x loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000009E62F84413B0D83E0408463F3442933FFB2FAA3F",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw8oc32 tg=ic4 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000D6651C4501005D3F01C0653F0000803F291A483E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw8oc32 tg=iw4 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000000DDB154504E0453F00E06D3F0000803F128D893E",
        "hw=xehpc prop=bwd_d src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16iw16oc16 tg=x loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=050000000000000014F8C14408080F3F00406D3F6842853F06E0183F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=ic2iw2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=0500000000000000E3FF984409181D3F0148513F672E933F1300ED3E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb32oc8 tg=x loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=0500000000000000C267AB44F340723DFE4B7A3F6491933FF6FFA741",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=05000000000000001E22924409701A3F0490403F0000803F1100E33E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb16oc8 tg=x loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=0500000000000000A06184442ED05D3E0018723F4D5D833FFC3FB83F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=x loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=05000000000000004A3FAE4408F00D3FFA4FB73FCDE0853F0630193F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=x loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=05000000000000007348974413F0E33E0098973F0000803F0660203F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=iw4 loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=050000000000000069DE9A440100853F03CC4A3F98ED803F12A0ED3E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc16 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0:sd1sh1sw1 model=0500000000000000EA958E440610203F0440403F0000803F05D0193F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=05000000000000003267864404D0373F0508373FE5C5873F03A05D3F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=iw8 loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=050000000000000039AC8F440150803F0368403F67388C3FFF77943F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=x loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=0500000000000000897F9B440680373F03B0433FCD8EA03FFC5F933F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw16oc8 tg=ic2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=0500000000000000F50D784418E0853E00B8723F35E9A83FF87F1C40",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=ic2 loop_desc=kw,kh,kd,oc 2d=1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=0500000000000000EE529244FDFF983F0338393F3490843F02E0593F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=iw4 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=050000000000000002B688440630373F04703D3F00E5883F03E0593F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=ic2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=0500000000000000231DA7440110843FFBFFAC3F00A4843F0BE0093F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc16 tg=iw2 loop_desc=kw,kh,kd,oc 2d=1 prefetch=x1 reqs=g*ic<=4194304:g*oc<=4194304:ic%16==0:iw<=16777216:oc%16==0:ow<=16777216:sd1sh1sw1 model=050000000000000034428C4405605C3F02B0433F0041843F02A0623F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc8 tg=ic2iw4 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000008B6AAC4416809A3E0040723F0178AC3FF6FFA741",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc8 tg=ic2mb2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000003F82B1441060F13EFF0F983F00268D3F1000E83E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc8 tg=ic4iw2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=050000000000000030A0C14406C00B3FFAFFAC3F99739A3FF6FFA741",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc8 tg=iw2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000005D9998441510BA3E01785D3F0000803FFBDFD63F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc8 tg=x loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000E0EAB04408600C3F00A8963F0000803F0880F43E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc8 tg=ic2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000008F8F9F443260693E00E4823FCC40923FFFAF843F",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32mb8oc8 tg=mb2 loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=0500000000000000C124B6440780373FFF07873FCCA6863F1300DE3E",
        "hw=xehpc prop=bwd_d src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=ic32iw8oc8 tg=x loop_desc=kw,kh,kd,oc reqs=sd1sh1sw1 model=05000000000000001467A9441480B83E00B07A3F344F803F03F0493F",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb16oc32 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=0500000000000000D51D8C43F540403D01C0563F99F9334017B7D138",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb64oc32 tg=ic8oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=050000000000000035E5084437001F3EFEFF753F66E6A63FF67F2841",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb64oc16 tg=ic4oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=0500000000000000AC38EF437040EA3D0110663F346FC23FC700AA40",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb16oc16 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=0500000000000000C7D86943F383533C0390403F33755B42F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16mb16oc64 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4 model=05000000000000009383A643F1FFF741F6FFA7419A6D1942F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb16oc32 tg=ic4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=0500000000000000D7348F437880823D04E8473F022C923F17B7D138",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb64oc32 tg=ic4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4,bias model=050000000000000019D7EF43F603333CFF4B843F9631F93FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb16oc64 tg=ic4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=8388608:g*oc*od*oh*ow<=8388608:ic%32==0:mb<=16777216:oc%32==0:oc<=4194304 ext=out_b4 model=0500000000000000647D8D43F7A0263D0420423F0000803F17B7D138",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc32ow64 tg=ic4oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4,bias model=0500000000000000569FCC4378A08F3D00206F3F00202540F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc64ow64 tg=ic16 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4 model=050000000000000031C70D443680213E01C0653FCD141D40F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc64ow32 tg=ic8oc4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4 model=05000000000000006B302B443440393E00A0763F672A823F1500A23E",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc32ow64 tg=ic8oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4,bias model=050000000000000094A5D7433380353E03104D3F9889E33FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc64ow16 tg=ic4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x3 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4 model=0500000000000000F84D6A43F4403B3DFF7F873F66CAF53FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc16ow64 tg=ic4oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4,bias model=050000000000000076F4C44339F0063E0330413FFFEBAA3FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc64ow32 tg=ic8 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4 model=05000000000000001B97A643F7FF0F42F6FFA7413313AD40F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc32ow64 tg=ic8 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=8388608:g*oc<=8388608:ic%32==0:iw%sw==0:iw<=16777216*sw:oc%32==0:oc<=4194304:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=out_b4,bias model=05000000000000008EEFCB437540B33DFF87703FFF879340F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb32oc16 tg=ic2oc4 loop_desc=mb,ow,oh,od ext=out_b4,bias model=0500000000000000CCB2FE44F400443D00407C3F6666D83FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc16ow32 tg=oc8 loop_desc=mb,ow,oh,od ext=out_b4,bias model=050000000000000082AAE6447880963D02AC563F65B4AC3FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16mb16oc32 tg=x loop_desc=mb,ow,oh,od ext=out_b4,bias model=050000000000000099FC0545F0005D3D01A0623F65C6E43FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc16ow16 tg=x loop_desc=mb,ow,oh,od ext=out_b4,bias model=050000000000000059E0C344F0407C3D00207E3F66FEA93FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc16ow16 tg=ic8 loop_desc=mb,ow,oh,od ext=out_b4,bias model=0500000000000000230D9C44F000583D01646C3F01D8B83FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8mb16oc16 tg=oc2 loop_desc=mb,ow,oh,od ext=out_b4,bias model=050000000000000011D8AB44F2C0383D00206A3F32E3C03FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic16oc32ow16 tg=x loop_desc=mb,ow,oh,od ext=out_b4,bias model=05000000000000009034F9447800803DFF7F823F3273D33FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=dpas simd=16 regs=256 iter=ic8oc16ow32 tg=ic2 loop_desc=mb,ow,oh,od ext=out_b4,bias model=050000000000000000CCE4447180C83D01885C3FFF3FE73FF8FF8840",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb8oc16 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 ext=bias model=0500000000000000A6A88B43F7C01A3D0368453F9A211840F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb64oc16 tg=ic4oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 ext=bias model=05000000000000001B917644F801A23CFE3F7C3FFFE99D42F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16mb8oc32 tg=x loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 model=05000000000000003E380244F603563CFF5F893F34F3A740F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb8oc32 tg=x loop_desc=mb,ow,oh,od 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 model=05000000000000005815AC43F2035B3C030C4C3F67DAA042F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb8oc32 tg=ic8oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 model=05000000000000003D15C843F200713D02104D3F9CB94C40F37FEA40",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb64oc16 tg=ic2oc4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 ext=bias model=050000000000000015E48044F821963C00887A3FCB899F42F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb16oc16 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 ext=bias model=050000000000000002A5B243F5C1AA3C03E84C3F97594341F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb8oc16 tg=ic2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x3 reqs=g*ic*id*ih*iw<=4194304:g*oc*od*oh*ow<=4194304:ic%16==0:mb<=16777216:oc%16==0 ext=bias model=0500000000000000B3308343F483443C0028673F01809842F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16oc32ow8 tg=oc8 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 model=050000000000000063BB0044F781B33C00B8863F9AA96B40F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16oc16ow32 tg=oc2 loop_desc=mb,ow,oh,od 2d=1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=0500000000000000B7A19B443600103E0040863F6646B940F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow8 tg=ic2oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=05000000000000007D537A437140D13D04702E3F3473B63FC7E0C440",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16oc16ow8 tg=oc4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=0500000000000000EFB79B43F600173D0040863F99412842F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow64 tg=ic4oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=050000000000000054405244F880053D0140593FE5603040F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow16 tg=ic2oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=050000000000000093739B43F521AA3C01A85F3F9929D73FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow32 tg=ic4oc4 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=0500000000000000179E0044F281E03C0110703FCDD09741F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow32 tg=ic2oc2 loop_desc=mb,ow,oh,od 2d=1 prefetch=x1 reqs=g*ic*sw<=4194304:g*oc<=4194304:ic%16==0:iw%sw==0:iw<=16777216*sw:oc%16==0:ow<=16777216:sw==1|kw==1:sw==1|pw==0 ext=bias model=0500000000000000D8ABF143F621A03C0342573FFD770F40F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow16 tg=ic4oc2 loop_desc=mb,ow,oh,od ext=bias model=050000000000000033E02B44F4E1CB3C0018683F64D43C42F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16oc16ow8 tg=oc16 loop_desc=mb,ow,oh,od ext=bias model=0500000000000000C23F2D44F860073DFF7B813FCDDCF43FF6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow16 tg=ic8 loop_desc=mb,ow,oh,od ext=bias model=050000000000000009F32944F0E1D53C02C85D3F353C7942F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow16 tg=oc4 loop_desc=mb,ow,oh,od ext=bias model=05000000000000002FC23044F401C03C0100763FCD3CA440F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8mb16oc16 tg=ic4 loop_desc=mb,ow,oh,od ext=bias model=0500000000000000F0B64844F401C03C01805F3F65E49942F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic16oc16ow8 tg=oc2 loop_desc=mb,ow,oh,od ext=bias model=050000000000000069912244F3804B3DFFDF773F33F36740F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow8 tg=ic8 loop_desc=mb,ow,oh,od ext=bias model=05000000000000006CC8F643F481C73C0280643F9813E441F6FFA741",
        "hw=xehpc prop=bwd_w src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=16 regs=128 iter=ic8oc16ow16 tg=ic2oc2 loop_desc=mb,ow,oh,od ext=bias model=0500000000000000CEC02C44F441C13C0268723FFDCB3642F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32ow8 tg=mb8 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=05000000000000000553AB450000803F0000803F00300640FFFF843F",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow8 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=0500000000000000B9ADA5450000803F0000803F6656F73F0200623F",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32mb8 tg=ow4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=0500000000000000CE91A9450000803F0000803F99B9E93F0500213F",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=05000000000000009B76A8450000803F0000803F9A7902402F007E3E",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32mb8 tg=mb4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=05000000000000004360AE450000803F0000803FCD8CC93F0480283F",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow16 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=0500000000000000C9D4A5450000803F0000803F6726F13FFF7F783F",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=0500000000000000157AAB450000803F0000803F9911B73F3300603E",
        "hw=xehpc prop=fwd dw=1 src=axb:s8 wei=axcb:s8 dst=axb:s8 fma=mad simd=32 regs=128 iter=g32ow8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b2,out_b4 model=05000000000000009EE0AB450000803F0000803F67EEC83F3600293E",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=ow2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=0500000000000000A0C914450000803F0000803F34959942F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32ow8 tg=mb2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=0500000000000000699018450000803F0000803FCEE59A42F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow16 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=050000000000000058D322450000803F0000803F5F76BF40F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=0500000000000000FE3B1B450000803F0000803FCE8C2F41F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=05000000000000009D3A17450000803F0000803F98A96E415F002041",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=mb2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=0500000000000000380415450000803F0000803F00128242F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=05000000000000007EEC16450000803F0000803F64E6AC405A007041",
        "hw=xehpc prop=fwd dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32ow8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b4 model=0500000000000000CF0218450000803F0000803F3313CD40F83F1341",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow8 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=050000000000000042FEDA440000803F0000803F33A33C40FA7F8140",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32ow8 tg=mb2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=05000000000000007B4EDA4400007B3F0000803F65F64D40FC7F0840",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=ow2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=0500000000000000014BD7440000803F0000803F34D34240FB7F0D40",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=ow4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=05000000000000003894DE440000853F0000803FCB4C4540F9FF3C40",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=0500000000000000D57BD7440000803F0000803FCDCC1340FCFFC03F",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=mb4 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=05000000000000001CF3D6440000803F0000803FCB9C7040F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32ow8 tg=x loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=05000000000000006A27DA4400E0863F0000803F9BB98C40F6FFA741",
        "hw=xehpc prop=fwd dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32ow8 tg=ow2 loop_desc=kw,kh,kd,ic reqs=ic1oc1 ext=out_b1,out_b2 model=0500000000000000EF0CD4440050803F0000803F9B495F40291A5C3E",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=iw4 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000183E1A450000803F0000803FFFB75C41F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw16 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000AA431C450000803F0000803FFDFF6541F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=iw2 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000025A16450000803F0000803F99C28F42F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw8 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000B63C16450000803F0000803F998B0842F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw2 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000014313450000803F0000803F998B8442F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000D2E415450000803F0000803F67167641F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw4 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000DD4E12450000803F0000803FCBCC7941F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:bf16 wei=axbc:bf16 dst=axb:bf16 fma=mad simd=32 regs=128 iter=g32iw8 tg=x loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000955F18450000803F0000803FCCC49440FBFFD93F",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=iw8 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=05000000000000007055E0440000803F0000803F34FB2640F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=iw16 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000BD82EB440000803F0000803F66CE0640F77FA440",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=iw2 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=050000000000000091B1D0440100763F0000803F64F64D40F87FAE40",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw8 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=05000000000000009B1BCD440000803F0000803FCACC7640F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000800BDE440080823F0000803FE6690C4005805A3F",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw4 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=05000000000000007FEBC744001C823F0000803F99B98C40F6FFA741",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32iw8 tg=x loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=0500000000000000D60AD5440000803F0000803F335311400240633F",
        "hw=xehpc prop=bwd_d dw=1 src=axb:f32 wei=axbc:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32iw8 tg=iw2 loop_desc=kw,kh,kd,oc reqs=ic1oc1sd1sh1sw1 model=05000000000000003A92C34400807D3F0000803F660E9140F6FF5540",
        "hw=xehpc prop=bwd_w dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=16 regs=128 iter=g16mb8 tg=x loop_desc=mb,ow,oh,od reqs=ic1oc1 ext=out_b4,bias model=050000000000000069CC71447940813D01305F3FCC2C87420000803F",
        "hw=xehpc prop=bwd_w dw=1 src=axb:bf16 wei=axcb:bf16 dst=axb:bf16 fma=mad simd=16 regs=128 iter=g16ow8 tg=x loop_desc=mb,ow,oh,od reqs=ic1oc1 ext=out_b4,bias model=05000000000000005EBA5944F500493DFEFF7F3F341391420000803F",
        "hw=xehpc prop=bwd_w dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32mb8 tg=x loop_desc=mb,ow,oh,od reqs=ic1oc1 ext=bias model=050000000000000027096344F980003D0000713F65E65F410000803F",
        "hw=xehpc prop=bwd_w dw=1 src=axb:f32 wei=axcb:f32 dst=axb:f32 fma=mad simd=32 regs=128 iter=g32ow8 tg=x loop_desc=mb,ow,oh,od reqs=ic1oc1 ext=bias model=05000000000000002EB44044F500493D01005D3FFFBF66420000803F",
        nullptr,
    };
    return entries;
}
// clang-format on

} // namespace conv
} // namespace v2
} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
