/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import xsbt.boot.UpdateApp;
import xsbt.boot.UpdateConfiguration;
import xsbt.boot.UpdateScala;
import xsbt.boot.UpdateTarget;
import xsbt.boot.Value$;
import xsbti.RetrieveException;

public final class ModuleDefinition {
    private final UpdateConfiguration configuration;
    private final File[] extraClasspath;
    private final UpdateTarget target;
    private final String failLabel;

    public final UpdateConfiguration configuration() {
        return this.configuration;
    }

    public final File[] extraClasspath() {
        return this.extraClasspath;
    }

    public final UpdateTarget target() {
        return this.target;
    }

    public final Nothing$ retrieveFailed() {
        return this.fail("");
    }

    public final Nothing$ retrieveCorrupt(Iterable iterable) {
        return this.fail(new StringBuilder().append((Object)": missing ").append((Object)iterable.mkString(", ")).toString());
    }

    private Nothing$ fail(String string) {
        String string2;
        ModuleDefinition moduleDefinition = this;
        UpdateTarget updateTarget = moduleDefinition.target;
        if (updateTarget instanceof UpdateScala) {
            string2 = moduleDefinition.configuration.getScalaVersion();
        } else if (updateTarget instanceof UpdateApp) {
            string2 = (String)Value$.get$3652317c$286a377a(((UpdateApp)updateTarget).id().version$33e6f9b0$5e1c4a78());
        } else {
            throw new MatchError(updateTarget);
        }
        throw new RetrieveException(string2, new StringBuilder().append((Object)"Could not retrieve ").append((Object)this.failLabel).append((Object)string).toString());
    }

    public ModuleDefinition(UpdateConfiguration updateConfiguration, File[] fileArray, UpdateTarget updateTarget, String string) {
        this.configuration = updateConfiguration;
        this.extraClasspath = fileArray;
        this.target = updateTarget;
        this.failLabel = string;
    }

    private ModuleDefinition() {
    }

    private static String[] listTokenValues(Repository repository, String string, String string2) {
        String string3;
        String string4 = repository.getFileSeparator();
        int n = (string = repository.standardize(string)).indexOf(string3 = IvyPatternHelper.getTokenString(string2));
        if (n == -1) {
            Message.verbose(new StringBuffer().append("unable to list ").append(string2).append(" in ").append(string).append(": token not found in pattern").toString());
            return null;
        }
        if ((string.length() <= n + string3.length() || string4.equals(string.substring(n + string3.length(), n + string3.length() + 1))) && (n == 0 || string4.equals(string.substring(n - 1, n)))) {
            String string5 = string.substring(0, n);
            return ModuleDefinition.listAll(repository, string5);
        }
        int n2 = string.substring(0, n).lastIndexOf(string4);
        String string6 = n2 == -1 ? "" : string.substring(0, n2);
        try {
            Message.debug(new StringBuffer().append("\tusing ").append(repository).append(" to list all in ").append(string6).toString());
            List list = repository.list(string6);
            if (list != null) {
                Message.debug(new StringBuffer().append("\t\tfound ").append(list.size()).append(" urls").toString());
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n3 = string.indexOf(string4, n2 + 1);
                String string7 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
                Pattern pattern = Pattern.compile(IvyPatternHelper.substituteToken(string7.replaceAll("\\.", "\\\\."), string2, "(.+)"));
                for (String string8 : list) {
                    Matcher matcher = pattern.matcher(string8.substring(string6.length() + 1));
                    if (!matcher.matches()) continue;
                    String string9 = matcher.group(1);
                    arrayList.add(string9);
                }
                Message.debug(new StringBuffer().append("\t\t").append(arrayList.size()).append(" matched ").append(string).toString());
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return null;
        }
        catch (IOException iOException) {
            Message.verbose(new StringBuffer().append("problem while listing resources in ").append(string6).append(" with ").append(repository).append(":").toString());
            Message.verbose(new StringBuffer().append("  ").append(iOException.getClass().getName()).append(" ").append(iOException.getMessage()).toString());
            return null;
        }
        catch (Exception exception) {
            Message.warn(new StringBuffer().append("problem while listing resources in ").append(string6).append(" with ").append(repository).append(":").toString());
            Message.warn(new StringBuffer().append("  ").append(exception.getClass().getName()).append(" ").append(exception.getMessage()).toString());
            return null;
        }
    }

    private static String[] listAll(Repository repository, String string) {
        try {
            String string2 = repository.getFileSeparator();
            Message.debug(new StringBuffer().append("\tusing ").append(repository).append(" to list all in ").append(string).toString());
            List list = repository.list(string);
            if (list != null) {
                Message.debug(new StringBuffer().append("\t\tfound ").append(list.size()).append(" resources").toString());
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (String string3 : list) {
                    if (string3.endsWith(string2)) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    int n = string3.lastIndexOf(string2);
                    arrayList.add(string3.substring(n + 1));
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException iOException) {
            Message.verbose(new StringBuffer().append("problem while listing resources in ").append(string).append(" with ").append(repository).append(":").toString());
            Message.verbose(new StringBuffer().append("  ").append(iOException.getClass().getName()).append(" ").append(iOException.getMessage()).toString());
            return null;
        }
        catch (Exception exception) {
            Message.warn(new StringBuffer().append("problem while listing resources in ").append(string).append(" with ").append(repository).append(":").toString());
            Message.warn(new StringBuffer().append("  ").append(exception.getClass().getName()).append(" ").append(exception.getMessage()).toString());
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        String string2 = IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug(new StringBuffer().append("\tlisting all in ").append(string2).toString());
        String[] stringArray = ModuleDefinition.listTokenValues(repository, string2, "revision");
        if (stringArray != null) {
            Message.debug(new StringBuffer().append("\tfound revs: ").append(Arrays.asList(stringArray)).toString());
            ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = IvyPatternHelper.substituteToken(string2, "revision", stringArray[i]);
                try {
                    Resource resource = repository.getResource(string3);
                    if (resource == null) continue;
                    arrayList.add(new ResolvedResource(resource, stringArray[i]));
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn(new StringBuffer().append("impossible to get resource from name listed by repository: ").append(string3).append(": ").append(iOException.getMessage()).toString());
                }
            }
            if (stringArray.length != arrayList.size()) {
                Message.debug(new StringBuffer().append("\tfound resolved res: ").append(arrayList).toString());
            }
            return arrayList.toArray(new ResolvedResource[arrayList.size()]);
        }
        if (string2.indexOf("[revision]") == -1) {
            try {
                Resource resource = repository.getResource(string2);
                if (resource.exists()) {
                    Message.debug(new StringBuffer().append("\tonly one resource found without real listing: using and defining it as working@").append(repository.getName()).append(" revision: ").append(resource.getName()).toString());
                    return new ResolvedResource[]{new ResolvedResource(resource, new StringBuffer().append("working@").append(repository.getName()).toString())};
                }
            }
            catch (IOException iOException) {
                Message.debug(new StringBuffer().append("\timpossible to get resource from name listed by repository: ").append(string2).append(": ").append(iOException.getMessage()).toString());
            }
            Message.debug("\tno revision found");
        }
        return null;
    }
}

