/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <GTLCore/MemoryManager_p.h>

#include <iostream>
#include <cstdlib>

// GTLCore Headers
#include <GTLCore/String.h>

void printHelp()
{
  std::cout << "Usage : mmbenchmark [memorymanager]" << std::endl;
  std::cout << std::endl;
  std::cout << "memorymanager: gtlmm osmm" << std::endl;
}

#define _COUNT_LOOP_ 100000000
#define _OBJECT_SIZE_ 10

int main(int argc, char** argv)
{
  if( argc != 2)
  {
    printHelp();
  } else {
    GTLCore::String mode = argv[1]; 
    if( mode == "gtlmm" ) {
      for(int i = 0; i < _COUNT_LOOP_; ++i)
      {
        void* ptr = GTLCore::MemoryManager::allocate(_OBJECT_SIZE_);
        GTLCore::MemoryManager::desallocate(ptr);
      }
    } else if( mode == "osmm" ) {
      for(int i = 0; i < _COUNT_LOOP_; ++i)
      {
        void *ptr = malloc(_OBJECT_SIZE_);
        free(ptr);
      }
    } else {
      printHelp();
    }
  }
}

