// OpenSTA, Static Timing Analyzer
// Copyright (c) 2019, Parallax Software, Inc.
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef STA_DISALLOW_COPY_ASSIGN_H
#define STA_DISALLOW_COPY_ASSIGN_H

// Disallow the copy constructor and operator= functions.
// This should be used in the private declarations for a class.
#define DISALLOW_COPY_AND_ASSIGN(type_name) \
  type_name(const type_name&) = delete; \
  void operator=(const type_name&) = delete

#endif
