###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for openssh FEDORA-2007-715
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861012);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-715");
  script_cve_id("CVE-2007-4752", "CVE-2007-3102");
  script_name( "Fedora Update for openssh FEDORA-2007-715");
  desc = "

  Vulnerability Insight:
  SSH (Secure SHell) is a program for logging into and executing
  commands on a remote machine. SSH is intended to replace rlogin and
  rsh, and to provide secure encrypted communications between two
  untrusted hosts over an insecure network. X11 connections and
  arbitrary TCP/IP ports can also be forwarded over the secure channel.
  
  OpenSSH is OpenBSD's version of the last free version of SSH, bringing
  it up to date in terms of security and features, as well as removing
  all patented algorithms to separate libraries.
  
  This package includes the core files necessary for both the OpenSSH
  client and server. To make this package useful, you should also
  install openssh-clients, openssh-server, or both


  Affected Software/OS:
  openssh on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00214.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssh");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"openssh", rpm:"openssh~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openssh", rpm:"x86_64/openssh~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openssh-clients", rpm:"x86_64/openssh-clients~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openssh-askpass", rpm:"x86_64/openssh-askpass~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/openssh-server", rpm:"x86_64/openssh-server~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/openssh-debuginfo", rpm:"x86_64/debug/openssh-debuginfo~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openssh-askpass", rpm:"i386/openssh-askpass~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/openssh-debuginfo", rpm:"i386/debug/openssh-debuginfo~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openssh", rpm:"i386/openssh~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openssh-server", rpm:"i386/openssh-server~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/openssh-clients", rpm:"i386/openssh-clients~4.3p2~25.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}