##############################################################################
#
#  Opera Web Browser Multiple Security Vulnerabilities Aug-08 (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/21
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0136
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900038);
 script_cve_id("CVE-2008-4195");
 script_bugtraq_id(30768);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Opera Web Browser Multiple Security Vulnerabilities Aug-08 (Win)");
 script_summary("Check for Opera Web Browser Version");
 desc = "
 Overview : The remote host is running Opera Web Browser, which is prone
 to multiple vulnerabilities.

 Vulnerability Insight :

	Multiple vulnerabilities exists in Opera Browser,
	- Sites can change framed content on other sites
	- Startup crash can allow execution of arbitrary code
	- Custom shortcuts can pass the wrong parameters to applications
	- Insecure pages can show incorrect security information
	- Feed links can link to local files
	- Feed subscription can cause the wrong page address to be displayed

        Impact : Remote exploitation will allow browser to crash, can potentially 
        execute arbitrary code, cross site scripting attacks, and can even change 
        the address field to the address of the malicious web page to mislead a user.

 Impact Level : Application

 Affected Software/OS :
        Opera Version 9.51 and prior versions on Windows (All)

 Fix : Upgrade to Opera version 9.52,
 http://www.opera.com/download/

 References :
 http://www.opera.com/support/search/view/892/
 http://www.opera.com/support/search/view/893/
 http://www.opera.com/support/search/view/894/
 http://www.opera.com/support/search/view/895/
 http://www.opera.com/support/search/view/896/
 http://www.opera.com/support/search/view/897/
 http://www.opera.com/docs/changelogs/windows/952/

 CVSS Score Report :
        CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.5 
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "secpod_opera_detection_win_900036.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 if(egrep(pattern:"^([0-8]\..*|9\.([0-4]?[0-9]|5[01]))$",
	  string:get_kb_item("Opera/Win/Version"))){
	security_hole(0);
 }
