# kst-gpl
#
# (C) Michel Arboi
# GPLv2
#
# http://perso.univ-rennes1.fr/bernard.perrot/SSF/index.html
# http://ccweb.in2p3.fr/secur/ssf/

if(description)
{
 script_id(80087);;
 script_version ("$Revision: 1.2 $");
 script_tag(name:"cvss_base", value:"2.6");
 script_tag(name:"risk_factor", value:"Medium");

 script_name( "SSF Detection");
 
 desc = "
Synopsis :

The remote version of the SSH server is not maintained
any more.

Description :

According to its banner, the remote SSH server is the
SSF derivative.

SSF had been written to be compliant with restrictive 
laws on cryptography in some European countries, France 
especially. 

These regulations have been softened and OpenSSH received 
a formal authorisation from the French administration in 
2002 and the development of SSF has been discontinued.

SSF is based upon an old version of OpenSSH and it implements
an old version of the protocol. As it is not maintained any
more, it might be vulnerable to dangerous flaws.

See also :

http://ccweb.in2p3.fr/secur/ssf/
http://perso.univ-rennes1.fr/bernard.perrot/SSF/

Solution : 

Remove SSF and install an up to date version of OpenSSH.

Risk factor : 

Low / CVSS Base Score : 2.6 
(CVSS#2:AV:R/AC:H/Au:NR/C:P/I:N/A:N)";

 script_description(desc);
 
 script_summary( "Look for SSF in the SSH banner");
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2008 Michel Arboi");
 script_family( "General");
 script_dependencie("ssh_detect.nasl");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

include('misc_func.inc');

port = get_kb_item("Services/ssh");
if (! port) port = 22;
if (! get_port_state(port)) exit(0);

banner = get_unknown_banner(port: port);
if (egrep(string: banner, pattern: "^SSH-[0-9.]+-SSF"))
 security_note(port);

