# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-818-1 (curl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64773);
 script_cve_id("CVE-2009-2417");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Ubuntu USN-818-1 (curl)");

 desc = "The remote host is missing an update to curl
announced via advisory USN-818-1.

Details follow:

Scott Cantor discovered that Curl did not correctly handle SSL
certificates with zero bytes in the Common Name.  A remote attacker could
exploit this to perform a man in the middle attack to view sensitive
information or alter encrypted communications.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libcurl3                        7.15.1-1ubuntu3.2

Ubuntu 8.04 LTS:
  libcurl3                        7.18.0-1ubuntu2.2

Ubuntu 8.10:
  libcurl3                        7.18.2-1ubuntu4.4

Ubuntu 9.04:
  libcurl3                        7.18.2-8ubuntu4.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-818-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-818-1 (curl)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcurl3-dev", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls-dev", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-openssl-dev", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.15.1-1ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-gnutls-dev", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-openssl-dev", ver:"7.18.0-1ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-gnutls-dev", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-openssl-dev", ver:"7.18.2-1ubuntu4.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-gnutls-dev", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-openssl-dev", ver:"7.18.2-8ubuntu4.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
