/*
    scconfig - tcl lib detection
    Copyright (C) 2009  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/

#include "scripts.h"
#include <unistd.h>


int find_script_tcl(int logdepth, int fatal)
{
	char *out, *temp, *temp2, *cmd, *I, *L, *end, **tclsh;

	char *tclshs[] = {
		"tclsh",
		"tclsh85",
		"tclsh84",
		"tclsh8.5",
		"tclsh8.4",
		NULL
	};

	char *test_c =
		NL "#include <tcl.h>"
		NL "int main() {"
		NL "	Tcl_Obj *res;"
		NL "	Tcl_Interp *interp;"
		NL "	interp = Tcl_CreateInterp();"
		NL "	puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	char *tcl_config =
			NL "proc tclConfigFile {} {"
			NL "	set d [info library]"
			NL "	set f [file join $d \"tclConfig.sh\"]"
			NL "	if {[file exists $f]} {return $f}"
			NL ""
			NL "	set d [file dirname $d]"
			NL "	set f [file join $d \"tclConfig.sh\"]"
			NL "	if {[file exists $f]} {return $f}"
			NL ""
			NL "	set d [file dirname $d]"
			NL "	set f [file join $d \"tclConfig.sh\"]"
			NL "	if {[file exists $f]} {return $f}"
			NL ""
			NL "	set d [file dirname $d]"
			NL "	set f [file join $d \"tclConfig.sh\"]"
			NL "	if {[file exists $f]} {return $f}"
			NL "}"
			NL ""
			NL "puts [tclConfigFile]"
			NL;


	require("cc/cc", logdepth, fatal);

	report("Checking for tcl... ");
	logprintf(logdepth, "find_tcl: trying to find tcl...\n");
	logdepth++;

	/* Look at some standard places */
	if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, "+", "+-ltcl")) return 0;
	if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, "+", "+-ltcl84")) return 0;
	if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, "+", "+-ltcl8.4")) return 0;
	if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, "+-I/usr/include/tcl84", "+-ltcl84")) return 0;
	if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, "+-I/usr/include/tcl8.4", "+-ltcl8.4")) return 0;

	/* Try the config script */
	logprintf(logdepth, "running config tcl\n");
	temp = tempfile_dump(tcl_config, ".tcl");
	cmd = malloc(strlen(temp) + 16);
	for(tclsh = tclshs; *tclsh != NULL; tclsh++) {
		sprintf(cmd, "%s %s", *tclsh, temp);
		report("Trying: %s\n", cmd);
		if (run(logdepth+1, cmd, &out) == 0) {
			free(cmd);
			cmd = malloc(strlen(out) + 256);
			sprintf(cmd, "#!/bin/sh\n. %s\necho +$TCL_INCLUDE_SPEC\necho +$TCL_LIB_SPEC\n", out);
			temp2 = tempfile_dump(cmd, ".sh");
			free(out);
			out = malloc(strlen(temp2) + 32);
			sprintf(out, "chmod +x %s", temp2);
			system(out);
			free(out);
			if (run(logdepth+1, temp2, &out) == 0) {
				remove(temp2);
				I = out;
				L = strchr(I, '\n');
				if (L != NULL) {
					*L = '\0';
					L++;
					end = strchr(L, '\n');
					if (end != NULL)
						*end = '\0';
				}
				if (try_icl(logdepth, "libs/script/tcl", test_c, NULL, I, L)) {
					remove(temp);
					free(cmd);
					if (out != NULL)
						free(out);
					return 0;
				}
			}
			remove(temp2);
		}
	}
	remove(temp);
	free(cmd);
	if (out != NULL)
		free(out);

	return try_fail(logdepth, "libs/script/tcl");
}
