#!/usr/bin/php
<?php

require_once('Net/PublicSuffix.php');

global $errorcount;
global $testcount;

function p($x) {
  if (is_null($x))
    return 'NULL';
  else
    return $x;
}

function checkPublicSuffix($d, $v) {
  global $errorcount;
  global $testcount;
  $testcount += 1;
  try {
    $n = Net_PublicSuffix::registered_domain($d);
    if ($n !== $v) {
      $errorcount++;
      printf("test %d    error: domain: %s\texpected: %s\tgot: %s\n", $testcount, p($d), p($v), p($n));
    }
  } catch (Exception $e) {
    $errorcount++;
    printf("test %d exception: domain: %s\texpected: %s\tgot: %s\n", $testcount, p($d), p($v), p($n));
  }
}

//print_r(get_prevailing_suffix_rule('nancy.george.com.uk'));
eval(file_get_contents('/usr/share/doc/publicsuffix/examples/test_psl.txt'));

printf("%d errors total\n", $errorcount);

if ($errorcount > 0)
  exit(1);
else
  exit(0);
/*
 * Local Variables:
 * indent-tabs-mode: nil
 * c-basic-offset: 2
 * End:
 */
