/*	Value_test

CVS ID: Value_test.java,v 1.5 2012/04/16 06:14:24 castalia Exp

Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.PVL.*;

import	java.io.File;
import	java.util.Iterator;
import	java.util.ListIterator;
import	java.util.Vector;
import	java.io.ByteArrayOutputStream;


public class Value_test
{

public static void main (String[] arguments) 
{
System.out.println ("*** Value_test ***");
try
	{
	String
		parameter_string =
			"The_Value = \n" +
			"	(101.1 <real>, 22 <integer>, \"three\" <text>, 'four' <symbol>, five <identifier>,\n" +
			"		{1, 2, 3, 4,\n" +
			"			{ 11, 22, 33} <subset>,\n" +
			"		5} <set> }/* should be ')' */ <sequence>\n";
	Parameter
		parameter;
	Value
		values,
		value,
		new_value,
		val;
	int
		value_type,
		count;
	boolean
		test;

	System.out.println ("--- parameter_string:");
	System.out.println (parameter_string);
	System.out.println
		("--- Constructing a parameter from the String:\n"
		+ "\tparameters = new Parameter (new Parser (parameter_string));");
	//	Constructor: String Parser
	parameter = new Parameter (new Parser (parameter_string));
	if (parameter.Warning () != null)
		{
		System.out.println (parameter.Warning ().getMessage ());
		System.out.println ("*** Array enclosure mismatch expected.");
		}
	else
		System.out.println ("!!! Array enclosure mismatch expected.");
		
	System.out.println
		("--- Writing the parameter:\n"
		+ "\tparameter.Write ();");
	//	Write: Parameter
	count = parameter.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Get the Values Array from the Parameter:\n"
		+ "\tvalues = parameter.Value ();");
	values = parameter.Value ();
		
	System.out.println
		("--- Writing the Values Array:\n"
		+ "\tvalues.Write ();");
	//	Write: Value
	count = values.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Iterating");
	print_values (values);

	System.out.println
		("--- Finding 3:\n"
		+ "\tvalue = values.Find (3);");
	//	Find: int
	value = values.Find (3);
	if (value == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	System.out.println ("*** Found: " + value.Type_Name () + " " + value);
	System.out.println
		("--- Writing Parent:\n"
		+ "\tvalue.Parent ().Write ();");
	//	Parent:
	value.Parent ().Write ();

	System.out.println
		("--- Changing its type to TEXT:\n"
		+ "\tvalue.Type (Value.TEXT);");
	//	Type: INTEGER to TEXT
	value.Type (Value.TEXT);
	System.out.println (value.Type_Name () + " " + value);
	if (value.Is_String ())
		System.out.println ("*** Correct");
	else
		{
		System.out.println ("!!! Failed");
		System.exit (1);
		}

	System.out.println
		("--- Writing to a ByteArrayOutputStream (sans formatting):\n"
		+ "\ttext = new ByteArrayOutputStream ();\n"
		+ "\tvalues.Write (text, false);");
	ByteArrayOutputStream
		text = new ByteArrayOutputStream ();
	//	Write: to ByteArrayOutputStream without indenting
	value.Write (text, false);
	System.out.print (text);
	if (text.toString ().startsWith ("\"3\""))
		System.out.println ("*** Correct");
	else
		System.out.println ("!!! Wrong. Should be quoted");

	System.out.println
		("--- Changing the text:\n"
		+ "\tvalue.Data (\"'7.8'\");");
	//	Data: String SYMBOL
	value.Data ("'7.8'");
	System.out.println (value.Type_Name () + " " + value);
	//	String_Data:
	if (value.String_Data ().equals ("7.8") &&
		value.Is_Symbol ())
		System.out.println ("*** Correct");
	else
		{
		System.out.println ("!!! Failed");
		System.exit (1);
		}

	System.out.println
		("--- Changing the type to REAL:\n"
		+ "\tvalue.Type (Value.REAL);");
	//	Type: STRING to REAL
	value.Type (Value.REAL);
	System.out.println (value.Type_Name () + " " + value);
	//	double_Data:
	if (value.Is_Real () &&
		value.double_Data () == 7.8)
		System.out.println ("*** Correct");
	else
		{
		System.out.println ("!!! Failed");
		System.exit (1);
		}

	System.out.println
		("--- Finding this value in the values array:\n"
		+ "\tvalue = values.Find (value);");
	//	Find: Value
	value = values.Find (value);
	if (value == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	System.out.println ("*** Found: " + value.Type_Name () + " " + value);

	System.out.println
		("--- Finding no-such-value:\n"
		+ "\tvalues.Find (\"no-such-value\")");
	if (values.Find ("no-such-value") == null)
		System.out.println ("*** Not found (correct)");
	else
		System.out.println ("!!! Found (shouldn't have)");


	System.out.println
		("--- Make a new value:\n"
		+ "\tnew_value = new Value (\"\\\"This is a new value\\\"\");");
	//	Constructor: String
	new_value = new Value ("\"This is a new value\"");
	System.out.println (new_value.Type_Name () + " " + new_value);
	System.out.println
		("--- Add the test values to it:\n"
		+ "\tvalue_type = new_value.Type ();\n"
		+ "\tnew_value.Add (values);");
	value_type = new_value.Type ();
	//	Add: ARRAY to STRING
	try {new_value.Add (values);}
	catch (PVL_Exception exception)
		{
		System.out.println (exception.getMessage () + "\n");
		System.out.println ("!!! Failed");
		System.exit (1);
		}
	print_values (new_value);
	if (new_value.Is_Array ())
		System.out.println ("*** Correct");
	else
		{
		System.out.println ("!!! Wrong. Should now be an Array");
		System.exit (1);
		}

	System.out.println
		("--- Remove the test values:\n"
		+ "\tnew_value.Remove (values);");
	//	Remove: Value
	new_value.Remove (values);
	System.out.print (new_value.Type_Name () + " ");
	new_value.Write ();
	//	getChildCount:
	if (new_value.getChildCount () == 1)
		System.out.println ("*** Correct");
	else
		{
		System.out.println
			("!!! Wrong. Should only have one entry instead of "
			+ new_value.getChildCount ());
		System.exit (1);
		}

	System.out.println
		("--- Try to Add a Vector containing a Parameter:\n"
		+ "\tVector vector = new Vector ();\n"
		+ "\tvector.add (parameter);\n"
		+ "\tvalues.Add (vector);");
	Vector vector = new Vector ();
	vector.add (parameter);
	//	Add: Vector with invalid object
	test = true;
	try {new_value.Add (vector);}
	catch (PVL_Exception exception)
		{
		System.out.println (exception.getMessage () + "\n");
		System.out.println ("*** Correct");
		test = false;
		}
	if (test)
		{
		System.out.println ("!!! Wrong: Should have failed");
		System.exit (1);
		}

	System.out.println
		("--- Restore it to its former type:\n"
		+ "\tnew_value.Type (value_type);");
	//	Type: ARRAY to TEXT
	new_value.Type (value_type);
	System.out.print (new_value.Type_Name () + " ");
	new_value.Write ();
	if (new_value.Type () == value_type)
		System.out.println ("*** Correct");
	else
		{
		System.out.println
			("!!! Wrong. Should be type " + Value.Type_Name (value_type));
		System.exit (1);
		}

	System.out.println
		("Current values:");
	print_values (values);
	System.out.println
		("--- Add the ARRAY (Vector) from the values:\n"
		+ "\tnew_value.Add (values.Vector_Data ());");
	test = true;
	//	Vector_Data:
	//	Add: Vector to TEXT
	try {new_value.Add (values.Vector_Data ());}
	catch (PVL_Exception exception)
		{
		System.out.println (exception.getMessage () + "\n");
		System.out.println ("!!! Failed");
		test = false;
		}
	if (test)
		{
		new_value.Write ();
		if (new_value.getChildCount () == (values.getChildCount () + 1))
			System.out.println ("*** Correct");
		else
			{
			System.out.println
				("!!! Wrong: Should have "
			 	+ (values.getChildCount () + 1) + " array values");
			System.exit (1);
			}
		}

	System.out.println
		("--- Remove the first entry :\n"
		+ "\tnew_value.Remove (0);");
	//	Remove: index
	//	Constructor: Value clone
	if (new_value.Remove (0) == null)
		{
		System.out.println ("!!! Failed");
		System.exit (1);
		}
	else
		{
		new_value.Write ();
		System.out.println ("*** Correct");
		}
	System.out.println
		("--- Copy the new_value to values:\n"
		+ "\tvalues = new Value (new_value);");
	values = new Value (new_value);
	values.Write ();
	System.out.println
		("--- Testing equality of copy:\n"
		+ "\tvalues.equals (new_value)");
	//	equals:
	if (values.equals (new_value))
		System.out.println ("*** true");
	else
		System.out.println ("!!! false");
	System.out.println
		("--- Change the new_value array element 11 INTEGER to REAL:\n"
		+ "\tnew_value.Find (11).Type (Value.REAL);");
	new_value.Find (11).Type (Value.REAL);
	System.out.println
		("--- Testing equality again:\n"
		+ "\tvalues.equals (new_value)");
	if (values.equals (new_value))
		System.out.println ("!!! true (should be false)");
	else
		System.out.println ("*** false");
	System.out.println
		("--- Testing equivalence of copy:\n"
		+ "\tvalues.equalsIgnoreCase (new_value)");
	//	equalsIgnoreCase:
	if (values.equalsIgnoreCase (new_value))
		System.out.println ("*** true");
	else
		System.out.println ("!!! false");

	System.out.println
		("--- Empty new_value array and reset to TEXT:\n"
		+ "\tnew_value.Remove_All ().Data (\"\\\"This is a new value\\\"\");");
	//	Remove_All:
	//	Data: empty ARRAY to TEXT
	new_value.Remove_All ().Data ("\"This is a new value\"");
	System.out.println (new_value.Type_Name () + " " + new_value);
	if (new_value.Is_Text ())
		System.out.println ("*** Correct");
	else
		{
		System.out.println ("!!! Failed");
		System.exit (1);
		}

	System.out.println
		("--- ListIterator starting at second entry of values:\n"
		+ "\tlist = values.listIterator (1);");
	//	ListIterator:
	ListIterator
		list = values.listIterator (1);
	System.out.println
		("--- Iterating forward:\n"
		+ "\twhile (list.hasNext ()) {\n"
		+ "\t	list.next ();");
	//	ListIterator: hasNext
	while (list.hasNext ())
		{
		//	ListIterator: next
		value = (Value)list.next ();
		System.out.println (value.Type_Name () + ": " + value);
		if (value.Is_Identifier ())
			{
			System.out.println
				("--- add new_value after first IDENTIFIER:\n"
				+ "\tlist.add (new_value);");
			//	ListIterator: add
			list.add (new_value);
			}
		}

	System.out.println
		("--- Iterating back:\n"
		+ "\twhile (list.hasPrevious ()) {\n"
		+ "\t	list.previous ();");
	//	ListIterator: hasNext
	while (list.hasPrevious ())
		{
		//	ListIterator: next
		value = (Value)list.previous ();
		System.out.println (value.Type_Name () + ": " + value);
		}

	System.out.println
		("--- Iterating foward again");
	while (list.hasNext ())
		{
		value = (Value)list.next ();
		System.out.println (value.Type_Name () + ": " + value);
		if (value.equals (new_value))
			{
			System.out.println
				("--- remove new_value:\n"
				+ "\tlist.remove ();");
			//	ListIterator: remove
			list.remove ();
			}
		}
	System.out.println ("--- Writing everything");
	count = values.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Iterating back again");
	while (list.hasPrevious ())
		{
		value = (Value)list.previous ();
		System.out.println (value.Type_Name () + ": " + value);
		if (value.Is_Array ())
			{
			System.out.println
			("--- Replace last ARRAY with new_value:\n"
			+ "\tlist.set (new_value);");
			list.set (new_value);
			break;
			}
		}
	System.out.println ("--- Writing everything");
	count = values.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Insert the replaced value at the third entry:\n"
		+ "\tvalues.Insert (value, 2);");
	values.Insert (value, 2);
	count = values.Write ();
	System.out.println (count + " characters written.\n");

	}
catch (Exception exception)
	{
	System.err.println (exception.getMessage () + "\n\n");
	System.exit (-1);
	}
System.exit (0);
}


public static void print_values (Value value)
{
//	Iterator:
Iterator
	list = value.iterator ();
while (list.hasNext ())
	{
	value = (Value)list.next ();
	System.out.println
		(value.Type_Name () + ": " + value);
	}
}


}
