#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;

use Classes::User;

use CGI;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';

our $CurUser = User->new()->auth();

our %conf = ();      # configuration directives
our %miss = ();      # missing Modules (optional ones)
our $cgi = '';       # CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = ' - Top '.$conf{'nb_topattack*s'}.' Attack list';
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

my ( @labels, @values );

my $Statement = 'SELECT count(name) as cnt,name FROM Prelude_Classification GROUP BY name ORDER BY cnt DESC LIMIT '.$conf{'nb_topattack*s'}.';';
my $Sth = $dbh->prepare( $Statement );
$Sth->execute();

while( my $HashRef = $Sth->fetchrow_hashref() )
{
	push @labels, $HashRef->{'name'};
	push @values, $HashRef->{'cnt'};
}
$Sth->finish();

if ( ! $cgi->param( 'backend' ) ) {$cgi->param( 'backend', $conf{'default_backend'} );};

if ( $cgi->param( 'backend' ) eq 'HTML' )
{
	print "<table class=\"bordered\" width=\"75%\" align=\"center\" border=\"1\">\n";
	print "  <tr>\n";
	print "    <th align=\"center\" width=\"1%\">AttackNb&nbsp;</th>\n";
	print "    <th align=\"center\">&nbsp;Attack name</th>\n";
	print "  </tr>\n";

	for( my $cnt = 0 ; $cnt <= $#values ; $cnt ++ )
	{
		print "  <tr>";
		print "<td align=\"center\">".$values[$cnt]."&nbsp;</td>";
		print "<td>";
		print "<a href=\"Filters".$conf{'extension'}.'?load='.url_encode( 'defaults/eqClassification.name' )."&amp;valA=".url_encode( $labels[$cnt] )."&amp;timelimit=10Y\">".$labels[$cnt].')</a>';
		print "</td>";
		print "</tr>\n";
	}

	print "</table>\n";
}

if ( $cgi->param( 'backend' ) eq 'GD' )
{
	eval( 'require GD::Graph::pie' ) || ( $miss{'GD::Graph'} = 1 );

	if ( $miss{'GD::Graph'} )
	{
		error( 'No graphics because module GD::Graph is missing' );
	}
	else
	{
		require 'Functions/pie.pl';

		my @data = ( [@labels], [@values] );
		&piechart( \@data, 'top attacks', 'generated/Images/TopAttacks.png' );
		undef @data;

		print "<br><center><img src=\"generated/Images/TopAttacks.png\" alt=\"\"></center>";
	}
}

if ( $cgi->param( 'backend' ) eq 'PS' )
{
	require 'Functions/ps.pl';

	our $PS_Title = "Top $conf{'nb_topattack*s'} Attacks";

	my @data = ( [@labels], [@values], [] );
	my $res = &postscript( \@data, 'piechart.ps', 'generated/PostScript/TopAttacks.ps', 900 );
	if ( $res )
	{
		`$conf{'gs_path'} -sDEVICE=jpeg -dNOPAUSE -dBATCH -dGraphicsAlphaBits=4 -dTextAlphaBits=4 -sOutputFile="generated/Images/TopAttacks.jpg" generated/PostScript/TopAttacks.ps`;

		unlink 'generated/PostScript/TopAttacks.ps';

		print "<br><center><img src=\"generated/Images/TopAttacks.jpg\" alt=\"\"></center>";
	}
}

ParseComponent( 'CommonFooter' );
