/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

%{
#include <src/messages/messages/compilateur/global.h>

#include <src/messages/messages/compilateur/localisationfichier.h>

#include <src/messages/messages/compilateur/arbreidentifiant.h>
#include <src/messages/messages/compilateur/listemessage.h>

extern DescripteurFichier yyin;
LocalisationFichier *localisation;

Chaine racinesources;

void yyerror();

extern int yylex();

Chaine nomfichier;
Chaine nomfonctionmessage;
Chaine nomfonctionlocalisation;
Chaine nomfonctionparametres;

ArbreIdentifiant langue;
ArbreIdentifiant charset;
ArbreIdentifiant message;

ListeCharset *listecharset;
ListeMessage *listemessage;
ListeTexte *listetexte;
ListeParametre *listeparametre;


#define YYDEBUG 1
#define TAILLENOMFICHIER	128
%}

%union	{	Chaine _Chaine;
		Entier _Entier;
	}

%token TOKEN_OUTPUT
%token TOKEN_FUNCTION
%token TOKEN_LANG
%token TOKEN_CHARSET
%token TOKEN_MESG
%token <_Entier> TOKEN_PARAM
%token TOKEN_ESPACE
%token TOKEN_TAB
%token TOKEN_DIESE
%token TOKEN_ACCOUV
%token TOKEN_ACCFER
%token <_Chaine> TOKEN_PARAM_NOM
%token <_Chaine> TOKEN_PARAM_FICHIER
%token TOKEN_FIN
%token TOKEN_DEFAUT_LANG
%token TOKEN_DEFAUT_CHARSET
%token TOKEN_DEFAUT_MESG
%token <_Chaine> TOKEN_TEXTE

%type <_Chaine> nomfichier

%type <_Chaine> mot
%type <_Chaine> parametre
%type <_Chaine> default_lang
%type <_Chaine> default_charset

%start fichier

%parse-param {ListeLangue **listelangue}

%%

fichier: output functionmessage functionlocalisation functionparametres liste_lang default_lang
{
	DEBUTZONESECURISEE
	SECURISE(listelangue_ajout_langue(listelangue,$6,NULL));
	FINZONESECURISEE
};

output: TOKEN_OUTPUT nomfichier
{
	nomfichier=$2;
};

nomfichier: TOKEN_PARAM_NOM
{
	$$=$1;
}
|	TOKEN_PARAM_FICHIER
{
	$$=$1;
};

functionmessage: TOKEN_FUNCTION TOKEN_PARAM_NOM
{
	nomfonctionmessage=$2;
};

functionlocalisation: TOKEN_FUNCTION TOKEN_PARAM_NOM
{
	nomfonctionlocalisation=$2;
};

functionparametres: TOKEN_FUNCTION TOKEN_PARAM_NOM
{
	nomfonctionparametres=$2;
};

liste_lang:
{
	DEBUTZONESECURISEE
	SECURISE(listelangue_initialisation(listelangue));
	FINZONESECURISEE
}
|	liste_lang lang
{
};

lang: TOKEN_LANG TOKEN_PARAM_NOM liste_charset default_charset TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listecharset_ajout_charset(&listecharset,$4,NULL));
	SECURISE(listelangue_ajout_langue(listelangue,$2,listecharset));
	SECURISE(arbreidentifiant_ajout_identifiant(&langue,$2,NULL));
	FINZONESECURISEE
}
|	TOKEN_LANG TOKEN_PARAM_NOM TOKEN_PARAM_NOM liste_charset default_charset TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listecharset_ajout_charset(&listecharset,$5,NULL));
	SECURISE(listelangue_ajout_langue(listelangue,$2,listecharset));
	SECURISE(arbreidentifiant_ajout_identifiant(&langue,$2,$3));
	FINZONESECURISEE
}


liste_charset:
{
	DEBUTZONESECURISEE
	SECURISE(listecharset_initialisation(&listecharset));
	FINZONESECURISEE
}
|	liste_charset charset
{
};

charset: TOKEN_CHARSET TOKEN_PARAM_NOM liste_mesg default_mesg TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listemessage_ajout_message(&listemessage,NULL,listetexte,listeparametre));
	SECURISE(listecharset_ajout_charset(&listecharset,$2,listemessage));
	SECURISE(arbreidentifiant_ajout_identifiant(&charset,$2,NULL));
	FINZONESECURISEE
}
|	TOKEN_CHARSET TOKEN_PARAM_NOM TOKEN_PARAM_NOM liste_mesg default_mesg TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listemessage_ajout_message(&listemessage,NULL,listetexte,listeparametre));
	SECURISE(listecharset_ajout_charset(&listecharset,$2,listemessage));
	SECURISE(arbreidentifiant_ajout_identifiant(&charset,$2,$3));
	FINZONESECURISEE
};

liste_mesg:
{
	DEBUTZONESECURISEE
	SECURISE(listemessage_initialisation(&listemessage));
	FINZONESECURISEE
}
|	liste_mesg mesg
{
};

mesg: TOKEN_MESG TOKEN_PARAM_NOM message TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listemessage_ajout_message(&listemessage,$2,listetexte,listeparametre));
	SECURISE(arbreidentifiant_ajout_identifiant(&message,$2,NULL));
	FINZONESECURISEE
}
|	TOKEN_MESG TOKEN_PARAM_NOM TOKEN_PARAM_NOM message TOKEN_FIN
{
	DEBUTZONESECURISEE
	SECURISE(listemessage_ajout_message(&listemessage,$2,listetexte,listeparametre));
	SECURISE(arbreidentifiant_ajout_identifiant(&message,$2,$3));
	FINZONESECURISEE
};

message:
{
	DEBUTZONESECURISEE
	SECURISE(listetexte_initialisation(&listetexte));
	SECURISE(listeparametre_initialisation(&listeparametre));
	FINZONESECURISEE
}
|	message mot
{
	DEBUTZONESECURISEE
	SECURISE(listetexte_ajout_texte(&listetexte,$2,TYPETEXTE_TEXTE));
	FINZONESECURISEE
}
|	message parametre
{
	DEBUTZONESECURISEE
	SECURISE(listetexte_ajout_texte(&listetexte,$2,TYPETEXTE_PARAMETRE));
	FINZONESECURISEE
};

mot:	TOKEN_TEXTE
{
	$$=yylval._Chaine;
}
|	TOKEN_ESPACE
{
	$$=strdup(" ");
}
|	TOKEN_TAB
{
	$$=strdup("\t");
}
|	TOKEN_DIESE
{
	$$=strdup("#");
}
|	TOKEN_ACCOUV
{
	$$=strdup("{");
}
|	TOKEN_ACCFER
{
	$$=strdup("}");
};

parametre:	TOKEN_PARAM TOKEN_PARAM_NOM
{
	char format[129];
	TypeParametre type;
	snprintf(format,128,"%%%s",$2);
	$$=strdup(format);
	switch($$[strlen($$)-1])
	{
		case 'd':
		case 'i':
		case 'o':
		case 'u':
		case 'x':
		case 'X':
			type=TYPEPARAMETRE_ENTIER;
			break;
		case 'f':
		case 'F':
			type=TYPEPARAMETRE_FLOTTANT;
			break;
		case 'e':
		case 'E':
		case 'g':
		case 'G':
			type=TYPEPARAMETRE_DOUBLE;
			break;
		case 'c':
			type=TYPEPARAMETRE_CARACTERE;
			break;
		case 's':
			type=TYPEPARAMETRE_CHAINE;
			break;
		default:
			type=TYPEPARAMETRE_POINTEUR;
			break;
	}
	DEBUTZONESECURISEE
	SECURISE(listeparametre_ajout_parametre(&listeparametre,$1,type));
	FINZONESECURISEE
};

default_mesg: TOKEN_DEFAUT_MESG message TOKEN_FIN
{ /* Pas oublier de renvoyer le ListeTexte ! */
};

default_charset: TOKEN_DEFAUT_CHARSET TOKEN_PARAM_NOM
{
	$$=$2;
};

default_lang: TOKEN_DEFAUT_LANG TOKEN_PARAM_NOM
{
	$$=$2;
};

%%

void yyerror()
{
	printf("Erreur de syntaxe!\n");
}

int main(int argc , char *argv[])
{
	Entier indice;
	char nomfichiercomplet[TAILLENOMFICHIER+1];
	DescripteurFichier entree , sortie;
	Chaine identifiant;
	Chaine detection;
	Chaine vardefine , vardefineindice;
	Booleen vide , debut;
	Caractere *caractere;
	ArbreIdentifiant detectionlangue;
	ArbreIdentifiant detectioncharset;
	ArbreIdentifiant parametresmessage;
	ListeLangue *listelangue;
	ListeLangue *pointeurlangue;
	ListeCharset *pointeurcharset;
	ListeMessage *pointeurmessage;
	ListeTexte *pointeurtexte;
	ListeParametre *pointeurparametre;
	DEBUTZONESECURISEE
	yydebug=0;
	SECURISE(arbreidentifiant_initialisation(&langue));
	SECURISE(arbreidentifiant_initialisation(&charset));
	SECURISE(arbreidentifiant_initialisation(&message));
	SECURISE(arbreidentifiant_initialisation(&detectionlangue));
	SECURISE(arbreidentifiant_initialisation(&detectioncharset));
	//SECURISE(listelangue_initialisation(&listelangue));
	if(argc<1)
	{
		printf("Il manque le rpertoire des sources...\n");
		return 1;
	}
	racinesources=argv[1];
	vide=VRAI;
	for(indice=2 ; argv[indice]!=NULL ; indice++)
	{
		Chaine fichier;
		if((fichier=(Chaine)(malloc(strlen(racinesources)+strlen(argv[indice])+1)))==NULL)
			return 1;
		strcpy(fichier,racinesources);
		strcat(fichier,argv[indice]);
		if((entree=fopen(fichier,"r"))==NULL)
		{
			printf("On saute le fichier %s !\n",fichier);
		}
		else
		{
			SECURISE(localisationfichier_initialisation(&localisation));
			SECURISE(localisationfichier_ajout(&localisation,fichier,NULL,entree,0));
			yyin=entree;
			if(yyparse(&listelangue)!=0)
			{
				SECURISE(localisationfichier_destruction(&localisation));
				free(fichier);
				return 1;
			}
			vide=FAUX;
			SECURISE(localisationfichier_destruction(&localisation));
		}
		free(fichier);
	}
	if(vide==VRAI)
	{
		printf("Aucun fichier n'a pu tre analys !\n");
		return 1;
	}
	/* Aprs avoir lu l'entre et l'avoir stock,
	 * on gnre les fichiers de sortie.
	 */
	SECURISE(arbreidentifiant_copie(&langue,&detectionlangue));
	SECURISE(arbreidentifiant_copie(&charset,&detectioncharset));
	SECURISE(arbreidentifiant_copie(&message,&parametresmessage));
	snprintf(nomfichiercomplet,TAILLENOMFICHIER,"%s.h",nomfichier);
	if((sortie=fopen(nomfichiercomplet,"w"))==NULL)
	{
		printf("Ne peut crire dans %s...\n",nomfichiercomplet);
		return 1;
	}
	vardefine=strdup(nomfichier);
	for(vardefineindice=vardefine ; (*vardefineindice)!='\0' ; vardefineindice++)
		if(((*vardefineindice)>='a')&&((*vardefineindice)<='z'))
			*vardefineindice=(*vardefineindice)-'a'+'A';
	fprintf(sortie,
"/*\n\
 *  PlanFacile (Easy plan, in french) is a small tool to help people to\n\
 *  write a document on a particular subject.\n\
 *  Copyright (C) 2005  Julien BRUGUIER\n\
 *\n\
 *  This program is free software; you can redistribute it and/or modify\n\
 *  it under the terms of the GNU General Public License as published by\n\
 *  the Free Software Foundation; version 2 of the License.\n\
 *\n\
 *  This program is distributed in the hope that it will be useful,\n\
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
 *  GNU General Public License for more details.\n\
 *\n\
 *  You should have received a copy of the GNU General Public License\n\
 *  along with this program; if not, write to the Free Software\n\
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n\
 */\n\n\
#ifndef __%s__\n\
#define __%s__\n\n\
#include <src/global/global.h>\n\n\
#include <src/messages/messages/sources/messageparametres.h>\n\n\
",vardefine,vardefine);
	free(vardefine);
	fprintf(sortie,
"typedef enum\n\
{\n\tLANGUE_INCONNUE");
	for(;;)
	{
		SECURISE(arbreidentifiant_vide(&langue,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&langue,&identifiant,&detection));
		fprintf(sortie,",\n\t%s",identifiant);
		free(detection);
	}
	fprintf(sortie,
"\n} CONTENEUR_SCALAIRE(Langue);\n\
/* Dfinition des diffrentes langues disponibles\n\
 * pour l'affichage des messages de planfacile.\n\
 */\n\n");
	fprintf(sortie,
"typedef enum\n\
{\n\tCHARSET_INCONNU");
	for(;;)
	{
		SECURISE(arbreidentifiant_vide(&charset,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&charset,&identifiant,&detection));
		fprintf(sortie,",\n\t%s",identifiant);
		free(detection);
	}
	fprintf(sortie,
"\n} CONTENEUR_SCALAIRE(Charset);\n\
/* Dfinition des diffrents charsets disponibles\n\
 * pour l'affichage des messages de planfacile.\n\
 */\n\n");
	fprintf(sortie,
"typedef enum\n\
{\n\tMESSAGE_INCONNU");
	for(;;)
	{
		SECURISE(arbreidentifiant_vide(&message,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&message,&identifiant,&detection));
		fprintf(sortie,",\n\t%s",identifiant);
		free(detection);
	}
	fprintf(sortie,
"\n} CONTENEUR_SCALAIRE(Message);\n\
/* Dfinition des diffrents messages disponibles\n\
 * pour l'affichage des messages de planfacile.\n\
 */\n\n\
#include <src/donnees/general/general.h>\n\n");
	fprintf(sortie,
"Resultat %s(TRAVAIL(General) general , TRAVAIL_SCALAIRE(DescripteurFichier) sortie , TRAVAIL_SCALAIRE(Message) message , TRAVAIL(MessageParametres) messageparametres);\n\
/* Ralise un affichage sur la sortie de message indique\n\
 * dans la structure general. Cette structure contient\n\
 * galement la localisation en vigueur.\n\
 */\n\n\
Resultat %s(TRAVAIL(General)  general);\n\
/* Dtermine la localisation  partir de la variable\n\
 * d'environnement $LANG. La dtermination sera\n\
 * influence par le jeu de langues et de charsets\n\
 * dfinis dans planfacile.\n\
 */\n\n\
Resultat %s(TRAVAIL_SCALAIRE(Message) message , REFERENCE_SCALAIRE(Chaine) parametres);\n\
/* Renvoie les types des paramtres d'un message,\n\
 * dans leur ordre d'apparition.\n\
 * Le chaine en question n'a pas  tre libre.\n\
 */\n\n",nomfonctionmessage,nomfonctionlocalisation,nomfonctionparametres);
	fprintf(sortie,"#endif\n");
	fclose(sortie);
	SECURISE(arbreidentifiant_destruction(&langue));
	SECURISE(arbreidentifiant_destruction(&charset));
	SECURISE(arbreidentifiant_destruction(&message));
	snprintf(nomfichiercomplet,TAILLENOMFICHIER,"%s.c",nomfichier);
	if((sortie=fopen(nomfichiercomplet,"w"))==NULL)
	{
		printf("Ne peut crire dans %s...\n",nomfichiercomplet);
		return 1;
	}
	fprintf(sortie,
"/*\n\
 *  PlanFacile (Easy plan, in french) is a small tool to help people to\n\
 *  write a document on a particular subject.\n\
 *  Copyright (C) 2005  Julien BRUGUIER\n\
 *\n\
 *  This program is free software; you can redistribute it and/or modify\n\
 *  it under the terms of the GNU General Public License as published by\n\
 *  the Free Software Foundation; version 2 of the License.\n\
 *\n\
 *  This program is distributed in the hope that it will be useful,\n\
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
 *  GNU General Public License for more details.\n\
 *\n\
 *  You should have received a copy of the GNU General Public License\n\
 *  along with this program; if not, write to the Free Software\n\
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n\
 */\n\n\
#include \"%s.h\"\n\n\
",nomfichier);
	fprintf(sortie,
"Resultat %s(TRAVAIL(General) general , TRAVAIL_SCALAIRE(DescripteurFichier) sortie , TRAVAIL_SCALAIRE(Message) message , TRAVAIL(MessageParametres) messageparametres)\n\
{\n\
\t/* Ralise un affichage sur la sortie de message indique\n\
\t * dans la structure general. Cette structure contient\n\
\t * galement la localisation en vigueur.\n\
\t */\n\
\tSTOCKAGE(General) temporaire;\n\
\tTRAVAIL_SCALAIRE(Langue) langue;\n\
\tTRAVAIL_SCALAIRE(Charset) charset;\n\
\tDEBUTZONESECURISEE\n\
\tSECURISE(environnement_lecture_langue(CHAMP_TRAVAIL(general , environnement),R_T_(langue)));\n\
\tSECURISE(environnement_lecture_charset(CHAMP_TRAVAIL(general , environnement),R_T_(charset)));\n",nomfonctionmessage);
	fprintf(sortie,
"\tswitch(langue)\n\
\t{\n");
	for(pointeurlangue=listelangue ; pointeurlangue!=NULL ; pointeurlangue=pointeurlangue->suivant)
	{
		if(pointeurlangue->suivant==NULL)
		{
			fprintf(sortie,
"\t\tdefault:\n\
\t\t\ttemporaire=NULL;\n\
\t\t\tSECURISE(general_copie_speciale(general,T_S(temporaire)));\n\
\t\t\tSECURISE(environnement_definition_langue(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(%s)));\n\
\t\t\tSECURISE(%s(T_S(temporaire),sortie,message,messageparametres));\n\
\t\t\tSECURISE(general_destruction(T_S(temporaire)));\n\
\t\t\tbreak;\n",pointeurlangue->langue,nomfonctionmessage);
		}
		else
		{
			fprintf(sortie,
"\t\tcase T_S_(%s):\n\
\t\t\tswitch(charset)\n\
\t\t\t{\n",pointeurlangue->langue);
			for(pointeurcharset=pointeurlangue->charset ; pointeurcharset!=NULL ; pointeurcharset=pointeurcharset->suivant)		
			{
				if(pointeurcharset->suivant==NULL)
				{
					fprintf(sortie,
"\t\t\t\tdefault:\n\
\t\t\t\t\ttemporaire=NULL;\n\
\t\t\t\t\tSECURISE(general_copie_speciale(general,T_S(temporaire)));\n\
\t\t\t\t\tSECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(%s)));\n\
\t\t\t\t\tSECURISE(%s(T_S(temporaire),sortie,message,messageparametres));\n\
\t\t\t\t\tSECURISE(general_destruction(T_S(temporaire)));\n\
\t\t\t\t\tbreak;\n",pointeurcharset->charset,nomfonctionmessage);
				}
				else
				{
					fprintf(sortie,
"\t\t\t\tcase T_S_(%s):\n\
\t\t\t\t\tswitch(message)\n\
\t\t\t\t\t{\n",pointeurcharset->charset);
					for(pointeurmessage=pointeurcharset->message ; pointeurmessage!=NULL ; pointeurmessage=pointeurmessage->suivant)
					{
						if(pointeurmessage->suivant==NULL)
						{
							fprintf(sortie,"\t\t\t\t\t\tdefault:\n");
						}
						else
						{
							fprintf(sortie,"\t\t\t\t\t\tcase T_S_(%s):\n",pointeurmessage->message);
						}
						fprintf(sortie,"\t\t\t\t\t\t\tfprintf(sortie,\"");
						for(pointeurtexte=pointeurmessage->texte ; pointeurtexte!=NULL ; pointeurtexte=pointeurtexte->suivant)
							if(pointeurtexte->type==TYPETEXTE_TEXTE)
							{
								for(caractere=pointeurtexte->texte ; (*caractere)!='\0' ; caractere++)
								{
									switch(*caractere)
									{
										case '%':
											fprintf(sortie,"%%%%");
											break;
										case '"':
											fprintf(sortie,"\\%c",*caractere);
											break;
										default:
											fprintf(sortie,"%c",*caractere);
											break;
									}
								}
							}
							else
							{
								fprintf(sortie,"%s",pointeurtexte->texte);
							}
						fprintf(sortie,"\"");
						for(pointeurparametre=pointeurmessage->parametre ; pointeurparametre!=NULL ; pointeurparametre=pointeurparametre->suivant)
						{
							fprintf(sortie,",\n\t\t\t\t\t\t\t\t");
							switch(pointeurparametre->typeparametre)
							{
								case TYPEPARAMETRE_ENTIER:
									fprintf(sortie,"*((int*)(");
									break;
								case TYPEPARAMETRE_FLOTTANT:
									fprintf(sortie,"*((float*)(");
									break;
								case TYPEPARAMETRE_DOUBLE:
									fprintf(sortie,"*((double*)(");
									break;
								case TYPEPARAMETRE_CARACTERE:
									fprintf(sortie,"*((char*)(");
									break;
								case TYPEPARAMETRE_CHAINE:
									fprintf(sortie,"((char*)(");
									break;
								case TYPEPARAMETRE_POINTEUR:
								default:
									fprintf(sortie,"(void*)((");
									break;
							}
							fprintf(sortie,"T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(%d)))))",pointeurparametre->parametre);
						}
						fprintf(sortie,");\n\t\t\t\t\t\t\tbreak;\n");
					}
					fprintf(sortie,
"\t\t\t\t\t}\n\
\t\t\t\t\tbreak;\n");
				}
			}
			fprintf(sortie,
"\t\t\t}\n\
\t\t\tbreak;\n");
		}
	}
	fprintf(sortie,"\t}\n\
\tFINZONESECURISEE\n\
\treturn RESULTAT_OK;\n}\n\n");
	fprintf(sortie,
"Resultat %s(TRAVAIL(General) general)\n\
{\n\
\t/* Dtermine la localisation  partir de la variable\n\
\t * d'environnement $LANG. La dtermination sera\n\
\t * influence par le jeu de langues et de charsets\n\
\t * dfinis dans planfacile.\n\
\t */\n",nomfonctionlocalisation);
	fprintf(sortie,
"\tSTOCKAGE_SCALAIRE(Chaine) envlang;\n\
\tSTOCKAGE_SCALAIRE(Chaine) localeslangue=NULL;\n\
\tSTOCKAGE_SCALAIRE(Chaine) localespays=NULL;\n\
\tSTOCKAGE_SCALAIRE(Chaine) localescharset=NULL;\n\
\tSTOCKAGE_SCALAIRE(Chaine) locales;\n\
\tCOREFERENCE_SCALAIRE(Caractere) indice;\n\
\tDEBUTZONESECURISEE\n\
\tSECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_INCONNUE)));\n\
\tSECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(CHARSET_INCONNU)));\n\
\tif((envlang=getenv(T_S_(\"LANG\")))==NULL)\n\
\t\treturn RESULTAT_OK;\n\
\tlocales=strdup(T_S_(envlang));\n\
\tlocaleslangue=locales;\n\
\tfor(indice=((COREFERENCE_SCALAIRE(Caractere))(locales)) ; S_C_(indice)!='\\0' ; indice++)\n\
\t\tswitch(T_S_(S_C_(indice)))\n\
\t\t{\n\
\t\t\tcase T_S_('_'):\n\
\t\t\t\tS_C_(indice)='\\0';\n\
\t\t\t\tlocalespays=((STOCKAGE_SCALAIRE(Chaine))(indice+1));\n\
\t\t\t\tbreak;\n\
\t\t\tcase T_S_('.'):\n\
\t\t\t\tS_C_(indice)='\\0';\n\
\t\t\t\tlocalescharset=((STOCKAGE_SCALAIRE(Chaine))(indice+1));\n\
\t\t\tdefault:\n\
\t\t\t\tbreak;\n\
\t\t}\n\
\tif(localeslangue!=NULL)\n\
\t{\n");
	debut=VRAI;
	for( ; ; )
	{
		SECURISE(arbreidentifiant_vide(&detectionlangue,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&detectionlangue,&identifiant,&detection));
		if(detection==NULL)
			continue;
		if(debut==VRAI)
		{
			fprintf(sortie,"\t\tif(");
			debut=FAUX;
		}
		else
		{
			fprintf(sortie,"\t\telse if(");
		}
		fprintf(sortie,"S_T_(strstr(localeslangue,T_S_(\"%s\")))!=NULL)\n\
\t\t{\n\
\t\t\tSECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(%s)));\n\
\t\t}\n",detection,identifiant);
	}
	fprintf(sortie,"\t}\n");
	fprintf(sortie,
"\tif(localescharset!=NULL)\n\
\t{\n");
	debut=VRAI;
	for( ; ; )
	{
		SECURISE(arbreidentifiant_vide(&detectioncharset,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&detectioncharset,&identifiant,&detection));
		if(detection==NULL)
			continue;
		if(debut==VRAI)
		{
			fprintf(sortie,"\t\tif(");
			debut=FAUX;
		}
		else
		{
			fprintf(sortie,"\t\telse if(");
		}
		fprintf(sortie,"S_T_(strstr(localescharset,T_S_(\"%s\")))!=NULL)\n\
\t\t{\n\
\t\t\tSECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(%s)));\n\
\t\t}\n",detection,identifiant);
	}
	fprintf(sortie,
"\t}\n\
\tfree(locales);\n\
\tFINZONESECURISEE\n\
\treturn RESULTAT_OK;\n\
}\n\n");
	fprintf(sortie,
"Resultat %s(TRAVAIL_SCALAIRE(Message) message , REFERENCE_SCALAIRE(Chaine) parametres)\n\
{\n\
\t/* Renvoie les types des paramtres d'un message,\n\
\t * dans leur ordre d'apparition.\n\
\t * Le chaine en question n'a pas  tre libre.\n\
\t */\n",nomfonctionparametres);
	fprintf(sortie,
"\tswitch(message)\n\
\t{\n\
");
	for( ; ; )
	{
		SECURISE(arbreidentifiant_vide(&parametresmessage,&vide));
		if(vide==VRAI)
			break;
		SECURISE(arbreidentifiant_retrait_identifiant(&parametresmessage,&identifiant,&detection));
		if(detection==NULL)
			detection="";
		fprintf(sortie,"\t\tcase T_S_(%s):\n\t\t\tT_R_(parametres)=T_S_(\"%s\");\n\t\t\tbreak;\n",identifiant,detection);
	}
	fprintf(sortie,
"\t\tdefault:\n\
\t\t\tT_R_(parametres)=\"\";\n\
\t\t\tbreak;\n\
\t}\n\
\treturn RESULTAT_OK;\n\
}\n\n");
	fclose(sortie);
	free(nomfichier);
	free(nomfonctionmessage);
	free(nomfonctionlocalisation);
	free(nomfonctionparametres);
	SECURISE(listelangue_destruction(&listelangue));
	SECURISE(arbreidentifiant_destruction(&detectionlangue));
	SECURISE(arbreidentifiant_destruction(&detectioncharset));
	SECURISE(arbreidentifiant_destruction(&parametresmessage));
	FINZONESECURISEE
	return 0;
}
