"""
Preferences Editor Dialog
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: PreferencesDialog.py 89 2004-09-11 18:58:51Z henning $

from Tkinter import *
from PropertyEditor import PropertyEditor
from InputWidgets import TextEdit, TextComboEdit, FilenameEdit, FontEdit
import Preferences
import ToolTip
import vcard
import types

class PrefWrapperVar:
    "Wraps a Preference Option"
    def __init__(self, optname, default='', type=None):
        self.optname = optname
        self.default = default
        self.type = type
    def set(self, val):
        Preferences.set(self.optname, val)
    def get(self):
        val = Preferences.get(self.optname, self.type)
        if val is None: return self.default
        else: return val

class FilenamePropEdit(FilenameEdit):
    def __init__(self, master, title, descr):
        FilenameEdit.__init__(self, master)
        ToolTip.ToolTip(self, descr)

class FontPropEdit(FontEdit):
    def __init__(self, master, title, descr):
        FontEdit.__init__(self, master)
        ToolTip.ToolTip(self, descr)

class vCardFieldPropEdit(TextComboEdit):
    def __init__(self, master, title, descr):
        TextComboEdit.__init__(self, master, nomanualedit=True)
        ToolTip.ToolTip(self.component('entry'), descr)
        self.setlist(vcard.FIELDNAMES)

class PreferencesDialog(PropertyEditor):
    # (Type, Title, Helptext)
    propdefs = [
        ('Label', '', 'You must restart PyCoCuMa for the changes to take effect.'),
        ('Page', 'General', ''),
        ('vCardField', 'Contact List Displayfield', 'default: DisplayName'),
        ('vCardField', 'Contact List Sortby', 'default: SortName'),
        ('Page', 'Look & Feel', ''),
        ('Font', 'General Font', 'application wide font'),
        ('Text', 'Speed Buttons', 'These little icons on top of the window'),
        ('Page', 'QuickFinder', ''),
        ('Checkbox', 'Start centered', 'Start QuickFinder centered on desktop'),
        ('Label', '', '(Start the Finder with the "--finder" commandline option.)'),
        ('Page', 'External Programs', ''),
        ('Filename', 'URL Viewer Program (Web Browser)', 'leave empty to use platform\'s default browser'),
        ('Filename', 'Mail-To Program', 'your email composer application'),
        ]
    def __init__(self, master):
        PropertyEditor.__init__(self, master=master,
            propdefs=self.propdefs, title='Edit Preferences',
            editclasses={'vCardField':vCardFieldPropEdit,
                         'Filename':FilenamePropEdit,
                         'Font':FontPropEdit})
        self.bindto([
            PrefWrapperVar('client.contactlist_displayfield', default='DisplayName'),
            PrefWrapperVar('client.contactlist_sortby', default='SortName'),
            PrefWrapperVar('client.font', default=('',''), type=types.ListType),
            PrefWrapperVar('client.topbar', default='newContact, delContact, saveContact, SEP, duplicateContact, exportContact'),
            PrefWrapperVar('client.finder_centered', default='yes'),
            PrefWrapperVar('client.url_viewer', default=''),
            PrefWrapperVar('client.mailto_program', default='')
            ])


if __name__ == "__main__":
    tk = Tk()
    dlg = PreferencesDialog(tk)
    dlg.show()
    tk.mainloop()
