/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class Zip64ExtendedInformationExtraField
implements ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(1);
    private static final int WORD = 4;
    private static final int DWORD = 8;
    private ZipEightByteInteger size;
    private ZipEightByteInteger compressedSize;
    private ZipEightByteInteger relativeHeaderOffset;
    private ZipLong diskStart;

    public Zip64ExtendedInformationExtraField() {
    }

    public Zip64ExtendedInformationExtraField(ZipEightByteInteger size, ZipEightByteInteger compressedSize) {
        this(size, compressedSize, null, null);
    }

    public Zip64ExtendedInformationExtraField(ZipEightByteInteger size, ZipEightByteInteger compressedSize, ZipEightByteInteger relativeHeaderOffset, ZipLong diskStart) {
        if (size == null) {
            throw new IllegalArgumentException("size must not be null");
        }
        if (compressedSize == null) {
            throw new IllegalArgumentException("compressedSize must not be null");
        }
        this.size = size;
        this.compressedSize = compressedSize;
        this.relativeHeaderOffset = relativeHeaderOffset;
        this.diskStart = diskStart;
    }

    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public ZipShort getLocalFileDataLength() {
        return this.getCentralDirectoryLength();
    }

    public ZipShort getCentralDirectoryLength() {
        return new ZipShort(16 + (this.relativeHeaderOffset != null ? 8 : 0) + (this.diskStart != null ? 4 : 0));
    }

    public byte[] getLocalFileDataData() {
        return this.getCentralDirectoryData();
    }

    public byte[] getCentralDirectoryData() {
        byte[] data = new byte[this.getCentralDirectoryLength().getValue()];
        this.addSizes(data);
        int off = 16;
        if (this.relativeHeaderOffset != null) {
            System.arraycopy(this.relativeHeaderOffset.getBytes(), 0, data, off, 8);
            off += 8;
        }
        if (this.diskStart != null) {
            System.arraycopy(this.diskStart.getBytes(), 0, data, off, 4);
            off += 4;
        }
        return data;
    }

    public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
        if (length < 16) {
            throw new ZipException("Zip64 extended information must contain both size values in the local file header.");
        }
        this.size = new ZipEightByteInteger(buffer, offset);
        this.compressedSize = new ZipEightByteInteger(buffer, offset += 8);
        offset += 8;
        int remaining = length - 16;
        if (remaining >= 8) {
            this.relativeHeaderOffset = new ZipEightByteInteger(buffer, offset);
            offset += 8;
            remaining -= 8;
        }
        if (remaining >= 4) {
            this.diskStart = new ZipLong(buffer, offset);
            offset += 4;
            remaining -= 4;
        }
    }

    public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) throws ZipException {
        if (length >= 28) {
            this.parseFromLocalFileData(buffer, offset, length);
        } else if (length % 8 == 4) {
            this.diskStart = new ZipLong(buffer, offset + length - 4);
        }
    }

    public ZipEightByteInteger getSize() {
        return this.size;
    }

    public ZipEightByteInteger getCompressedSize() {
        return this.compressedSize;
    }

    public ZipEightByteInteger getRelativeHeaderOffset() {
        return this.relativeHeaderOffset;
    }

    public ZipLong getDiskStartNumber() {
        return this.diskStart;
    }

    private void addSizes(byte[] data) {
        System.arraycopy(this.size.getBytes(), 0, data, 0, 8);
        System.arraycopy(this.compressedSize.getBytes(), 0, data, 8, 8);
    }
}

