# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .webtests_resource import WebtestsResource


class WebTest(WebtestsResource):
    """An Application Insights web test definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param kind: The kind of web test that this web test watches. Choices are
     ping and multistep. Possible values include: 'ping', 'multistep'. Default
     value: "ping" .
    :type kind: str or ~azure.mgmt.applicationinsights.models.WebTestKind
    :param synthetic_monitor_id: Required. Unique ID of this WebTest. This is
     typically the same value as the Name field.
    :type synthetic_monitor_id: str
    :param web_test_name: Required. User defined name if this WebTest.
    :type web_test_name: str
    :param description: Purpose/user defined descriptive test for this
     WebTest.
    :type description: str
    :param enabled: Is the test actively being monitored.
    :type enabled: bool
    :param frequency: Interval in seconds between test runs for this WebTest.
     Default value is 300. Default value: 300 .
    :type frequency: int
    :param timeout: Seconds until this WebTest will timeout and fail. Default
     value is 30. Default value: 30 .
    :type timeout: int
    :param web_test_kind: Required. The kind of web test this is, valid
     choices are ping and multistep. Possible values include: 'ping',
     'multistep'. Default value: "ping" .
    :type web_test_kind: str or
     ~azure.mgmt.applicationinsights.models.WebTestKind
    :param retry_enabled: Allow for retries should this WebTest fail.
    :type retry_enabled: bool
    :param locations: Required. A list of where to physically run the tests
     from to give global coverage for accessibility of your application.
    :type locations:
     list[~azure.mgmt.applicationinsights.models.WebTestGeolocation]
    :param configuration: An XML configuration specification for a WebTest.
    :type configuration:
     ~azure.mgmt.applicationinsights.models.WebTestPropertiesConfiguration
    :ivar provisioning_state: Current state of this component, whether or not
     is has been provisioned within the resource group it is defined. Users
     cannot change this value but are able to read from it. Values will include
     Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'synthetic_monitor_id': {'required': True},
        'web_test_name': {'required': True},
        'web_test_kind': {'required': True},
        'locations': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'WebTestKind'},
        'synthetic_monitor_id': {'key': 'properties.SyntheticMonitorId', 'type': 'str'},
        'web_test_name': {'key': 'properties.Name', 'type': 'str'},
        'description': {'key': 'properties.Description', 'type': 'str'},
        'enabled': {'key': 'properties.Enabled', 'type': 'bool'},
        'frequency': {'key': 'properties.Frequency', 'type': 'int'},
        'timeout': {'key': 'properties.Timeout', 'type': 'int'},
        'web_test_kind': {'key': 'properties.Kind', 'type': 'WebTestKind'},
        'retry_enabled': {'key': 'properties.RetryEnabled', 'type': 'bool'},
        'locations': {'key': 'properties.Locations', 'type': '[WebTestGeolocation]'},
        'configuration': {'key': 'properties.Configuration', 'type': 'WebTestPropertiesConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WebTest, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', "ping")
        self.synthetic_monitor_id = kwargs.get('synthetic_monitor_id', None)
        self.web_test_name = kwargs.get('web_test_name', None)
        self.description = kwargs.get('description', None)
        self.enabled = kwargs.get('enabled', None)
        self.frequency = kwargs.get('frequency', 300)
        self.timeout = kwargs.get('timeout', 30)
        self.web_test_kind = kwargs.get('web_test_kind', "ping")
        self.retry_enabled = kwargs.get('retry_enabled', None)
        self.locations = kwargs.get('locations', None)
        self.configuration = kwargs.get('configuration', None)
        self.provisioning_state = None
