# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TaskChannelList(ListResource):
    """  """

    def __init__(self, version, workspace_sid):
        """
        Initialize the TaskChannelList

        :param Version version: Version that contains the resource
        :param workspace_sid: The workspace_sid

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelList
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelList
        """
        super(TaskChannelList, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid,}
        self._uri = '/Workspaces/{workspace_sid}/TaskChannels'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams TaskChannelInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'],)

        return self._version.stream(page, limits['limit'], limits['page_limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists TaskChannelInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size,))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of TaskChannelInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelPage
        """
        params = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size,})

        response = self._version.page(
            'GET',
            self._uri,
            params=params,
        )

        return TaskChannelPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of TaskChannelInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return TaskChannelPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a TaskChannelContext

        :param sid: The sid

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        """
        return TaskChannelContext(self._version, workspace_sid=self._solution['workspace_sid'], sid=sid,)

    def __call__(self, sid):
        """
        Constructs a TaskChannelContext

        :param sid: The sid

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        """
        return TaskChannelContext(self._version, workspace_sid=self._solution['workspace_sid'], sid=sid,)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.TaskChannelList>'


class TaskChannelPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the TaskChannelPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param workspace_sid: The workspace_sid

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelPage
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelPage
        """
        super(TaskChannelPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TaskChannelInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        """
        return TaskChannelInstance(self._version, payload, workspace_sid=self._solution['workspace_sid'],)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.TaskChannelPage>'


class TaskChannelContext(InstanceContext):
    """  """

    def __init__(self, version, workspace_sid, sid):
        """
        Initialize the TaskChannelContext

        :param Version version: Version that contains the resource
        :param workspace_sid: The workspace_sid
        :param sid: The sid

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        """
        super(TaskChannelContext, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid, 'sid': sid,}
        self._uri = '/Workspaces/{workspace_sid}/TaskChannels/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch a TaskChannelInstance

        :returns: Fetched TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        """
        params = values.of({})

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return TaskChannelInstance(
            self._version,
            payload,
            workspace_sid=self._solution['workspace_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.TaskChannelContext {}>'.format(context)


class TaskChannelInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, workspace_sid, sid=None):
        """
        Initialize the TaskChannelInstance

        :returns: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        """
        super(TaskChannelInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'date_created': deserialize.iso8601_datetime(payload['date_created']),
            'date_updated': deserialize.iso8601_datetime(payload['date_updated']),
            'friendly_name': payload['friendly_name'],
            'sid': payload['sid'],
            'unique_name': payload['unique_name'],
            'workspace_sid': payload['workspace_sid'],
            'url': payload['url'],
        }

        # Context
        self._context = None
        self._solution = {'workspace_sid': workspace_sid, 'sid': sid or self._properties['sid'],}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TaskChannelContext for this TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelContext
        """
        if self._context is None:
            self._context = TaskChannelContext(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The date_created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date_updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def friendly_name(self):
        """
        :returns: The friendly_name
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def sid(self):
        """
        :returns: The sid
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def unique_name(self):
        """
        :returns: The unique_name
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def workspace_sid(self):
        """
        :returns: The workspace_sid
        :rtype: unicode
        """
        return self._properties['workspace_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch a TaskChannelInstance

        :returns: Fetched TaskChannelInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.task_channel.TaskChannelInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.TaskChannelInstance {}>'.format(context)
