# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ExportCustomJobList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, resource_type):
        """
        Initialize the ExportCustomJobList

        :param Version version: Version that contains the resource
        :param resource_type: The type of communication – Messages, Calls, Conferences, and Participants

        :returns: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobList
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobList
        """
        super(ExportCustomJobList, self).__init__(version)

        # Path Solution
        self._solution = {'resource_type': resource_type, }
        self._uri = '/Exports/{resource_type}/Jobs'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams ExportCustomJobInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ExportCustomJobInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ExportCustomJobInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ExportCustomJobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ExportCustomJobPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ExportCustomJobInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ExportCustomJobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ExportCustomJobPage(self._version, response, self._solution)

    def create(self, start_day, end_day, friendly_name, webhook_url=values.unset,
               webhook_method=values.unset, email=values.unset):
        """
        Create the ExportCustomJobInstance

        :param unicode start_day: The start day for the custom export specified as a string in the format of yyyy-mm-dd
        :param unicode end_day: The end day for the custom export specified as a string in the format of yyyy-mm-dd. End day is inclusive and must be 2 days earlier than the current UTC day.
        :param unicode friendly_name: The friendly name specified when creating the job
        :param unicode webhook_url: The optional webhook url called on completion of the job. If this is supplied, `WebhookMethod` must also be supplied.
        :param unicode webhook_method: This is the method used to call the webhook on completion of the job. If this is supplied, `WebhookUrl` must also be supplied.
        :param unicode email: The optional email to send the completion notification to

        :returns: The created ExportCustomJobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance
        """
        data = values.of({
            'StartDay': start_day,
            'EndDay': end_day,
            'FriendlyName': friendly_name,
            'WebhookUrl': webhook_url,
            'WebhookMethod': webhook_method,
            'Email': email,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ExportCustomJobInstance(
            self._version,
            payload,
            resource_type=self._solution['resource_type'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.ExportCustomJobList>'


class ExportCustomJobPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ExportCustomJobPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param resource_type: The type of communication – Messages, Calls, Conferences, and Participants

        :returns: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobPage
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobPage
        """
        super(ExportCustomJobPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ExportCustomJobInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance
        """
        return ExportCustomJobInstance(
            self._version,
            payload,
            resource_type=self._solution['resource_type'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.ExportCustomJobPage>'


class ExportCustomJobInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, resource_type):
        """
        Initialize the ExportCustomJobInstance

        :returns: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.export_custom_job.ExportCustomJobInstance
        """
        super(ExportCustomJobInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'friendly_name': payload.get('friendly_name'),
            'resource_type': payload.get('resource_type'),
            'start_day': payload.get('start_day'),
            'end_day': payload.get('end_day'),
            'webhook_url': payload.get('webhook_url'),
            'webhook_method': payload.get('webhook_method'),
            'email': payload.get('email'),
            'job_sid': payload.get('job_sid'),
            'details': payload.get('details'),
        }

        # Context
        self._context = None
        self._solution = {'resource_type': resource_type, }

    @property
    def friendly_name(self):
        """
        :returns: The friendly name specified when creating the job
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def resource_type(self):
        """
        :returns: The type of communication – Messages, Calls, Conferences, and Participants
        :rtype: unicode
        """
        return self._properties['resource_type']

    @property
    def start_day(self):
        """
        :returns: The start day for the custom export specified as a string in the format of yyyy-MM-dd
        :rtype: unicode
        """
        return self._properties['start_day']

    @property
    def end_day(self):
        """
        :returns: The end day for the custom export specified as a string in the format of yyyy-MM-dd
        :rtype: unicode
        """
        return self._properties['end_day']

    @property
    def webhook_url(self):
        """
        :returns: The optional webhook url called on completion
        :rtype: unicode
        """
        return self._properties['webhook_url']

    @property
    def webhook_method(self):
        """
        :returns: This is the method used to call the webhook
        :rtype: unicode
        """
        return self._properties['webhook_method']

    @property
    def email(self):
        """
        :returns: The optional email to send the completion notification to
        :rtype: unicode
        """
        return self._properties['email']

    @property
    def job_sid(self):
        """
        :returns: The unique job_sid returned when the custom export was created. This can be used to look up the status of the job.
        :rtype: unicode
        """
        return self._properties['job_sid']

    @property
    def details(self):
        """
        :returns: The details
        :rtype: dict
        """
        return self._properties['details']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.ExportCustomJobInstance>'
