/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qbs.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <language/qualifiedid.h>
#include <tools/set.h>
#include <tools/pimpl.h>

#include <unordered_map>
#include <utility>

namespace qbs::Internal {
class Item;
class LoaderState;

// Sets up Group items for the actual resolving stage. Responsibilities:
//   - Moving Group items located in modules over to the product.
//   - Identifying groups declaring target artifacts and marking them accordingly.
//   - Setting up group-level module instances to ensure proper resolving of per-group module
//     properties.
//   - As a side effect of the above point, collecting all properties set on the Group level
//     to help the ProjectResolver decide which properties need to be re-evaluated at all,
//     which is an important optimization (see commit 9cd8653eef).
class GroupsHandler
{
public:
    GroupsHandler(LoaderState &loaderState);
    ~GroupsHandler();

    void setupGroups(Item *product, Item *productScope);
    std::unordered_map<const Item *, QualifiedIdSet> modulePropertiesSetInGroups() const;
    Set<Item *> disabledGroups() const;

    void printProfilingInfo(int indent);

private:
    class Private;
    Pimpl<Private> d;
};

} // namespace qbs::Internal
