/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "edituserinfodlg.h"

#include "pixlabel.h"
#include "userinfo.h"
#include "qchaticon.h"

#include "globals.h"
#include "qchatsettings.h"

EditUserInfoDlg::EditUserInfoDlg(QWidget *parent) :
  QDialog          (parent),
  m_profileName    (""),
  m_photoFilename  (""),
  m_pictureFilename(""),
  m_edited         (false),
  m_readOnly       (false)
{
  QHBoxLayout* hbox = new QHBoxLayout(0);

  m_applyLab           = new QLabel(this);
  m_okLab              = new QLabel(this);
  m_cancelLab          = new QLabel(this);
  m_photoLab           = new QLabel(this);
  m_pictureLab         = new QLabel(this);
  m_nickLab            = new QLabel(this);
  m_lastNameLab        = new QLabel(this);
  m_firstNameLab       = new QLabel(this);
  m_secondNameLab      = new QLabel(this);
  m_bornLab            = new QLabel(this);
  m_addressLab         = new QLabel(this);
  m_homePhoneLab       = new QLabel(this);
  m_workPhoneLab       = new QLabel(this);
  m_mobilePhoneLab     = new QLabel(this);
  m_emailLab           = new QLabel(this);
  m_icqLab             = new QLabel(this);
  m_homepageLab        = new QLabel(this);
  m_aboutLab           = new QLabel(this);
  m_genderLab          = new QLabel(this);

  m_grid               = new QGridLayout(this);
  m_lastNameEdit       = new QLineEdit(this);
  m_firstNameEdit      = new QLineEdit(this);
  m_secondNameEdit     = new QLineEdit(this);
  m_nickNameEdit       = new QLineEdit(this);
  m_homePhoneEdit      = new QLineEdit(this);
  m_workPhoneEdit      = new QLineEdit(this);
  m_mobilePhoneEdit    = new QLineEdit(this);
  m_e_mailEdit         = new QLineEdit(this);
  m_homepageEdit       = new QLineEdit(this);
  m_icqEdit            = new QLineEdit(this);
  m_dateOfBornEdit     = new QDateEdit(this);
  m_addressEdit        = new QLineEdit(this);
  m_aboutInfoEdit      = new QTextEdit(this);
  m_applyBtn           = new QPushButton(this);
  m_okBtn              = new QPushButton(this);
  m_cancelBtn          = new QPushButton(this);
  m_setPhoto           = new PixLabel   ("", this);
  m_setPic             = new PixLabel   ("", this);
  m_statusLab          = new QLabel     (this);
  mw_statusDescription = new QLineEdit  (this);
  m_genderCmbx         = new QComboBox  (this);


  // col 0 1
  m_grid->addWidget(m_genderLab    , 0, 0);
  m_grid->addWidget(m_nickLab      , 1, 0);
  m_grid->addWidget(m_lastNameLab  , 2, 0);
  m_grid->addWidget(m_firstNameLab , 3, 0);
  m_grid->addWidget(m_secondNameLab, 4, 0);
  m_grid->addWidget(m_bornLab      , 5, 0);
  m_grid->addWidget(m_addressLab   , 6, 0);

  m_genderCmbx->setMinimumWidth(100);
  m_grid->addWidget(m_genderCmbx     , 0, 1);

  m_nickNameEdit->setMinimumWidth(100);
  m_grid->addWidget(m_nickNameEdit   , 1, 1);

  m_lastNameEdit->setMinimumWidth(100);
  m_grid->addWidget(m_lastNameEdit   , 2, 1);

  m_firstNameEdit->setMinimumWidth(100);
  m_grid->addWidget(m_firstNameEdit  , 3, 1);

  m_secondNameEdit->setMinimumWidth(100);
  m_grid->addWidget(m_secondNameEdit , 4, 1);

  m_dateOfBornEdit->setMinimumWidth(100);
  m_grid->addWidget(m_dateOfBornEdit , 5, 1);

  m_addressEdit->setMinimumWidth(100);
  m_grid->addWidget(m_addressEdit    , 6, 1, 1, 3);

  // col 2 3
  m_grid->addWidget(m_homePhoneLab  , 0, 2);
  m_grid->addWidget(m_workPhoneLab  , 1, 2);
  m_grid->addWidget(m_mobilePhoneLab, 2, 2);
  m_grid->addWidget(m_emailLab      , 3, 2);
  m_grid->addWidget(m_icqLab        , 4, 2);
  m_grid->addWidget(m_homepageLab   , 5, 2);

  m_grid->addWidget(m_homePhoneEdit  , 0, 3);
  m_homePhoneEdit  ->setMinimumWidth(100);

  m_grid->addWidget(m_workPhoneEdit  , 1, 3);
  m_workPhoneEdit  ->setMinimumWidth(100);

  m_grid->addWidget(m_mobilePhoneEdit, 2, 3);
  m_mobilePhoneEdit->setMinimumWidth(100);

  m_grid->addWidget(m_e_mailEdit     , 3, 3);
  m_e_mailEdit     ->setMinimumWidth(100);

  m_grid->addWidget(m_icqEdit        , 4, 3);
  m_icqEdit        ->setMinimumWidth(100);

  m_grid->addWidget(m_homepageEdit   , 5, 3);
  m_homepageEdit   ->setMinimumWidth(100);

  m_grid->addWidget(m_photoLab  , 7, 0, 1, 2);
  m_grid->addWidget(m_pictureLab, 7, 2, 1, 2);

  m_setPhoto  ->setMinimumWidth (260);
  m_setPhoto  ->setMinimumHeight(195);
  m_setPhoto  ->setMaximumWidth (260);
  m_setPhoto  ->setMaximumHeight(195);
  m_setPic    ->setMinimumWidth (260);
  m_setPic    ->setMinimumHeight(195);
  m_setPic    ->setMaximumWidth (260);
  m_setPic    ->setMaximumHeight(195);

  m_grid->addWidget(m_setPhoto   , 8, 0, 1, 2);
  m_grid->addWidget(m_setPic     , 8, 2, 1, 2);

  m_grid->addWidget(m_aboutLab, 9, 0, 1, 2);
  m_grid->addWidget(m_aboutInfoEdit, 10, 0, 1, 4);
  m_aboutInfoEdit->setMinimumHeight(150);
  m_aboutInfoEdit->setMaximumHeight(1500);
  m_aboutInfoEdit->setMaximumWidth (1500);

  hbox->addWidget(m_statusLab         );
  hbox->addWidget(mw_statusDescription);
  m_grid->addLayout(hbox, 11, 0, 1, 4);
  mw_statusDescription->setReadOnly(true);

  m_grid->addWidget(m_okBtn    , 0, 4);
  m_grid->addWidget(m_applyBtn , 1, 4);
  m_grid->addWidget(m_cancelBtn, 2, 4);

  m_grid->setColumnStretch(0, 1);
  m_grid->setColumnStretch(1, 2);
  m_grid->setColumnStretch(2, 1);
  m_grid->setColumnStretch(3, 2);

  m_grid->setRowStretch(8, 1);
  m_grid->setRowStretch(10, 2);

  m_aboutInfoEdit->setMaximumWidth(1000);
  m_aboutInfoEdit->setMaximumHeight(1000);
  m_aboutInfoEdit->resize(300, 200);

  setTabOrder(m_nickNameEdit   , m_lastNameEdit);
  setTabOrder(m_lastNameEdit   , m_firstNameEdit);
  setTabOrder(m_firstNameEdit  , m_secondNameEdit);
  setTabOrder(m_dateOfBornEdit , m_addressEdit);
  setTabOrder(m_addressEdit    , m_homePhoneEdit);
  setTabOrder(m_homePhoneEdit  , m_workPhoneEdit);
  setTabOrder(m_workPhoneEdit  , m_mobilePhoneEdit);
  setTabOrder(m_mobilePhoneEdit, m_e_mailEdit);
  setTabOrder(m_e_mailEdit     , m_icqEdit);
  setTabOrder(m_icqEdit        , m_homepageEdit);
  setTabOrder(m_homepageEdit   , m_aboutInfoEdit);
  setTabOrder(m_aboutInfoEdit  , m_okBtn);
  setTabOrder(m_okBtn          , m_applyBtn);
  setTabOrder(m_applyBtn       , m_cancelBtn);

  m_applyBtn ->setEnabled(false);
  m_okBtn    ->setDefault(false);
  m_applyBtn ->setDefault(true);
  m_cancelBtn->setDefault(false);

  m_dateOfBornEdit->setDisplayFormat("dd / MMM / yyyy");

  connect(m_okBtn          , SIGNAL(clicked())                 , this, SLOT  (slot_sendInfo()));
  connect(m_okBtn          , SIGNAL(clicked())                 , this, SLOT  (slot_accept  ()));
  connect(m_okBtn          , SIGNAL(clicked())                 , this, SIGNAL(infoChanged  ()));
  connect(m_applyBtn       , SIGNAL(clicked())                 , this, SLOT  (slot_sendInfo()));
  connect(m_applyBtn       , SIGNAL(clicked())                 , this, SIGNAL(infoChanged  ()));
  connect(m_cancelBtn      , SIGNAL(clicked())                 , this, SLOT  (slot_cancel  ()));
  connect(m_nickNameEdit   , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_lastNameEdit   , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_firstNameEdit  , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_secondNameEdit , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_dateOfBornEdit , SIGNAL(dateChanged(const QDate  )), this, SLOT  (slot_edited()));
  connect(m_addressEdit    , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_homePhoneEdit  , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_workPhoneEdit  , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_mobilePhoneEdit, SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_e_mailEdit     , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_icqEdit        , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_homepageEdit   , SIGNAL(textEdited(const QString )), this, SLOT  (slot_edited()));
  connect(m_aboutInfoEdit  , SIGNAL(textChanged(             )), this, SLOT  (slot_edited()));
  connect(m_setPic         , SIGNAL(changed    (             )), this, SLOT  (slot_edited()));
  connect(m_setPhoto       , SIGNAL(changed    (             )), this, SLOT  (slot_edited()));
  connect(m_genderCmbx     , SIGNAL(currentIndexChanged(int))  , this, SLOT  (slot_edited()));

  retranslate();
}
//\*****************************************************************************
EditUserInfoDlg::~EditUserInfoDlg()
{
  qDebug("[~EditUserInfoDlg]");
}
//\*****************************************************************************
void EditUserInfoDlg::slot_sendInfo()
{
  if(QChatSettings::profileName() == m_profileName)
  {
    UserInfo::myInfo()->setLastName   (m_lastNameEdit   ->text());
    UserInfo::myInfo()->setFirstName  (m_firstNameEdit  ->text());
    UserInfo::myInfo()->setSecondName (m_secondNameEdit ->text());
    UserInfo::myInfo()->setDateOfBorn (m_dateOfBornEdit ->date());
    UserInfo::myInfo()->setAddress    (m_addressEdit    ->text());
    UserInfo::myInfo()->setHomePhone  (m_homePhoneEdit  ->text());
    UserInfo::myInfo()->setWorkPhone  (m_workPhoneEdit  ->text());
    UserInfo::myInfo()->setMobilePhone(m_mobilePhoneEdit->text());
    UserInfo::myInfo()->setE_mail     (m_e_mailEdit     ->text());
    UserInfo::myInfo()->setICQ        (m_icqEdit        ->text());
    UserInfo::myInfo()->setHomepage   (m_homepageEdit   ->text());
    UserInfo::myInfo()->setAboutInfo  (m_aboutInfoEdit  ->toPlainText());
    UserInfo::myInfo()->setPhoto      (m_setPhoto       ->filename());
    UserInfo::myInfo()->setPicture    (m_setPic         ->filename());
    UserInfo::myInfo()->setGender     (m_genderCmbx     ->itemData(m_genderCmbx->currentIndex()).toInt());

    if(QChatSettings::settings()->mode() == QChatSettings::Server)
      emit wantChangeNickname(m_nickNameEdit->text());

    else
    {
      UserInfo::myInfo()->setNickname (m_nickNameEdit   ->text());
      emit nickNameChanged(m_nickNameEdit   ->text());
    }
  }

  m_applyBtn ->setEnabled(false);
  m_edited = false;
}
//\*****************************************************************************
void EditUserInfoDlg::slot_accept()
{
  m_setPhoto->freePixmap();
  m_setPic  ->freePixmap();
  accept();
}
//\*****************************************************************************
void EditUserInfoDlg::slot_cancel()
{
  slot_notEdited();
  m_setPhoto->freePixmap();
  m_setPic  ->freePixmap();
  reject();
}
//\*****************************************************************************
void EditUserInfoDlg::slot_loadInfo (const UserInfo* info)
{
  QPixmap* pix;

  m_userUid = info->uid();

  m_nickNameEdit   ->setText         (info->nickname       ());
  m_firstNameEdit  ->setText         (info->firstName      ());
  m_lastNameEdit   ->setText         (info->lastName       ());
  m_secondNameEdit ->setText         (info->secondName     ());
  m_dateOfBornEdit ->setDate(QDate(1900, 1, 1));
  m_dateOfBornEdit ->setDate         (info->dateOfBorn     ());
  m_addressEdit    ->setText         (info->address        ());
  m_homePhoneEdit  ->setText         (info->homePhone      ());
  m_workPhoneEdit  ->setText         (info->workPhone      ());
  m_mobilePhoneEdit->setText         (info->mobilePhone    ());
  m_e_mailEdit     ->setText         (info->e_mail         ());
  m_icqEdit        ->setText         (info->icq            ());
  m_homepageEdit   ->setText         (info->homepage       ());
  m_aboutInfoEdit  ->setPlainText    (info->aboutInfo      ());

  pix = info->newPhoto();
  m_setPhoto       ->slot_setPixmap  (*pix);
  delete pix;

  pix = info->newPicture();
  m_setPic         ->slot_setPixmap  (*pix);
  delete pix;

  m_setPic         ->slot_setLastdir (info->pictureFilename());
  m_setPhoto       ->slot_setLastdir (info->photoFilename  ());
  m_setPic         ->slot_setFilename(info->pictureFilename());
  m_setPhoto       ->slot_setFilename(info->photoFilename  ());
  m_statusLab      ->setText(tr("Status (") + Globals::StatusStr[info->status()] + ") : ");

  if(m_readOnly)
    mw_statusDescription->setText(info->statusDescription());
  else
    mw_statusDescription->setText(QChatSettings::settings()->statusDescription(info->status()));

  m_profileName = QChatSettings::profileName();

  if(!m_readOnly)
    setWindowTitle(tr("Edit user details [Profile: ") + m_profileName + "]");
  else
    setWindowTitle(tr("User details"));

  switch(info->gender())
  {
    case 'm' : m_genderCmbx->setCurrentIndex(0); break;
    case 'f' : m_genderCmbx->setCurrentIndex(1); break;
    default  : m_genderCmbx->setCurrentIndex(2);
  }

  slot_notEdited();
}
//\*****************************************************************************
void EditUserInfoDlg::setReadOnly(bool ro)
{
  m_readOnly = ro;

  if(ro == true)
  {
    m_okBtn   ->hide();
    m_applyBtn->hide();
    m_grid->removeWidget (m_okBtn          );
    m_grid->removeWidget (m_cancelBtn      );
    m_grid->addWidget    (m_cancelBtn, 0, 4);
    m_cancelBtn->setText(tr("&Ok")       );
    setWindowTitle(tr("User Details"));
  }
  else
  {
    m_grid->removeWidget (m_okBtn          );
    m_grid->removeWidget (m_cancelBtn      );
    m_grid->addWidget    (m_okBtn    , 0, 4);
    m_grid->addWidget    (m_cancelBtn, 2, 4);
    m_cancelBtn->setText(tr("&Cancel")   );
    m_okBtn   ->show();
    m_applyBtn->show();
    setWindowTitle(tr("Edit User Details"));
  }

  m_lastNameEdit    ->setReadOnly(ro);
  m_firstNameEdit   ->setReadOnly(ro);
  m_secondNameEdit  ->setReadOnly(ro);
  m_nickNameEdit    ->setReadOnly(ro);
  m_homePhoneEdit   ->setReadOnly(ro);
  m_workPhoneEdit   ->setReadOnly(ro);
  m_mobilePhoneEdit ->setReadOnly(ro);
  m_e_mailEdit      ->setReadOnly(ro);
  m_homepageEdit    ->setReadOnly(ro);
  m_icqEdit         ->setReadOnly(ro);
  m_dateOfBornEdit  ->setReadOnly(ro);
  m_addressEdit     ->setReadOnly(ro);
  m_setPhoto        ->setReadOnly(ro);
  m_setPic          ->setReadOnly(ro);
  m_aboutInfoEdit   ->setReadOnly(ro);
  m_genderCmbx      ->setEnabled(!ro);
}
//\*****************************************************************************
void EditUserInfoDlg::retranslate()
{
  m_applyBtn      ->setText(tr("&Apply"));
  m_okBtn         ->setText(tr("&Ok"));
  m_cancelBtn     ->setText(tr("&Cancel"));
  m_setPhoto      ->setTextLabel(tr("No Photo"));
  m_setPic        ->setTextLabel(tr("No Picture"));

  m_nickLab       ->setText(tr("Nickname:"));
  m_lastNameLab   ->setText(tr("Last Name:"));
  m_firstNameLab  ->setText(tr("First Name:"));
  m_secondNameLab ->setText(tr("Second Name:"));
  m_bornLab       ->setText(tr("Date of Born:"));
  m_addressLab    ->setText(tr("Address:"));
  m_homePhoneLab  ->setText(tr("Home Phone:"));
  m_workPhoneLab  ->setText(tr("Work Phone:" ));
  m_mobilePhoneLab->setText(tr("Mobile Phone:"));
  m_emailLab      ->setText(tr("e-mail:"));
  m_icqLab        ->setText(tr("ICQ:"));
  m_homepageLab   ->setText(tr("Homepage:"));
  m_aboutLab      ->setText(tr("About:"));

  m_pictureLab    ->setText(tr("Picture:"));
  m_photoLab      ->setText(tr("Photo:"));
  m_genderLab     ->setText(tr("Gender:"));

  m_genderCmbx->clear();
  // FIXME move to setIcons ":/
  m_genderCmbx->addItem(QChatIcon::icon("user-male")  , tr("Male")    , 'm');
  m_genderCmbx->addItem(QChatIcon::icon("user-female"), tr("Female")  , 'f');
  m_genderCmbx->addItem(QChatIcon::icon("unknown")    , tr("Not Sure"), -1);

  setWindowTitle(tr("Edit user details"));
}
