% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseries-tidiers.R
\name{glance.garch}
\alias{glance.garch}
\title{Tidy a(n) garch object}
\usage{
\method{glance}{garch}(x, test = c("box-ljung-test", "jarque-bera-test"), ...)
}
\arguments{
\item{x}{A \code{garch} object returned by \code{\link[tseries:garch]{tseries::garch()}}.}

\item{test}{Character specification of which hypothesis test to use. The
\code{garch} function reports 2 hypothesis tests: Jarque-Bera to residuals
and Box-Ljung to squared residuals.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{statistic}{Test statistic used to compute the p-value}
\item{p.value}{P-value}
\item{parameter}{Parameter field in the htest, typically degrees of
freedom}
\item{method}{Method used to compute the statistic as a string}
\item{logLik}{the data's log-likelihood under the model}
\item{AIC}{the Akaike Information Criterion}
\item{BIC}{the Bayesian Information Criterion}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[tseries:garch]{tseries::garch()}}, []

Other garch tidiers: 
\code{\link{tidy.garch}()}
}
\concept{garch tidiers}
