% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-unquote-identifier.R
\docType{data}
\name{spec_sql_unquote_identifier}
\alias{spec_sql_unquote_identifier}
\title{spec_sql_unquote_identifier}
\value{
\code{dbUnquoteIdentifier()} returns a list of objects
of the same length as the input.
For an empty vector, this function returns a length-0 object.
The names of the input argument are preserved in the output.
If \code{x} is a value returned by \code{dbUnquoteIdentifier()},
calling \code{dbUnquoteIdentifier(..., dbQuoteIdentifier(..., x))}
returns \code{list(x)}.
If \code{x} is an object of class \link{Id},
calling \code{dbUnquoteIdentifier(..., x)} returns \code{list(x)}.
(For backends it may be most convenient to return \link{Id} objects
to achieve this behavior, but this is not required.)

Plain character vectors can also be passed to \code{dbUnquoteIdentifier()}.
}
\description{
spec_sql_unquote_identifier
}
\section{Failure modes}{


An error is raised if a character vectors with a missing value is passed
as the \code{x} argument.
}

\section{Specification}{

For any character vector of length one, quoting (with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}})
then unquoting then quoting the first element is identical to just quoting.
This is also true for strings that
contain special characters such as a space,
a dot,
a comma,
or quotes used to mark strings
or identifiers,
if the database supports this.

Unquoting simple strings (consisting of only letters) wrapped with \code{\link[=SQL]{SQL()}}
and then quoting via \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} gives the same result as just
quoting the string.
Similarly, unquoting expressions of the form \code{SQL("schema.table")}
and then quoting gives the same result as quoting the identifier
constructed by \code{Id("schema", "table")}.
}

\seealso{
Other sql specifications: 
\code{\link{spec_sql_append_table}},
\code{\link{spec_sql_create_table}},
\code{\link{spec_sql_exists_table}},
\code{\link{spec_sql_list_fields}},
\code{\link{spec_sql_list_objects}},
\code{\link{spec_sql_list_tables}},
\code{\link{spec_sql_quote_identifier}},
\code{\link{spec_sql_quote_literal}},
\code{\link{spec_sql_quote_string}},
\code{\link{spec_sql_read_table}},
\code{\link{spec_sql_remove_table}},
\code{\link{spec_sql_write_table}}
}
\concept{sql specifications}
