% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_last_edges_created.R
\name{get_last_edges_created}
\alias{get_last_edges_created}
\title{Get the last set of edges created in a graph}
\usage{
get_last_edges_created(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A vector of edge ID values.
}
\description{
Get the last edges that were created in a graph object of class \code{dgr_graph}.
This function should ideally be used just after creating the edges.
}
\examples{
# Create a graph and add a cycle and then
# a tree in 2 separate function calls
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 3,
    rel = "a") \%>\%
  add_balanced_tree(
    k = 2, h = 2,
    rel = "b")

# Get the last edges created (all edges
# from the tree)
graph \%>\% get_last_edges_created()

}
