% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-specification.R
\name{cell-specification}
\alias{cell-specification}
\alias{cell_limits}
\alias{cell_rows}
\alias{cell_cols}
\alias{anchored}
\title{Specify cells}
\description{
Many functions in googlesheets4 use a \code{range} argument to target specific
cells. The Sheets v4 API expects user-specified ranges to be expressed via
\href{https://developers.google.com/sheets/api/guides/concepts#a1_notation}{its A1 notation},
but googlesheets4 accepts and converts a few alternative specifications
provided by the functions in the \link{cellranger} package. Of course,
you can always provide A1-style ranges directly to functions like
\code{\link[=read_sheet]{read_sheet()}} or \code{\link[=range_read_cells]{range_read_cells()}}. Why would you use the
\link{cellranger} helpers? Some ranges are practically impossible to
express in A1 notation, specifically when you want to describe rectangles
with some bounds that are specified and others determined by the data.
}
\examples{
if (gs4_has_token() && interactive()) {
  ss <- gs4_example("mini-gap")

  # Specify only the rows or only the columns
  read_sheet(ss, range = cell_rows(1:3))
  read_sheet(ss, range = cell_cols("C:D"))
  read_sheet(ss, range = cell_cols(1))

  # Specify upper or lower bound on row or column
  read_sheet(ss, range = cell_rows(c(NA, 4)))
  read_sheet(ss, range = cell_cols(c(NA, "D")))
  read_sheet(ss, range = cell_rows(c(3, NA)))
  read_sheet(ss, range = cell_cols(c(2, NA)))
  read_sheet(ss, range = cell_cols(c("C", NA)))

  # Specify a partially open rectangle
  read_sheet(ss, range = cell_limits(c(2, 3), c(NA, NA)), col_names = FALSE)
  read_sheet(ss, range = cell_limits(c(1, 2), c(NA, 4)))
}
}
