% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector2string.R
\name{vector2string}
\alias{vector2string}
\title{Collapse vector to string}
\usage{
vector2string(
  x,
  quotation_mark = "'",
  collapse = sprintf("\%s, \%s", quotation_mark, quotation_mark)
)
}
\arguments{
\item{x}{The vector to collapse}

\item{quotation_mark}{The type of quote to use}

\item{collapse}{The string that separates each element}
}
\value{
A string with \code{', '} separation
}
\description{
Merges all the values and outputs a string
formatted as '1st element', '2nd element', ...
}
\examples{
vector2string(1:4)
vector2string(c("a","b'b", "c"))
vector2string(c("a","b'b", "c"), quotation_mark = '"')
}
