% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mine_stat}
\alias{mine_stat}
\title{This is an helper function to compute one \code{mine} statistic.
It take two vectors of the same dimension as an input.}
\usage{
mine_stat(x, y, alpha = 0.6, C = 15, est = "mic_approx",
  measure = "mic", eps = NA_real_, p = -1, norm = FALSE)
}
\arguments{
\item{x}{Numeric Vector of size \code{n}}

\item{y}{Numeric Vector of size \code{n}}

\item{alpha}{numeric value representing parameter for the mine statistic see \code{\link[minerva]{mine}}}

\item{C}{c parameter for the mine statistic see \code{\link[minerva]{mine}}}

\item{est}{character estimation parameter for the mine statistic.
Possible values are \code{"mic_approx"} or \code{"mic_e"}}

\item{measure}{integer indicating which measure to return
available measures are: \code{mic, mas, mev, mcn, tic, gmic}. The string could be also uppercase.
For measure \code{mic-r2} see details.}

\item{eps}{eps value for MCN statistic should be in (0,1). If NA (default) is passed then the normal MCN statistic is returned.}

\item{p}{probability for the generalized mic}

\item{norm}{boolean if require normalization between 0 and 1 for the \code{tic} statistic}
}
\description{
This is an helper function to compute one \code{mine} statistic.
It take two vectors of the same dimension as an input.
}
\details{
This is a wrapper function to compute the mine statistic between two variables.
for more details on the available measure and the meaning of the other parameters see also the 
documentation for the \code{\link[minerva]{mine}} function.

For measure \code{mic-r2} use the Pearson R coefficient score \code{\link[stats]{cor}} and the measure \code{mic}. 
See the example below.
}
\examples{
x <- runif(10); y <- 3*x+2;
mine_stat(x,y, measure="mic")

## Measure mic-r2
x <- matrix(rnorm(20), ncol=2, nrow=10)
mmic <- mine_stat(x[,1], x[,2], measure="mic")
r2 <- cor(x[,1], x[,2])

mmic - r2**2

}
\seealso{
\code{\link[minerva]{mine}}
}
