% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_itemscale.R
\name{check_itemscale}
\alias{check_itemscale}
\title{Describe Properties of Item Scales}
\usage{
check_itemscale(x, factor_index = NULL)
}
\arguments{
\item{x}{An object of class \code{parameters_pca}, as returned by
\code{\link[parameters:principal_components]{parameters::principal_components()}}, or a data frame.}

\item{factor_index}{If \code{x} is a data frame, \code{factor_index} must be specified.
It must be a numeric vector of same length as number of columns in \code{x}, where
each element is the index of the factor to which the respective column in \code{x}.}
}
\value{
A list of data frames, with related measures of internal
consistencies of each subscale.
}
\description{
Compute various measures of internal consistencies
applied to (sub)scales, which items were extracted using
\code{parameters::principal_components()}.
}
\details{
\code{check_itemscale()} calculates various measures of internal
consistencies, such as Cronbach's alpha, item difficulty or discrimination
etc. on subscales which were built from several items. Subscales are
retrieved from the results of \code{\link[parameters:principal_components]{parameters::principal_components()}}, i.e.
based on how many components were extracted from the PCA,
\code{check_itemscale()} retrieves those variables that belong to a component
and calculates the above mentioned measures.
}
\note{
\itemize{
\item \emph{Item difficulty} should range between 0.2 and 0.8. Ideal value
is \code{p+(1-p)/2} (which mostly is between 0.5 and 0.8). See
\code{\link[=item_difficulty]{item_difficulty()}} for details.
\item For \emph{item discrimination}, acceptable values are 0.20 or higher;
the closer to 1.00 the better. See \code{\link[=item_reliability]{item_reliability()}} for more
details.
\item In case the total \emph{Cronbach's alpha} value is below the acceptable
cut-off of 0.7 (mostly if an index has few items), the
\emph{mean inter-item-correlation} is an alternative measure to indicate
acceptability. Satisfactory range lies between 0.2 and 0.4. See also
\code{\link[=item_intercor]{item_intercor()}}.
}
}
\examples{
\dontshow{if (require("parameters") && require("psych")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# data generation from '?prcomp', slightly modified
C <- chol(S <- toeplitz(0.9^(0:15)))
set.seed(17)
X <- matrix(rnorm(1600), 100, 16)
Z <- X \%*\% C

pca <- parameters::principal_components(
  as.data.frame(Z),
  rotation = "varimax",
  n = 3
)
pca
check_itemscale(pca)

# as data frame
check_itemscale(
  as.data.frame(Z),
  factor_index = parameters::closest_component(pca)
)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Briggs SR, Cheek JM (1986) The role of factor analysis in the development
and evaluation of personality scales. Journal of Personality, 54(1),
106-148. doi: 10.1111/j.1467-6494.1986.tb00391.x
}
}
