% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.pconsecutive_pbalanced.R
\name{is.pbalanced}
\alias{is.pbalanced}
\alias{is.pbalanced.default}
\alias{is.pbalanced.data.frame}
\alias{is.pbalanced.pdata.frame}
\alias{is.pbalanced.pseries}
\alias{is.pbalanced.pggls}
\alias{is.pbalanced.pcce}
\alias{is.pbalanced.pmg}
\alias{is.pbalanced.pgmm}
\alias{is.pbalanced.panelmodel}
\title{Check if data are balanced}
\usage{
is.pbalanced(x, ...)

\method{is.pbalanced}{default}(x, y, ...)

\method{is.pbalanced}{data.frame}(x, index = NULL, ...)

\method{is.pbalanced}{pdata.frame}(x, ...)

\method{is.pbalanced}{pseries}(x, ...)

\method{is.pbalanced}{pggls}(x, ...)

\method{is.pbalanced}{pcce}(x, ...)

\method{is.pbalanced}{pmg}(x, ...)

\method{is.pbalanced}{pgmm}(x, ...)

\method{is.pbalanced}{panelmodel}(x, ...)
}
\arguments{
\item{x}{an object of class \code{pdata.frame}, \code{data.frame},
\code{pseries}, \code{panelmodel}, or \code{pgmm},}

\item{\dots}{further arguments.}

\item{y}{(only in default method) the time index variable (2nd index
variable),}

\item{index}{only relevant for \code{data.frame} interface; if
\code{NULL}, the first two columns of the data.frame are
assumed to be the index variables; if not \code{NULL}, both
dimensions ('individual', 'time') need to be specified by
\code{index} as character of length 2 for data frames, for
further details see \code{\link[=pdata.frame]{pdata.frame()}},}
}
\value{
A logical indicating whether the data associated with
object \code{x} are balanced (\code{TRUE}) or not
(\code{FALSE}).
}
\description{
This function checks if the data are balanced, i.e., if each individual has
the same time periods
}
\details{
Balanced data are data for which each individual has the same time periods.
The returned values of the \code{is.pbalanced(object)} methods are identical
to \code{pdim(object)$balanced}.  \code{is.pbalanced} is provided as a short
cut and is faster than \code{pdim(object)$balanced} because it avoids those
computations performed by \code{pdim} which are unnecessary to determine the
balancedness of the data.
}
\examples{

# take balanced data and make it unbalanced
# by deletion of 2nd row (2nd time period for first individual)
data("Grunfeld", package = "plm")
Grunfeld_missing_period <- Grunfeld[-2, ]
is.pbalanced(Grunfeld_missing_period)     # check if balanced: FALSE
pdim(Grunfeld_missing_period)$balanced    # same

# pdata.frame interface
pGrunfeld_missing_period <- pdata.frame(Grunfeld_missing_period)
is.pbalanced(Grunfeld_missing_period)

# pseries interface
is.pbalanced(pGrunfeld_missing_period$inv)

}
\seealso{
\code{\link[=punbalancedness]{punbalancedness()}} for two measures of
unbalancedness, \code{\link[=make.pbalanced]{make.pbalanced()}} to make data
balanced; \code{\link[=is.pconsecutive]{is.pconsecutive()}} to check if data are
consecutive; \code{\link[=make.pconsecutive]{make.pconsecutive()}} to make data
consecutive (and, optionally, also balanced).\cr
\code{\link[=pdim]{pdim()}} to check the dimensions of a 'pdata.frame'
(and other objects), \code{\link[=pvar]{pvar()}} to check for individual
and time variation of a 'pdata.frame' (and other objects),
\code{\link[=pseries]{pseries()}}, \code{\link[=data.frame]{data.frame()}},
\code{\link[=pdata.frame]{pdata.frame()}}.
}
\keyword{attribute}
