% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-error.R, R/cnd.R
\name{error_cnd}
\alias{error_cnd}
\alias{cnd}
\alias{warning_cnd}
\alias{message_cnd}
\title{Create a condition object}
\usage{
error_cnd(.subclass = NULL, ..., message = "", trace = NULL, parent = NULL)

cnd(class, ..., message = "", .subclass)

warning_cnd(class = NULL, ..., message = "", .subclass)

message_cnd(class = NULL, ..., message = "", .subclass)
}
\arguments{
\item{.subclass}{This argument was renamed to \code{class} in rlang
0.4.2.  It will be deprecated in the next major version. This is
for consistency with our conventions for class constructors
documented in \url{https://adv-r.hadley.nz/s3.html#s3-subclassing}.}

\item{...}{<\link[=dyn-dots]{dynamic}> Named data fields stored inside
the condition object.}

\item{message}{A default message to inform the user about the
condition when it is signalled.}

\item{trace}{A \code{trace} object created by \code{\link[=trace_back]{trace_back()}}.}

\item{parent}{A parent condition object created by \code{\link[=abort]{abort()}}.}

\item{class}{The condition subclass.}
}
\description{
These constructors make it easy to create subclassed conditions.
Conditions are objects that power the error system in R. They can
also be used for passing messages to pre-established handlers.
}
\details{
\code{cnd()} creates objects inheriting from \code{condition}. Conditions
created with \code{error_cnd()}, \code{warning_cnd()} and \code{message_cnd()}
inherit from \code{error}, \code{warning} or \code{message}.
}
\section{Lifecycle}{


The \code{.type} and \code{.msg} arguments have been renamed to \code{.subclass}
and \code{message}. They are deprecated as of rlang 0.3.0.
}

\examples{
# Create a condition inheriting from the s3 type "foo":
cnd <- cnd("foo")

# Signal the condition to potential handlers. Since this is a bare
# condition the signal has no effect if no handlers are set up:
cnd_signal(cnd)

# When a relevant handler is set up, the signal causes the handler
# to be called:
with_handlers(cnd_signal(cnd), foo = exiting(function(c) "caught!"))

# Handlers can be thrown or executed inplace. See with_handlers()
# documentation for more on this.

# Signalling an error condition aborts the current computation:
err <- error_cnd("foo", message = "I am an error")
try(cnd_signal(err))
}
\seealso{
\code{\link[=cnd_signal]{cnd_signal()}}, \code{\link[=with_handlers]{with_handlers()}}.
}
\keyword{internal}
