% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-abort.R
\name{rlang_backtrace_on_error}
\alias{rlang_backtrace_on_error}
\alias{add_backtrace}
\title{Display backtrace on error}
\description{
Errors thrown with \code{\link[=abort]{abort()}} automatically save a backtrace that
can be inspected by calling \code{\link[=last_error]{last_error()}}. Optionally, you can
also display the backtrace alongside the error message by setting
the option \code{rlang_backtrace_on_error} to one of the following
values:
\itemize{
\item \code{"reminder"}: Display a reminder that the backtrace can be
inspected by calling \code{\link[rlang:last_error]{rlang::last_error()}}.
\item \code{"branch"}: Display a simplified backtrace.
\item \code{"collapse"}: Display a collapsed backtrace tree.
\item \code{"full"}: Display the full backtrace tree.
}
}
\section{Promote base errors to rlang errors}{


Call \code{options(error = rlang::entrace)} to instrument base
errors with rlang features. This handler does two things:
\itemize{
\item It saves the base error as an rlang object. This allows you to
call \code{\link[=last_error]{last_error()}} to print the backtrace or inspect its data.
\item It prints the backtrace for the current error according to the
\code{rlang_backtrace_on_error} option.
}
}

\examples{
# Display a simplified backtrace on error for both base and rlang
# errors:

# options(
#   rlang_backtrace_on_error = "branch",
#   error = rlang::entrace
# )
# stop("foo")
}
