% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmissionTrees.R
\name{wiwTreeDist}
\alias{wiwTreeDist}
\title{Transmission tree distance}
\usage{
wiwTreeDist(matList, sampled = NULL)
}
\arguments{
\item{matList}{a list of matrices, each of which is the output of \code{findMRCIs$mrciDepths}}

\item{sampled}{a vector of node IDs which corresponds to those nodes which are sampled cases. Default is to treat all nodes as sampled cases.}
}
\value{
Returns a distance matrix, where entry (i,j) is the transmission tree distance between matrices i and j in \code{matList}
}
\description{
Function to find the distance between transmission trees by comparing their MRCI depth matrices; to be precise, by finding the Euclidean distance between the tree vectors, restricted to their sampled node entries.
}
\examples{
# create some simple "who infected whom" scenarios:
tree1 <- cbind(Infector=1:5,Infectee=2:6) 
tree2 <- cbind(Infector=c(1,5,2,2,3),Infectee=2:6)
tree3 <- cbind(Infector=c(2,2,3,4,5),Infectee=c(1,3,4,5,6)) 
# create list of the MRCI depth matrices:
matList <- lapply(list(tree1,tree2,tree3), function(x) findMRCIs(x)$mrciDepths)

# transmission tree distance, assuming all cases are sampled:
wiwTreeDist(matList)
# transmission tree distance when cases 1, 2 and 4 are sampled:
wiwTreeDist(matList, sampled=c(1,2,4))

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

