% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_multipart.R
\name{parse_multipart}
\alias{parse_multipart}
\title{Parse a multipart/form-data request}
\usage{
parse_multipart(body, boundary)
}
\arguments{
\item{body}{body of the HTTP request. Must be raw or character vector.}

\item{boundary}{boundary string as specified in the \code{Content-Type} request header.}
}
\description{
Parse a multipart/form-data request, which is usually generated from a HTML form
submission. The parameters can include both text values as well as binary files.
They can be distinguished from the presence of a \code{filename} attribute.
}
\details{
A multipart/form-data request consists of a single body which contains one or more
values plus meta-data, separated using a boundary string. This boundary string
is chosen by the client (e.g. the browser) and specified in the \code{Content-Type}
header of the HTTP request. There is no escaping; it is up to the client to choose
a boundary string that does not appear in one of the values.

The parser is written in pure R, but still pretty fast because it uses the regex
engine.
}
\examples{
\dontrun{example form
demo_rhttpd()
}
}
